/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootEnchantFunction
extends LootItemFunctionConditional {
    public static final int NO_LIMIT = 0;
    final NumberProvider value;
    final int limit;

    LootEnchantFunction(LootItemCondition[] var0, NumberProvider var1, int var2) {
        super(var0);
        this.value = var1;
        this.limit = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.LOOTING_ENCHANT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union((Set)ImmutableSet.of(LootContextParameters.KILLER_ENTITY), this.value.getReferencedContextParams());
    }

    boolean hasLimit() {
        return this.limit > 0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Entity var2 = var1.getParamOrNull(LootContextParameters.KILLER_ENTITY);
        if (var2 instanceof EntityLiving) {
            int var3 = EnchantmentManager.getMobLooting((EntityLiving)var2);
            if (var3 == 0) {
                return var0;
            }
            float var4 = (float)var3 * this.value.getFloat(var1);
            var0.grow(Math.round(var4));
            if (this.hasLimit() && var0.getCount() > this.limit) {
                var0.setCount(this.limit);
            }
        }
        return var0;
    }

    public static a lootingMultiplier(NumberProvider var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NumberProvider count;
        private int limit = 0;

        public a(NumberProvider var0) {
            this.count = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a setLimit(int var0) {
            this.limit = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootEnchantFunction(this.getConditions(), this.count, this.limit);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootEnchantFunction> {
        @Override
        public void serialize(JsonObject var0, LootEnchantFunction var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("count", var2.serialize((Object)var1.value));
            if (var1.hasLimit()) {
                var0.add("limit", var2.serialize((Object)var1.limit));
            }
        }

        @Override
        public LootEnchantFunction deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            int var3 = ChatDeserializer.getAsInt(var0, "limit", 0);
            return new LootEnchantFunction(var2, ChatDeserializer.getAsObject(var0, "count", var1, NumberProvider.class), var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

