/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemModifierManager
extends ResourceDataJson {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = LootSerialization.createFunctionSerializer().create();
    private final LootPredicateManager predicateManager;
    private final LootTableRegistry lootTables;
    private Map<MinecraftKey, LootItemFunction> functions = ImmutableMap.of();

    public ItemModifierManager(LootPredicateManager var0, LootTableRegistry var1) {
        super(GSON, "item_modifiers");
        this.predicateManager = var0;
        this.lootTables = var1;
    }

    @Nullable
    public LootItemFunction get(MinecraftKey var0) {
        return this.functions.get(var0);
    }

    public LootItemFunction get(MinecraftKey var0, LootItemFunction var1) {
        return this.functions.getOrDefault(var0, var1);
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var02, IResourceManager var12, GameProfilerFiller var22) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var02.forEach((var1, var2) -> {
            try {
                if (var2.isJsonArray()) {
                    LootItemFunction[] var3 = (LootItemFunction[])GSON.fromJson(var2, LootItemFunction[].class);
                    var3.put(var1, (Object)new a(var3));
                } else {
                    LootItemFunction var3 = (LootItemFunction)GSON.fromJson(var2, LootItemFunction.class);
                    var3.put(var1, (Object)var3);
                }
            }
            catch (Exception var3) {
                LOGGER.error("Couldn't parse item modifier {}", var1, (Object)var3);
            }
        });
        ImmutableMap var4 = var3.build();
        LootCollector var5 = new LootCollector(LootContextParameterSets.ALL_PARAMS, this.predicateManager::get, this.lootTables::get);
        var4.forEach((var1, var2) -> var2.validate(var5));
        var5.getProblems().forEach((var0, var1) -> LOGGER.warn("Found item modifier validation problem in {}: {}", var0, var1));
        this.functions = var4;
    }

    public Set<MinecraftKey> getKeys() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    static class a
    implements LootItemFunction {
        protected final LootItemFunction[] functions;
        private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

        public a(LootItemFunction[] var0) {
            this.functions = var0;
            this.compositeFunction = LootItemFunctions.compose(var0);
        }

        @Override
        public ItemStack apply(ItemStack var0, LootTableInfo var1) {
            return this.compositeFunction.apply(var0, var1);
        }

        @Override
        public LootItemFunctionType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object apply(Object object, Object object2) {
            return this.apply((ItemStack)object, (LootTableInfo)object2);
        }
    }
}

