/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAP_SIZE = 128;
    private static final int HALF_MAP_SIZE = 64;
    public static final int MAX_SCALE = 4;
    public static final int TRACKED_DECORATION_LIMIT = 256;
    public int x;
    public int z;
    public ResourceKey<World> dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public boolean locked;
    public final List<WorldMapHumanTracker> carriedBy = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> carriedByPlayers = Maps.newHashMap();
    private final Map<String, MapIconBanner> bannerMarkers = Maps.newHashMap();
    public final Map<String, MapIcon> decorations = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> frameMarkers = Maps.newHashMap();
    private int trackedDecorationCount;

    private WorldMap(int var0, int var1, byte var2, boolean var3, boolean var4, boolean var5, ResourceKey<World> var6) {
        this.scale = var2;
        this.x = var0;
        this.z = var1;
        this.dimension = var6;
        this.trackingPosition = var3;
        this.unlimitedTracking = var4;
        this.locked = var5;
        this.setDirty();
    }

    public static WorldMap createFresh(double var0, double var2, byte var4, boolean var5, boolean var6, ResourceKey<World> var7) {
        int var8 = 128 * (1 << var4);
        int var9 = MathHelper.floor((var0 + 64.0) / (double)var8);
        int var10 = MathHelper.floor((var2 + 64.0) / (double)var8);
        int var11 = var9 * var8 + var8 / 2 - 64;
        int var12 = var10 * var8 + var8 / 2 - 64;
        return new WorldMap(var11, var12, var4, var5, var6, false, var7);
    }

    public static WorldMap createForClient(byte var0, boolean var1, ResourceKey<World> var2) {
        return new WorldMap(0, 0, var0, false, false, var1, var2);
    }

    public static WorldMap load(NBTTagCompound var0) {
        ResourceKey var1 = (ResourceKey)DimensionManager.parseLegacy(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get("dimension"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid map dimension: " + var0.get("dimension")));
        int var2 = var0.getInt("xCenter");
        int var3 = var0.getInt("zCenter");
        byte var4 = (byte)MathHelper.clamp((int)var0.getByte("scale"), 0, 4);
        boolean var5 = !var0.contains("trackingPosition", 1) || var0.getBoolean("trackingPosition");
        boolean var6 = var0.getBoolean("unlimitedTracking");
        boolean var7 = var0.getBoolean("locked");
        WorldMap var8 = new WorldMap(var2, var3, var4, var5, var6, var7, var1);
        byte[] var9 = var0.getByteArray("colors");
        if (var9.length == 16384) {
            var8.colors = var9;
        }
        NBTTagList var10 = var0.getList("banners", 10);
        for (int var11 = 0; var11 < var10.size(); ++var11) {
            MapIconBanner var12 = MapIconBanner.load(var10.getCompound(var11));
            var8.bannerMarkers.put(var12.getId(), var12);
            var8.addDecoration(var12.getDecoration(), null, var12.getId(), var12.getPos().getX(), var12.getPos().getZ(), 180.0, var12.getName());
        }
        NBTTagList var11 = var0.getList("frames", 10);
        for (int var12 = 0; var12 < var11.size(); ++var12) {
            WorldMapFrame var13 = WorldMapFrame.load(var11.getCompound(var12));
            var8.frameMarkers.put(var13.getId(), var13);
            var8.addDecoration(MapIcon.Type.FRAME, null, "frame-" + var13.getEntityId(), var13.getPos().getX(), var13.getPos().getZ(), var13.getRotation(), null);
        }
        return var8;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0) {
        MinecraftKey.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.dimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("dimension", (NBTBase)var1));
        var0.putInt("xCenter", this.x);
        var0.putInt("zCenter", this.z);
        var0.putByte("scale", this.scale);
        var0.putByteArray("colors", this.colors);
        var0.putBoolean("trackingPosition", this.trackingPosition);
        var0.putBoolean("unlimitedTracking", this.unlimitedTracking);
        var0.putBoolean("locked", this.locked);
        NBTTagList var12 = new NBTTagList();
        for (MapIconBanner var3 : this.bannerMarkers.values()) {
            var12.add(var3.save());
        }
        var0.put("banners", var12);
        NBTTagList var2 = new NBTTagList();
        for (WorldMapFrame var4 : this.frameMarkers.values()) {
            var2.add(var4.save());
        }
        var0.put("frames", var2);
        return var0;
    }

    public WorldMap locked() {
        WorldMap var0 = new WorldMap(this.x, this.z, this.scale, this.trackingPosition, this.unlimitedTracking, true, this.dimension);
        var0.bannerMarkers.putAll(this.bannerMarkers);
        var0.decorations.putAll(this.decorations);
        var0.trackedDecorationCount = this.trackedDecorationCount;
        System.arraycopy(this.colors, 0, var0.colors, 0, this.colors.length);
        var0.setDirty();
        return var0;
    }

    public WorldMap scaled(int var0) {
        return WorldMap.createFresh(this.x, this.z, (byte)MathHelper.clamp(this.scale + var0, 0, 4), this.trackingPosition, this.unlimitedTracking, this.dimension);
    }

    public void tickCarriedBy(EntityHuman var0, ItemStack var1) {
        NBTTagCompound var2;
        Object var5;
        Object var4;
        Object var3;
        if (!this.carriedByPlayers.containsKey(var0)) {
            WorldMapHumanTracker var22 = new WorldMapHumanTracker(var0);
            this.carriedByPlayers.put(var0, var22);
            this.carriedBy.add(var22);
        }
        if (!var0.getInventory().contains(var1)) {
            this.removeDecoration(var0.getName().getString());
        }
        for (int var23 = 0; var23 < this.carriedBy.size(); ++var23) {
            var3 = this.carriedBy.get(var23);
            var4 = ((WorldMapHumanTracker)var3).player.getName().getString();
            if (((WorldMapHumanTracker)var3).player.isRemoved() || !((WorldMapHumanTracker)var3).player.getInventory().contains(var1) && !var1.isFramed()) {
                this.carriedByPlayers.remove(((WorldMapHumanTracker)var3).player);
                this.carriedBy.remove(var3);
                this.removeDecoration((String)var4);
                continue;
            }
            if (var1.isFramed() || ((WorldMapHumanTracker)var3).player.level.dimension() != this.dimension || !this.trackingPosition) continue;
            this.addDecoration(MapIcon.Type.PLAYER, ((WorldMapHumanTracker)var3).player.level, (String)var4, ((WorldMapHumanTracker)var3).player.getX(), ((WorldMapHumanTracker)var3).player.getZ(), ((WorldMapHumanTracker)var3).player.getYRot(), null);
        }
        if (var1.isFramed() && this.trackingPosition) {
            EntityItemFrame var24 = var1.getFrame();
            var3 = var24.getPos();
            var4 = this.frameMarkers.get(WorldMapFrame.frameId((BlockPosition)var3));
            if (var4 != null && var24.getId() != ((WorldMapFrame)var4).getEntityId() && this.frameMarkers.containsKey(((WorldMapFrame)var4).getId())) {
                this.removeDecoration("frame-" + ((WorldMapFrame)var4).getEntityId());
            }
            var5 = new WorldMapFrame((BlockPosition)var3, var24.getDirection().get2DDataValue() * 90, var24.getId());
            this.addDecoration(MapIcon.Type.FRAME, var0.level, "frame-" + var24.getId(), ((BaseBlockPosition)var3).getX(), ((BaseBlockPosition)var3).getZ(), var24.getDirection().get2DDataValue() * 90, null);
            this.frameMarkers.put(((WorldMapFrame)var5).getId(), (WorldMapFrame)var5);
        }
        if ((var2 = var1.getTag()) != null && var2.contains("Decorations", 9)) {
            var3 = var2.getList("Decorations", 10);
            for (int var42 = 0; var42 < ((NBTTagList)var3).size(); ++var42) {
                var5 = ((NBTTagList)var3).getCompound(var42);
                if (this.decorations.containsKey(((NBTTagCompound)var5).getString("id"))) continue;
                this.addDecoration(MapIcon.Type.byIcon(((NBTTagCompound)var5).getByte("type")), var0.level, ((NBTTagCompound)var5).getString("id"), ((NBTTagCompound)var5).getDouble("x"), ((NBTTagCompound)var5).getDouble("z"), ((NBTTagCompound)var5).getDouble("rot"), null);
            }
        }
    }

    private void removeDecoration(String var0) {
        MapIcon var1 = this.decorations.remove(var0);
        if (var1 != null && var1.getType().shouldTrackCount()) {
            --this.trackedDecorationCount;
        }
        this.setDecorationsDirty();
    }

    public static void addTargetDecoration(ItemStack var0, BlockPosition var1, String var2, MapIcon.Type var3) {
        NBTTagList var4;
        if (var0.hasTag() && var0.getTag().contains("Decorations", 9)) {
            var4 = var0.getTag().getList("Decorations", 10);
        } else {
            var4 = new NBTTagList();
            var0.addTagElement("Decorations", var4);
        }
        NBTTagCompound var5 = new NBTTagCompound();
        var5.putByte("type", var3.getIcon());
        var5.putString("id", var2);
        var5.putDouble("x", var1.getX());
        var5.putDouble("z", var1.getZ());
        var5.putDouble("rot", 180.0);
        var4.add(var5);
        if (var3.hasMapColor()) {
            NBTTagCompound var6 = var0.getOrCreateTagElement("display");
            var6.putInt("MapColor", var3.getMapColor());
        }
    }

    private void addDecoration(MapIcon.Type var0, @Nullable GeneratorAccess var1, String var2, double var3, double var5, double var7, @Nullable IChatBaseComponent var9) {
        MapIcon var18;
        MapIcon var17;
        byte var15;
        int var10 = 1 << this.scale;
        float var11 = (float)(var3 - (double)this.x) / (float)var10;
        float var12 = (float)(var5 - (double)this.z) / (float)var10;
        byte var13 = (byte)((double)(var11 * 2.0f) + 0.5);
        byte var14 = (byte)((double)(var12 * 2.0f) + 0.5);
        int var16 = 63;
        if (var11 >= -63.0f && var12 >= -63.0f && var11 <= 63.0f && var12 <= 63.0f) {
            var15 = (byte)((var7 += var7 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.dimension == World.NETHER && var1 != null) {
                var17 = (int)(var1.getLevelData().getDayTime() / 10L);
                var15 = (byte)(var17 * var17 * 34187121 + var17 * 121 >> 15 & 0xF);
            }
        } else if (var0 == MapIcon.Type.PLAYER) {
            var17 = 320;
            if (Math.abs(var11) < 320.0f && Math.abs(var12) < 320.0f) {
                var0 = MapIcon.Type.PLAYER_OFF_MAP;
            } else if (this.unlimitedTracking) {
                var0 = MapIcon.Type.PLAYER_OFF_LIMITS;
            } else {
                this.removeDecoration(var2);
                return;
            }
            var15 = 0;
            if (var11 <= -63.0f) {
                var13 = -128;
            }
            if (var12 <= -63.0f) {
                var14 = -128;
            }
            if (var11 >= 63.0f) {
                var13 = 127;
            }
            if (var12 >= 63.0f) {
                var14 = 127;
            }
        } else {
            this.removeDecoration(var2);
            return;
        }
        if (!(var17 = new MapIcon(var0, var13, var14, var15, var9)).equals(var18 = this.decorations.put(var2, var17))) {
            if (var18 != null && var18.getType().shouldTrackCount()) {
                --this.trackedDecorationCount;
            }
            if (var0.shouldTrackCount()) {
                ++this.trackedDecorationCount;
            }
            this.setDecorationsDirty();
        }
    }

    @Nullable
    public Packet<?> getUpdatePacket(int var0, EntityHuman var1) {
        WorldMapHumanTracker var2 = this.carriedByPlayers.get(var1);
        if (var2 == null) {
            return null;
        }
        return var2.nextUpdatePacket(var0);
    }

    public void setColorsDirty(int var0, int var1) {
        this.setDirty();
        for (WorldMapHumanTracker var3 : this.carriedBy) {
            var3.markColorsDirty(var0, var1);
        }
    }

    public void setDecorationsDirty() {
        this.setDirty();
        this.carriedBy.forEach(WorldMapHumanTracker::markDecorationsDirty);
    }

    public WorldMapHumanTracker getHoldingPlayer(EntityHuman var0) {
        WorldMapHumanTracker var1 = this.carriedByPlayers.get(var0);
        if (var1 == null) {
            var1 = new WorldMapHumanTracker(var0);
            this.carriedByPlayers.put(var0, var1);
            this.carriedBy.add(var1);
        }
        return var1;
    }

    public boolean toggleBanner(GeneratorAccess var0, BlockPosition var1) {
        double var2 = (double)var1.getX() + 0.5;
        double var4 = (double)var1.getZ() + 0.5;
        int var6 = 1 << this.scale;
        double var7 = (var2 - (double)this.x) / (double)var6;
        double var9 = (var4 - (double)this.z) / (double)var6;
        int var11 = 63;
        if (var7 >= -63.0 && var9 >= -63.0 && var7 <= 63.0 && var9 <= 63.0) {
            MapIconBanner var12 = MapIconBanner.fromWorld(var0, var1);
            if (var12 == null) {
                return false;
            }
            if (this.bannerMarkers.remove(var12.getId(), var12)) {
                this.removeDecoration(var12.getId());
                return true;
            }
            if (!this.isTrackedCountOverLimit(256)) {
                this.bannerMarkers.put(var12.getId(), var12);
                this.addDecoration(var12.getDecoration(), var0, var12.getId(), var2, var4, 180.0, var12.getName());
                return true;
            }
        }
        return false;
    }

    public void checkBanners(IBlockAccess var0, int var1, int var2) {
        Iterator<MapIconBanner> var3 = this.bannerMarkers.values().iterator();
        while (var3.hasNext()) {
            MapIconBanner var5;
            MapIconBanner var4 = var3.next();
            if (var4.getPos().getX() != var1 || var4.getPos().getZ() != var2 || var4.equals(var5 = MapIconBanner.fromWorld(var0, var4.getPos()))) continue;
            var3.remove();
            this.removeDecoration(var4.getId());
        }
    }

    public Collection<MapIconBanner> getBanners() {
        return this.bannerMarkers.values();
    }

    public void removedFromFrame(BlockPosition var0, int var1) {
        this.removeDecoration("frame-" + var1);
        this.frameMarkers.remove(WorldMapFrame.frameId(var0));
    }

    public boolean updateColor(int var0, int var1, byte var2) {
        byte var3 = this.colors[var0 + var1 * 128];
        if (var3 != var2) {
            this.setColor(var0, var1, var2);
            return true;
        }
        return false;
    }

    public void setColor(int var0, int var1, byte var2) {
        this.colors[var0 + var1 * 128] = var2;
        this.setColorsDirty(var0, var1);
    }

    public boolean isExplorationMap() {
        for (MapIcon var1 : this.decorations.values()) {
            if (var1.getType() != MapIcon.Type.MANSION && var1.getType() != MapIcon.Type.MONUMENT) continue;
            return true;
        }
        return false;
    }

    public void addClientSideDecorations(List<MapIcon> var0) {
        this.decorations.clear();
        this.trackedDecorationCount = 0;
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            MapIcon var2 = var0.get(var1);
            this.decorations.put("icon-" + var1, var2);
            if (!var2.getType().shouldTrackCount()) continue;
            ++this.trackedDecorationCount;
        }
    }

    public Iterable<MapIcon> getDecorations() {
        return this.decorations.values();
    }

    public boolean isTrackedCountOverLimit(int var0) {
        return this.trackedDecorationCount >= var0;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman player;
        private boolean dirtyData = true;
        private int minDirtyX;
        private int minDirtyY;
        private int maxDirtyX = 127;
        private int maxDirtyY = 127;
        private boolean dirtyDecorations = true;
        private int tick;
        public int step;

        WorldMapHumanTracker(EntityHuman var1) {
            this.player = var1;
        }

        private b createPatch() {
            int var0 = this.minDirtyX;
            int var1 = this.minDirtyY;
            int var2 = this.maxDirtyX + 1 - this.minDirtyX;
            int var3 = this.maxDirtyY + 1 - this.minDirtyY;
            byte[] var4 = new byte[var2 * var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                for (int var6 = 0; var6 < var3; ++var6) {
                    var4[var5 + var6 * var2] = WorldMap.this.colors[var0 + var5 + (var1 + var6) * 128];
                }
            }
            return new b(var0, var1, var2, var3, var4);
        }

        @Nullable
        Packet<?> nextUpdatePacket(int var0) {
            Collection<MapIcon> var2;
            b var1;
            if (this.dirtyData) {
                this.dirtyData = false;
                var1 = this.createPatch();
            } else {
                var1 = null;
            }
            if (this.dirtyDecorations && this.tick++ % 5 == 0) {
                this.dirtyDecorations = false;
                var2 = WorldMap.this.decorations.values();
            } else {
                var2 = null;
            }
            if (var2 != null || var1 != null) {
                return new PacketPlayOutMap(var0, WorldMap.this.scale, WorldMap.this.locked, var2, var1);
            }
            return null;
        }

        void markColorsDirty(int var0, int var1) {
            if (this.dirtyData) {
                this.minDirtyX = Math.min(this.minDirtyX, var0);
                this.minDirtyY = Math.min(this.minDirtyY, var1);
                this.maxDirtyX = Math.max(this.maxDirtyX, var0);
                this.maxDirtyY = Math.max(this.maxDirtyY, var1);
            } else {
                this.dirtyData = true;
                this.minDirtyX = var0;
                this.minDirtyY = var1;
                this.maxDirtyX = var0;
                this.maxDirtyY = var1;
            }
        }

        private void markDecorationsDirty() {
            this.dirtyDecorations = true;
        }
    }

    public static class b {
        public final int startX;
        public final int startY;
        public final int width;
        public final int height;
        public final byte[] mapColors;

        public b(int var0, int var1, int var2, int var3, byte[] var4) {
            this.startX = var0;
            this.startY = var1;
            this.width = var2;
            this.height = var3;
            this.mapColors = var4;
        }

        public void applyToMap(WorldMap var0) {
            for (int var1 = 0; var1 < this.width; ++var1) {
                for (int var2 = 0; var2 < this.height; ++var2) {
                    var0.setColor(this.startX + var1, this.startY + var2, this.mapColors[var1 + var2 * this.width]);
                }
            }
        }
    }
}

