/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.MathHelper;

public abstract class LightEngineGraph {
    private static final int NO_COMPUTED_LEVEL = 255;
    private final int levelCount;
    private final LongLinkedOpenHashSet[] queues;
    private final Long2ByteMap computedLevels;
    private int firstQueuedLevel;
    private volatile boolean hasWork;

    protected LightEngineGraph(int var0, final int var1, final int var2) {
        if (var0 >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.levelCount = var0;
        this.queues = new LongLinkedOpenHashSet[var0];
        for (int var3 = 0; var3 < var0; ++var3) {
            this.queues[var3] = new LongLinkedOpenHashSet(var1, 0.5f){

                protected void rehash(int var0) {
                    if (var0 > var1) {
                        super.rehash(var0);
                    }
                }
            };
        }
        this.computedLevels = new Long2ByteOpenHashMap(var2, 0.5f){

            protected void rehash(int var0) {
                if (var0 > var2) {
                    super.rehash(var0);
                }
            }
        };
        this.computedLevels.defaultReturnValue((byte)-1);
        this.firstQueuedLevel = var0;
    }

    private int getKey(int var0, int var1) {
        int var2 = var0;
        if (var2 > var1) {
            var2 = var1;
        }
        if (var2 > this.levelCount - 1) {
            var2 = this.levelCount - 1;
        }
        return var2;
    }

    private void checkFirstQueuedLevel(int var0) {
        int var1 = this.firstQueuedLevel;
        this.firstQueuedLevel = var0;
        for (int var2 = var1 + 1; var2 < var0; ++var2) {
            if (this.queues[var2].isEmpty()) continue;
            this.firstQueuedLevel = var2;
            break;
        }
    }

    protected void removeFromQueue(long var0) {
        int var2 = this.computedLevels.get(var0) & 0xFF;
        if (var2 == 255) {
            return;
        }
        int var3 = this.getLevel(var0);
        int var4 = this.getKey(var3, var2);
        this.dequeue(var0, var4, this.levelCount, true);
        this.hasWork = this.firstQueuedLevel < this.levelCount;
    }

    public void removeIf(LongPredicate var0) {
        LongArrayList var1 = new LongArrayList();
        this.computedLevels.keySet().forEach(arg_0 -> LightEngineGraph.a(var0, (LongList)var1, arg_0));
        var1.forEach(this::removeFromQueue);
    }

    private void dequeue(long var0, int var2, int var3, boolean var4) {
        if (var4) {
            this.computedLevels.remove(var0);
        }
        this.queues[var2].remove(var0);
        if (this.queues[var2].isEmpty() && this.firstQueuedLevel == var2) {
            this.checkFirstQueuedLevel(var3);
        }
    }

    private void enqueue(long var0, int var2, int var3) {
        this.computedLevels.put(var0, (byte)var2);
        this.queues[var3].add(var0);
        if (this.firstQueuedLevel > var3) {
            this.firstQueuedLevel = var3;
        }
    }

    protected void checkNode(long var0) {
        this.checkEdge(var0, var0, this.levelCount - 1, false);
    }

    protected void checkEdge(long var0, long var2, int var4, boolean var5) {
        this.checkEdge(var0, var2, var4, this.getLevel(var2), this.computedLevels.get(var2) & 0xFF, var5);
        this.hasWork = this.firstQueuedLevel < this.levelCount;
    }

    private void checkEdge(long var0, long var2, int var4, int var5, int var6, boolean var7) {
        boolean var8;
        if (this.isSource(var2)) {
            return;
        }
        var4 = MathHelper.clamp(var4, 0, this.levelCount - 1);
        var5 = MathHelper.clamp(var5, 0, this.levelCount - 1);
        if (var6 == 255) {
            var8 = true;
            var6 = var5;
        } else {
            var8 = false;
        }
        int var9 = var7 ? Math.min(var6, var4) : MathHelper.clamp(this.getComputedLevel(var2, var0, var4), 0, this.levelCount - 1);
        int var10 = this.getKey(var5, var6);
        if (var5 != var9) {
            int var11 = this.getKey(var5, var9);
            if (var10 != var11 && !var8) {
                this.dequeue(var2, var10, var11, false);
            }
            this.enqueue(var2, var9, var11);
        } else if (!var8) {
            this.dequeue(var2, var10, this.levelCount, true);
        }
    }

    protected final void checkNeighbor(long var0, long var2, int var4, boolean var5) {
        int var6 = this.computedLevels.get(var2) & 0xFF;
        int var7 = MathHelper.clamp(this.computeLevelFromNeighbor(var0, var2, var4), 0, this.levelCount - 1);
        if (var5) {
            this.checkEdge(var0, var2, var7, this.getLevel(var2), var6, true);
        } else {
            int var8;
            boolean var9;
            if (var6 == 255) {
                var9 = true;
                var8 = MathHelper.clamp(this.getLevel(var2), 0, this.levelCount - 1);
            } else {
                var8 = var6;
                var9 = false;
            }
            if (var7 == var8) {
                this.checkEdge(var0, var2, this.levelCount - 1, var9 ? var8 : this.getLevel(var2), var6, false);
            }
        }
    }

    protected final boolean hasWork() {
        return this.hasWork;
    }

    protected final int runUpdates(int var0) {
        if (this.firstQueuedLevel >= this.levelCount) {
            return var0;
        }
        while (this.firstQueuedLevel < this.levelCount && var0 > 0) {
            int var5;
            --var0;
            LongLinkedOpenHashSet var1 = this.queues[this.firstQueuedLevel];
            long var2 = var1.removeFirstLong();
            int var4 = MathHelper.clamp(this.getLevel(var2), 0, this.levelCount - 1);
            if (var1.isEmpty()) {
                this.checkFirstQueuedLevel(this.levelCount);
            }
            if ((var5 = this.computedLevels.remove(var2) & 0xFF) < var4) {
                this.setLevel(var2, var5);
                this.checkNeighborsAfterUpdate(var2, var5, true);
                continue;
            }
            if (var5 <= var4) continue;
            this.enqueue(var2, var5, this.getKey(this.levelCount - 1, var5));
            this.setLevel(var2, this.levelCount - 1);
            this.checkNeighborsAfterUpdate(var2, var4, false);
        }
        this.hasWork = this.firstQueuedLevel < this.levelCount;
        return var0;
    }

    public int getQueueSize() {
        return this.computedLevels.size();
    }

    protected abstract boolean isSource(long var1);

    protected abstract int getComputedLevel(long var1, long var3, int var5);

    protected abstract void checkNeighborsAfterUpdate(long var1, int var3, boolean var4);

    protected abstract int getLevel(long var1);

    protected abstract void setLevel(long var1, int var3);

    protected abstract int computeLevelFromNeighbor(long var1, long var3, int var5);

    private static /* synthetic */ void a(LongPredicate var0, LongList var1, long var2) {
        if (var0.test(var2)) {
            var1.add(var2);
        }
    }
}

