/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import java.util.stream.IntStream;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements NoiseChunk.c {
    private final NoiseGeneratorOctaves minLimitNoise;
    private final NoiseGeneratorOctaves maxLimitNoise;
    private final NoiseGeneratorOctaves mainNoise;
    private final double xzScale;
    private final double yScale;
    private final double xzMainScale;
    private final double yMainScale;
    private final int cellWidth;
    private final int cellHeight;

    private BlendedNoise(NoiseGeneratorOctaves var0, NoiseGeneratorOctaves var1, NoiseGeneratorOctaves var2, NoiseSamplingSettings var3, int var4, int var5) {
        this.minLimitNoise = var0;
        this.maxLimitNoise = var1;
        this.mainNoise = var2;
        this.xzScale = 684.412 * var3.xzScale();
        this.yScale = 684.412 * var3.yScale();
        this.xzMainScale = this.xzScale / var3.xzFactor();
        this.yMainScale = this.yScale / var3.yFactor();
        this.cellWidth = var4;
        this.cellHeight = var5;
    }

    public BlendedNoise(RandomSource var0, NoiseSamplingSettings var1, int var2, int var3) {
        this(NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-7, 0)), var1, var2, var3);
    }

    @Override
    public double calculateNoise(int var0, int var1, int var2) {
        int var3 = Math.floorDiv(var0, this.cellWidth);
        int var4 = Math.floorDiv(var1, this.cellHeight);
        int var5 = Math.floorDiv(var2, this.cellWidth);
        double var6 = 0.0;
        double var8 = 0.0;
        double var10 = 0.0;
        boolean var12 = true;
        double var13 = 1.0;
        for (int var15 = 0; var15 < 8; ++var15) {
            NoiseGeneratorPerlin var16 = this.mainNoise.getOctaveNoise(var15);
            if (var16 != null) {
                var10 += var16.noise(NoiseGeneratorOctaves.wrap((double)var3 * this.xzMainScale * var13), NoiseGeneratorOctaves.wrap((double)var4 * this.yMainScale * var13), NoiseGeneratorOctaves.wrap((double)var5 * this.xzMainScale * var13), this.yMainScale * var13, (double)var4 * this.yMainScale * var13) / var13;
            }
            var13 /= 2.0;
        }
        double var15 = (var10 / 10.0 + 1.0) / 2.0;
        boolean var17 = var15 >= 1.0;
        boolean var18 = var15 <= 0.0;
        var13 = 1.0;
        for (int var19 = 0; var19 < 16; ++var19) {
            NoiseGeneratorPerlin var28;
            double var20 = NoiseGeneratorOctaves.wrap((double)var3 * this.xzScale * var13);
            double var22 = NoiseGeneratorOctaves.wrap((double)var4 * this.yScale * var13);
            double var24 = NoiseGeneratorOctaves.wrap((double)var5 * this.xzScale * var13);
            double var26 = this.yScale * var13;
            if (!var17 && (var28 = this.minLimitNoise.getOctaveNoise(var19)) != null) {
                var6 += var28.noise(var20, var22, var24, var26, (double)var4 * var26) / var13;
            }
            if (!var18 && (var28 = this.maxLimitNoise.getOctaveNoise(var19)) != null) {
                var8 += var28.noise(var20, var22, var24, var26, (double)var4 * var26) / var13;
            }
            var13 /= 2.0;
        }
        return MathHelper.clampedLerp(var6 / 512.0, var8 / 512.0, var15) / 128.0;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        var0.append("BlendedNoise{minLimitNoise=");
        this.minLimitNoise.parityConfigString(var0);
        var0.append(", maxLimitNoise=");
        this.maxLimitNoise.parityConfigString(var0);
        var0.append(", mainNoise=");
        this.mainNoise.parityConfigString(var0);
        var0.append(String.format(", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=%d, cellHeight=%d", this.xzScale, this.yScale, this.xzMainScale, this.yMainScale, this.cellWidth, this.cellHeight)).append('}');
    }
}

