/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

@FunctionalInterface
public interface PieceGeneratorSupplier<C extends WorldGenFeatureConfiguration> {
    public Optional<PieceGenerator<C>> createGenerator(a<C> var1);

    public static <C extends WorldGenFeatureConfiguration> PieceGeneratorSupplier<C> simple(Predicate<a<C>> var0, PieceGenerator<C> var1) {
        Optional var22 = Optional.of(var1);
        return var2 -> var0.test(var2) ? var22 : Optional.empty();
    }

    public static <C extends WorldGenFeatureConfiguration> Predicate<a<C>> checkForBiomeOnTop(HeightMap.Type var0) {
        return var1 -> var1.validBiomeOnTop(var0);
    }

    public record a(ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, long seed, ChunkCoordIntPair chunkPos, C config, LevelHeightAccessor heightAccessor, Predicate<BiomeBase> validBiome, DefinedStructureManager structureManager, IRegistryCustom registryAccess) {
        public boolean validBiomeOnTop(HeightMap.Type var0) {
            int var1 = this.chunkPos.getMiddleBlockX();
            int var2 = this.chunkPos.getMiddleBlockZ();
            int var3 = this.chunkGenerator.getFirstOccupiedHeight(var1, var2, var0, this.heightAccessor);
            BiomeBase var4 = this.chunkGenerator.getNoiseBiome(QuartPos.fromBlock(var1), QuartPos.fromBlock(var3), QuartPos.fromBlock(var2));
            return this.validBiome.test(var4);
        }

        public int[] getCornerHeights(int var0, int var1, int var2, int var3) {
            return new int[]{this.chunkGenerator.getFirstOccupiedHeight(var0, var2, HeightMap.Type.WORLD_SURFACE_WG, this.heightAccessor), this.chunkGenerator.getFirstOccupiedHeight(var0, var2 + var3, HeightMap.Type.WORLD_SURFACE_WG, this.heightAccessor), this.chunkGenerator.getFirstOccupiedHeight(var0 + var1, var2, HeightMap.Type.WORLD_SURFACE_WG, this.heightAccessor), this.chunkGenerator.getFirstOccupiedHeight(var0 + var1, var2 + var3, HeightMap.Type.WORLD_SURFACE_WG, this.heightAccessor)};
        }

        public int getLowestY(int var0, int var1) {
            int var2 = this.chunkPos.getMinBlockX();
            int var3 = this.chunkPos.getMinBlockZ();
            int[] var4 = this.getCornerHeights(var2, var0, var3, var1);
            return Math.min(Math.min(var4[0], var4[1]), Math.min(var4[2], var4[3]));
        }
    }
}

