/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuinPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenFeatureOceanRuin
extends StructureGenerator<WorldGenFeatureOceanRuinConfiguration> {
    public WorldGenFeatureOceanRuin(Codec<WorldGenFeatureOceanRuinConfiguration> var0) {
        super(var0, PieceGeneratorSupplier.simple(PieceGeneratorSupplier.checkForBiomeOnTop(HeightMap.Type.OCEAN_FLOOR_WG), WorldGenFeatureOceanRuin::generatePieces));
    }

    private static void generatePieces(StructurePiecesBuilder var0, PieceGenerator.a<WorldGenFeatureOceanRuinConfiguration> var1) {
        BlockPosition var2 = new BlockPosition(var1.chunkPos().getMinBlockX(), 90, var1.chunkPos().getMinBlockZ());
        EnumBlockRotation var3 = EnumBlockRotation.getRandom(var1.random());
        WorldGenFeatureOceanRuinPieces.addPieces(var1.structureManager(), var2, var3, var0, var1.random(), (WorldGenFeatureOceanRuinConfiguration)var1.config());
    }

    public static final class Temperature
    extends Enum<Temperature>
    implements INamable {
        public static final /* enum */ Temperature WARM = new Temperature("warm");
        public static final /* enum */ Temperature COLD = new Temperature("cold");
        public static final Codec<Temperature> CODEC;
        private static final Map<String, Temperature> BY_NAME;
        private final String name;
        private static final /* synthetic */ Temperature[] f;

        public static Temperature[] values() {
            return (Temperature[])f.clone();
        }

        public static Temperature valueOf(String var0) {
            return Enum.valueOf(Temperature.class, var0);
        }

        private Temperature(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static Temperature byName(String var0) {
            return BY_NAME.get(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Temperature[] b() {
            return new Temperature[]{WARM, COLD};
        }

        static {
            f = Temperature.b();
            CODEC = INamable.fromEnum(Temperature::values, Temperature::byName);
            BY_NAME = Arrays.stream(Temperature.values()).collect(Collectors.toMap(Temperature::getName, var0 -> var0));
        }
    }
}

