/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.structure.NoiseAffectingStructureFeature;
import net.minecraft.world.level.levelgen.structure.WorldGenNetherFossil;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenFeatureNetherFossil
extends NoiseAffectingStructureFeature<RangeConfiguration> {
    public WorldGenFeatureNetherFossil(Codec<RangeConfiguration> var0) {
        super(var0, WorldGenFeatureNetherFossil::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<RangeConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.a<RangeConfiguration> var0) {
        Object var9;
        SeededRandom var1 = new SeededRandom(new LegacyRandomSource(0L));
        var1.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        int var2 = var0.chunkPos().getMinBlockX() + var1.nextInt(16);
        int var3 = var0.chunkPos().getMinBlockZ() + var1.nextInt(16);
        int var4 = var0.chunkGenerator().getSeaLevel();
        WorldGenerationContext var5 = new WorldGenerationContext(var0.chunkGenerator(), var0.heightAccessor());
        int var6 = ((RangeConfiguration)var0.config()).height.sample(var1, var5);
        BlockColumn var7 = var0.chunkGenerator().getBaseColumn(var2, var3, var0.heightAccessor());
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition(var2, var6, var3);
        while (var6 > var4) {
            var9 = var7.getBlock(var6);
            IBlockData var10 = var7.getBlock(--var6);
            if (!((BlockBase.BlockData)var9).isAir() || !var10.is(Blocks.SOUL_SAND) && !var10.isFaceSturdy(BlockAccessAir.INSTANCE, var8.setY(var6), EnumDirection.UP)) continue;
            break;
        }
        if (var6 <= var4) {
            return Optional.empty();
        }
        if (!var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var2), QuartPos.fromBlock(var6), QuartPos.fromBlock(var3)))) {
            return Optional.empty();
        }
        var9 = new BlockPosition(var2, var6, var3);
        return Optional.of((arg_0, arg_1) -> WorldGenFeatureNetherFossil.a(var0, var1, (BlockPosition)var9, arg_0, arg_1));
    }

    private static /* synthetic */ void a(PieceGeneratorSupplier.a var0, SeededRandom var1, BlockPosition var2, StructurePiecesBuilder var3, PieceGenerator.a var4) {
        WorldGenNetherFossil.addPieces(var0.structureManager(), var3, var1, var2);
    }
}

