/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenScatteredPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenDesertPyramidPiece
extends WorldGenScatteredPiece {
    public static final int WIDTH = 21;
    public static final int DEPTH = 21;
    private final boolean[] hasPlacedChest = new boolean[4];

    public WorldGenDesertPyramidPiece(Random var0, int var1, int var2) {
        super(WorldGenFeatureStructurePieceType.DESERT_PYRAMID_PIECE, var1, 64, var2, 21, 15, 21, WorldGenDesertPyramidPiece.getRandomHorizontalDirection(var0));
    }

    public WorldGenDesertPyramidPiece(NBTTagCompound var0) {
        super(WorldGenFeatureStructurePieceType.DESERT_PYRAMID_PIECE, var0);
        this.hasPlacedChest[0] = var0.getBoolean("hasPlacedChest0");
        this.hasPlacedChest[1] = var0.getBoolean("hasPlacedChest1");
        this.hasPlacedChest[2] = var0.getBoolean("hasPlacedChest2");
        this.hasPlacedChest[3] = var0.getBoolean("hasPlacedChest3");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        super.addAdditionalSaveData(var0, var1);
        var1.putBoolean("hasPlacedChest0", this.hasPlacedChest[0]);
        var1.putBoolean("hasPlacedChest1", this.hasPlacedChest[1]);
        var1.putBoolean("hasPlacedChest2", this.hasPlacedChest[2]);
        var1.putBoolean("hasPlacedChest3", this.hasPlacedChest[3]);
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        int var11;
        int var7;
        if (!this.updateHeightPositionToLowestGroundHeight(var0, -var3.nextInt(3))) {
            return;
        }
        this.generateBox(var0, var4, 0, -4, 0, this.width - 1, 0, this.depth - 1, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        for (var7 = 1; var7 <= 9; ++var7) {
            this.generateBox(var0, var4, var7, var7, var7, this.width - 1 - var7, var7, this.depth - 1 - var7, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
            this.generateBox(var0, var4, var7 + 1, var7, var7 + 1, this.width - 2 - var7, var7, this.depth - 2 - var7, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        }
        for (var7 = 0; var7 < this.width; ++var7) {
            for (int var8 = 0; var8 < this.depth; ++var8) {
                int var9 = -5;
                this.fillColumnDown(var0, Blocks.SANDSTONE.defaultBlockState(), var7, -5, var8, var4);
            }
        }
        IBlockData var72 = (IBlockData)Blocks.SANDSTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
        IBlockData var8 = (IBlockData)Blocks.SANDSTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
        IBlockData var9 = (IBlockData)Blocks.SANDSTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.EAST);
        IBlockData var10 = (IBlockData)Blocks.SANDSTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.WEST);
        this.generateBox(var0, var4, 0, 0, 0, 4, 9, 4, Blocks.SANDSTONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 10, 1, 3, 10, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.placeBlock(var0, var72, 2, 10, 0, var4);
        this.placeBlock(var0, var8, 2, 10, 4, var4);
        this.placeBlock(var0, var9, 0, 10, 2, var4);
        this.placeBlock(var0, var10, 4, 10, 2, var4);
        this.generateBox(var0, var4, this.width - 5, 0, 0, this.width - 1, 9, 4, Blocks.SANDSTONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 4, 10, 1, this.width - 2, 10, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.placeBlock(var0, var72, this.width - 3, 10, 0, var4);
        this.placeBlock(var0, var8, this.width - 3, 10, 4, var4);
        this.placeBlock(var0, var9, this.width - 5, 10, 2, var4);
        this.placeBlock(var0, var10, this.width - 1, 10, 2, var4);
        this.generateBox(var0, var4, 8, 0, 0, 12, 4, 4, Blocks.SANDSTONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 9, 1, 0, 11, 3, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 9, 1, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 9, 2, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 9, 3, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 10, 3, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 11, 3, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 11, 2, 1, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 11, 1, 1, var4);
        this.generateBox(var0, var4, 4, 1, 1, 8, 3, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 4, 1, 2, 8, 2, 2, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 12, 1, 1, 16, 3, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 12, 1, 2, 16, 2, 2, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 5, 4, 5, this.width - 6, 4, this.depth - 6, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 9, 4, 9, 11, 4, 11, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, 8, 1, 8, 8, 3, 8, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 12, 1, 8, 12, 3, 8, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 8, 1, 12, 8, 3, 12, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 12, 1, 12, 12, 3, 12, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 1, 5, 4, 4, 11, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 5, 1, 5, this.width - 2, 4, 11, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 6, 7, 9, 6, 7, 11, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 7, 7, 9, this.width - 7, 7, 11, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 5, 5, 9, 5, 7, 11, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 6, 5, 9, this.width - 6, 7, 11, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 5, 5, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 5, 6, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 6, 6, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), this.width - 6, 5, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), this.width - 6, 6, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), this.width - 7, 6, 10, var4);
        this.generateBox(var0, var4, 2, 4, 4, 2, 6, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 3, 4, 4, this.width - 3, 6, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.placeBlock(var0, var72, 2, 4, 5, var4);
        this.placeBlock(var0, var72, 2, 3, 4, var4);
        this.placeBlock(var0, var72, this.width - 3, 4, 5, var4);
        this.placeBlock(var0, var72, this.width - 3, 3, 4, var4);
        this.generateBox(var0, var4, 1, 1, 3, 2, 2, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 3, 1, 3, this.width - 2, 2, 3, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.SANDSTONE.defaultBlockState(), 1, 1, 2, var4);
        this.placeBlock(var0, Blocks.SANDSTONE.defaultBlockState(), this.width - 2, 1, 2, var4);
        this.placeBlock(var0, Blocks.SANDSTONE_SLAB.defaultBlockState(), 1, 2, 2, var4);
        this.placeBlock(var0, Blocks.SANDSTONE_SLAB.defaultBlockState(), this.width - 2, 2, 2, var4);
        this.placeBlock(var0, var10, 2, 1, 2, var4);
        this.placeBlock(var0, var9, this.width - 3, 1, 2, var4);
        this.generateBox(var0, var4, 4, 3, 5, 4, 3, 17, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 5, 3, 5, this.width - 5, 3, 17, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 3, 1, 5, 4, 2, 16, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.generateBox(var0, var4, this.width - 6, 1, 5, this.width - 5, 2, 16, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        for (var11 = 5; var11 <= 17; var11 += 2) {
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 4, 1, var11, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 4, 2, var11, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), this.width - 5, 1, var11, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), this.width - 5, 2, var11, var4);
        }
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 10, 0, 7, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 10, 0, 8, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 9, 0, 9, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 11, 0, 9, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 8, 0, 10, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 12, 0, 10, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 7, 0, 10, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 13, 0, 10, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 9, 0, 11, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 11, 0, 11, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 10, 0, 12, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 10, 0, 13, var4);
        this.placeBlock(var0, Blocks.BLUE_TERRACOTTA.defaultBlockState(), 10, 0, 10, var4);
        for (var11 = 0; var11 <= this.width - 1; var11 += this.width - 1) {
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 2, 1, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 2, 2, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 2, 3, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 3, 1, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 3, 2, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 3, 3, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 4, 1, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), var11, 4, 2, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 4, 3, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 5, 1, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 5, 2, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 5, 3, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 6, 1, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), var11, 6, 2, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 6, 3, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 7, 1, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 7, 2, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 7, 3, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 8, 1, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 8, 2, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 8, 3, var4);
        }
        for (var11 = 2; var11 <= this.width - 3; var11 += this.width - 3 - 2) {
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 - 1, 2, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 2, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 + 1, 2, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 - 1, 3, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 3, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 + 1, 3, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 - 1, 4, 0, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), var11, 4, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 + 1, 4, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 - 1, 5, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 5, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 + 1, 5, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 - 1, 6, 0, var4);
            this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), var11, 6, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 + 1, 6, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 - 1, 7, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11, 7, 0, var4);
            this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), var11 + 1, 7, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 - 1, 8, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11, 8, 0, var4);
            this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), var11 + 1, 8, 0, var4);
        }
        this.generateBox(var0, var4, 8, 4, 0, 12, 6, 0, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 8, 6, 0, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 12, 6, 0, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 9, 5, 0, var4);
        this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 10, 5, 0, var4);
        this.placeBlock(var0, Blocks.ORANGE_TERRACOTTA.defaultBlockState(), 11, 5, 0, var4);
        this.generateBox(var0, var4, 8, -14, 8, 12, -11, 12, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 8, -10, 8, 12, -10, 12, Blocks.CHISELED_SANDSTONE.defaultBlockState(), Blocks.CHISELED_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 8, -9, 8, 12, -9, 12, Blocks.CUT_SANDSTONE.defaultBlockState(), Blocks.CUT_SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 8, -8, 8, 12, -1, 12, Blocks.SANDSTONE.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState(), false);
        this.generateBox(var0, var4, 9, -11, 9, 11, -1, 11, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.STONE_PRESSURE_PLATE.defaultBlockState(), 10, -11, 10, var4);
        this.generateBox(var0, var4, 9, -13, 9, 11, -13, 11, Blocks.TNT.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 8, -11, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 8, -10, 10, var4);
        this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 7, -10, 10, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 7, -11, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 12, -11, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 12, -10, 10, var4);
        this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 13, -10, 10, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 13, -11, 10, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, -11, 8, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, -10, 8, var4);
        this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 10, -10, 7, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 10, -11, 7, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, -11, 12, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, -10, 12, var4);
        this.placeBlock(var0, Blocks.CHISELED_SANDSTONE.defaultBlockState(), 10, -10, 13, var4);
        this.placeBlock(var0, Blocks.CUT_SANDSTONE.defaultBlockState(), 10, -11, 13, var4);
        for (EnumDirection var12 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (this.hasPlacedChest[var12.get2DDataValue()]) continue;
            int var13 = var12.getStepX() * 2;
            int var14 = var12.getStepZ() * 2;
            this.hasPlacedChest[var12.get2DDataValue()] = this.createChest(var0, var4, var3, 10 + var13, -11, 10 + var14, LootTables.DESERT_PYRAMID);
        }
    }
}

