/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructurePiece {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final IBlockData CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected StructureBoundingBox boundingBox;
    @Nullable
    private EnumDirection orientation;
    private EnumBlockMirror mirror;
    private EnumBlockRotation rotation;
    protected int genDepth;
    private final WorldGenFeatureStructurePieceType type;
    private static final Set<Block> SHAPE_CHECK_BLOCKS = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType var0, int var1, StructureBoundingBox var2) {
        this.type = var0;
        this.genDepth = var1;
        this.boundingBox = var2;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
        this(var0, var1.getInt("GD"), (StructureBoundingBox)StructureBoundingBox.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var1.get("BB")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int var2 = var1.getInt("O");
        this.setOrientation(var2 == -1 ? null : EnumDirection.from2DDataValue(var2));
    }

    protected static StructureBoundingBox makeBoundingBox(int var0, int var1, int var2, EnumDirection var3, int var4, int var5, int var6) {
        if (var3.getAxis() == EnumDirection.EnumAxis.Z) {
            return new StructureBoundingBox(var0, var1, var2, var0 + var4 - 1, var1 + var5 - 1, var2 + var6 - 1);
        }
        return new StructureBoundingBox(var0, var1, var2, var0 + var6 - 1, var1 + var5 - 1, var2 + var4 - 1);
    }

    protected static EnumDirection getRandomHorizontalDirection(Random var0) {
        return EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var0);
    }

    public final NBTTagCompound createTag(StructurePieceSerializationContext var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        var12.putString("id", IRegistry.STRUCTURE_PIECE.getKey(this.getType()).toString());
        StructureBoundingBox.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.boundingBox).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var12.put("BB", (NBTBase)var1));
        EnumDirection var2 = this.getOrientation();
        var12.putInt("O", var2 == null ? -1 : var2.get2DDataValue());
        var12.putInt("GD", this.genDepth);
        this.addAdditionalSaveData(var0, var12);
        return var12;
    }

    protected abstract void addAdditionalSaveData(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public NoiseEffect getNoiseEffect() {
        return NoiseEffect.BEARD;
    }

    public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
    }

    public abstract void postProcess(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, Random var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getGenDepth() {
        return this.genDepth;
    }

    public boolean isCloseToChunk(ChunkCoordIntPair var0, int var1) {
        int var2 = var0.getMinBlockX();
        int var3 = var0.getMinBlockZ();
        return this.boundingBox.intersects(var2 - var1, var3 - var1, var2 + 15 + var1, var3 + 15 + var1);
    }

    public BlockPosition getLocatorPosition() {
        return new BlockPosition(this.boundingBox.getCenter());
    }

    protected BlockPosition.MutableBlockPosition getWorldPos(int var0, int var1, int var2) {
        return new BlockPosition.MutableBlockPosition(this.getWorldX(var0, var2), this.getWorldY(var1), this.getWorldZ(var0, var2));
    }

    protected int getWorldX(int var0, int var1) {
        EnumDirection var2 = this.getOrientation();
        if (var2 == null) {
            return var0;
        }
        switch (var2) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX() + var0;
            }
            case WEST: {
                return this.boundingBox.maxX() - var1;
            }
            case EAST: {
                return this.boundingBox.minX() + var1;
            }
        }
        return var0;
    }

    protected int getWorldY(int var0) {
        if (this.getOrientation() == null) {
            return var0;
        }
        return var0 + this.boundingBox.minY();
    }

    protected int getWorldZ(int var0, int var1) {
        EnumDirection var2 = this.getOrientation();
        if (var2 == null) {
            return var1;
        }
        switch (var2) {
            case NORTH: {
                return this.boundingBox.maxZ() - var1;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + var1;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ() + var0;
            }
        }
        return var1;
    }

    protected void placeBlock(GeneratorAccessSeed var0, IBlockData var1, int var2, int var3, int var4, StructureBoundingBox var5) {
        BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var2, var3, var4);
        if (!var5.isInside(var6)) {
            return;
        }
        if (!this.canBeReplaced(var0, var2, var3, var4, var5)) {
            return;
        }
        if (this.mirror != EnumBlockMirror.NONE) {
            var1 = var1.mirror(this.mirror);
        }
        if (this.rotation != EnumBlockRotation.NONE) {
            var1 = var1.rotate(this.rotation);
        }
        var0.setBlock(var6, var1, 2);
        Fluid var7 = var0.getFluidState(var6);
        if (!var7.isEmpty()) {
            var0.scheduleTick((BlockPosition)var6, var7.getType(), 0);
        }
        if (SHAPE_CHECK_BLOCKS.contains(var1.getBlock())) {
            var0.getChunk(var6).markPosForPostprocessing(var6);
        }
    }

    protected boolean canBeReplaced(IWorldReader var0, int var1, int var2, int var3, StructureBoundingBox var4) {
        return true;
    }

    protected IBlockData getBlock(IBlockAccess var0, int var1, int var2, int var3, StructureBoundingBox var4) {
        BlockPosition.MutableBlockPosition var5 = this.getWorldPos(var1, var2, var3);
        if (!var4.isInside(var5)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var0.getBlockState(var5);
    }

    protected boolean isInterior(IWorldReader var0, int var1, int var2, int var3, StructureBoundingBox var4) {
        BlockPosition.MutableBlockPosition var5 = this.getWorldPos(var1, var2 + 1, var3);
        if (!var4.isInside(var5)) {
            return false;
        }
        return var5.getY() < var0.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, var5.getX(), var5.getZ());
    }

    protected void generateAirBox(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        for (int var8 = var3; var8 <= var6; ++var8) {
            for (int var9 = var2; var9 <= var5; ++var9) {
                for (int var10 = var4; var10 <= var7; ++var10) {
                    this.placeBlock(var0, Blocks.AIR.defaultBlockState(), var9, var8, var10, var1);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7, IBlockData var8, IBlockData var9, boolean var10) {
        for (int var11 = var3; var11 <= var6; ++var11) {
            for (int var12 = var2; var12 <= var5; ++var12) {
                for (int var13 = var4; var13 <= var7; ++var13) {
                    if (var10 && this.getBlock(var0, var12, var11, var13, var1).isAir()) continue;
                    if (var11 == var3 || var11 == var6 || var12 == var2 || var12 == var5 || var13 == var4 || var13 == var7) {
                        this.placeBlock(var0, var8, var12, var11, var13, var1);
                        continue;
                    }
                    this.placeBlock(var0, var9, var12, var11, var13, var1);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed var0, StructureBoundingBox var1, StructureBoundingBox var2, IBlockData var3, IBlockData var4, boolean var5) {
        this.generateBox(var0, var1, var2.minX(), var2.minY(), var2.minZ(), var2.maxX(), var2.maxY(), var2.maxZ(), var3, var4, var5);
    }

    protected void generateBox(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, Random var9, StructurePieceBlockSelector var10) {
        for (int var11 = var3; var11 <= var6; ++var11) {
            for (int var12 = var2; var12 <= var5; ++var12) {
                for (int var13 = var4; var13 <= var7; ++var13) {
                    if (var8 && this.getBlock(var0, var12, var11, var13, var1).isAir()) continue;
                    var10.next(var9, var12, var11, var13, var11 == var3 || var11 == var6 || var12 == var2 || var12 == var5 || var13 == var4 || var13 == var7);
                    this.placeBlock(var0, var10.getNext(), var12, var11, var13, var1);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed var0, StructureBoundingBox var1, StructureBoundingBox var2, boolean var3, Random var4, StructurePieceBlockSelector var5) {
        this.generateBox(var0, var1, var2.minX(), var2.minY(), var2.minZ(), var2.maxX(), var2.maxY(), var2.maxZ(), var3, var4, var5);
    }

    protected void generateMaybeBox(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, float var3, int var4, int var5, int var6, int var7, int var8, int var9, IBlockData var10, IBlockData var11, boolean var12, boolean var13) {
        for (int var14 = var5; var14 <= var8; ++var14) {
            for (int var15 = var4; var15 <= var7; ++var15) {
                for (int var16 = var6; var16 <= var9; ++var16) {
                    if (var2.nextFloat() > var3 || var12 && this.getBlock(var0, var15, var14, var16, var1).isAir() || var13 && !this.isInterior(var0, var15, var14, var16, var1)) continue;
                    if (var14 == var5 || var14 == var8 || var15 == var4 || var15 == var7 || var16 == var6 || var16 == var9) {
                        this.placeBlock(var0, var10, var15, var14, var16, var1);
                        continue;
                    }
                    this.placeBlock(var0, var11, var15, var14, var16, var1);
                }
            }
        }
    }

    protected void maybeGenerateBlock(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, float var3, int var4, int var5, int var6, IBlockData var7) {
        if (var2.nextFloat() < var3) {
            this.placeBlock(var0, var7, var4, var5, var6, var1);
        }
    }

    protected void generateUpperHalfSphere(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7, IBlockData var8, boolean var9) {
        float var10 = var5 - var2 + 1;
        float var11 = var6 - var3 + 1;
        float var12 = var7 - var4 + 1;
        float var13 = (float)var2 + var10 / 2.0f;
        float var14 = (float)var4 + var12 / 2.0f;
        for (int var15 = var3; var15 <= var6; ++var15) {
            float var16 = (float)(var15 - var3) / var11;
            for (int var17 = var2; var17 <= var5; ++var17) {
                float var18 = ((float)var17 - var13) / (var10 * 0.5f);
                for (int var19 = var4; var19 <= var7; ++var19) {
                    float var21;
                    float var20 = ((float)var19 - var14) / (var12 * 0.5f);
                    if (var9 && this.getBlock(var0, var17, var15, var19, var1).isAir() || !((var21 = var18 * var18 + var16 * var16 + var20 * var20) <= 1.05f)) continue;
                    this.placeBlock(var0, var8, var17, var15, var19, var1);
                }
            }
        }
    }

    protected void fillColumnDown(GeneratorAccessSeed var0, IBlockData var1, int var2, int var3, int var4, StructureBoundingBox var5) {
        BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var2, var3, var4);
        if (!var5.isInside(var6)) {
            return;
        }
        while (this.isReplaceableByStructures(var0.getBlockState(var6)) && var6.getY() > var0.getMinBuildHeight() + 1) {
            var0.setBlock(var6, var1, 2);
            var6.move(EnumDirection.DOWN);
        }
    }

    protected boolean isReplaceableByStructures(IBlockData var0) {
        return var0.isAir() || var0.getMaterial().isLiquid() || var0.is(Blocks.GLOW_LICHEN) || var0.is(Blocks.SEAGRASS) || var0.is(Blocks.TALL_SEAGRASS);
    }

    protected boolean createChest(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, int var3, int var4, int var5, MinecraftKey var6) {
        return this.createChest(var0, var1, var2, this.getWorldPos(var3, var4, var5), var6, null);
    }

    public static IBlockData reorient(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        Object var52;
        Object var3 = null;
        for (Object var52 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var6 = var1.relative((EnumDirection)var52);
            IBlockData var7 = var0.getBlockState(var6);
            if (var7.is(Blocks.CHEST)) {
                return var2;
            }
            if (!var7.isSolidRender(var0, var6)) continue;
            if (var3 == null) {
                var3 = var52;
                continue;
            }
            var3 = null;
            break;
        }
        if (var3 != null) {
            return (IBlockData)var2.setValue(BlockFacingHorizontal.FACING, ((EnumDirection)var3).getOpposite());
        }
        EnumDirection var4 = var2.getValue(BlockFacingHorizontal.FACING);
        var52 = var1.relative(var4);
        if (var0.getBlockState((BlockPosition)var52).isSolidRender(var0, (BlockPosition)var52)) {
            var4 = var4.getOpposite();
            var52 = var1.relative(var4);
        }
        if (var0.getBlockState((BlockPosition)var52).isSolidRender(var0, (BlockPosition)var52)) {
            var4 = var4.getClockWise();
            var52 = var1.relative(var4);
        }
        if (var0.getBlockState((BlockPosition)var52).isSolidRender(var0, (BlockPosition)var52)) {
            var4 = var4.getOpposite();
            var52 = var1.relative(var4);
        }
        return (IBlockData)var2.setValue(BlockFacingHorizontal.FACING, var4);
    }

    protected boolean createChest(WorldAccess var0, StructureBoundingBox var1, Random var2, BlockPosition var3, MinecraftKey var4, @Nullable IBlockData var5) {
        if (!var1.isInside(var3) || var0.getBlockState(var3).is(Blocks.CHEST)) {
            return false;
        }
        if (var5 == null) {
            var5 = StructurePiece.reorient(var0, var3, Blocks.CHEST.defaultBlockState());
        }
        var0.setBlock(var3, var5, 2);
        TileEntity var6 = var0.getBlockEntity(var3);
        if (var6 instanceof TileEntityChest) {
            ((TileEntityChest)var6).setLootTable(var4, var2.nextLong());
        }
        return true;
    }

    protected boolean createDispenser(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, int var3, int var4, int var5, EnumDirection var6, MinecraftKey var7) {
        BlockPosition.MutableBlockPosition var8 = this.getWorldPos(var3, var4, var5);
        if (var1.isInside(var8) && !var0.getBlockState(var8).is(Blocks.DISPENSER)) {
            this.placeBlock(var0, (IBlockData)Blocks.DISPENSER.defaultBlockState().setValue(BlockDispenser.FACING, var6), var3, var4, var5, var1);
            TileEntity var9 = var0.getBlockEntity(var8);
            if (var9 instanceof TileEntityDispenser) {
                ((TileEntityDispenser)var9).setLootTable(var7, var2.nextLong());
            }
            return true;
        }
        return false;
    }

    public void move(int var0, int var1, int var2) {
        this.boundingBox.move(var0, var1, var2);
    }

    public static StructureBoundingBox createBoundingBox(Stream<StructurePiece> var0) {
        return StructureBoundingBox.encapsulatingBoxes(var0.map(StructurePiece::getBoundingBox)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> var0, StructureBoundingBox var1) {
        for (StructurePiece var3 : var0) {
            if (!var3.getBoundingBox().intersects(var1)) continue;
            return var3;
        }
        return null;
    }

    @Nullable
    public EnumDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@Nullable EnumDirection var0) {
        this.orientation = var0;
        if (var0 == null) {
            this.rotation = EnumBlockRotation.NONE;
            this.mirror = EnumBlockMirror.NONE;
        } else {
            switch (var0) {
                case SOUTH: {
                    this.mirror = EnumBlockMirror.LEFT_RIGHT;
                    this.rotation = EnumBlockRotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = EnumBlockMirror.LEFT_RIGHT;
                    this.rotation = EnumBlockRotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = EnumBlockMirror.NONE;
                    this.rotation = EnumBlockRotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = EnumBlockMirror.NONE;
                    this.rotation = EnumBlockRotation.NONE;
                }
            }
        }
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public WorldGenFeatureStructurePieceType getType() {
        return this.type;
    }

    protected static abstract class StructurePieceBlockSelector {
        protected IBlockData next = Blocks.AIR.defaultBlockState();

        protected StructurePieceBlockSelector() {
        }

        public abstract void next(Random var1, int var2, int var3, int var4, boolean var5);

        public IBlockData getNext() {
            return this.next;
        }
    }
}

