/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PlacedFeature {
    public static final Codec<PlacedFeature> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)WorldGenFeatureConfigured.CODEC.fieldOf("feature").forGetter(var0 -> var0.feature), (App)PlacementModifier.CODEC.listOf().fieldOf("placement").forGetter(var0 -> var0.placement)).apply((Applicative)var02, PlacedFeature::new));
    public static final Codec<Supplier<PlacedFeature>> CODEC = RegistryFileCodec.create(IRegistry.PLACED_FEATURE_REGISTRY, DIRECT_CODEC);
    public static final Codec<List<Supplier<PlacedFeature>>> LIST_CODEC = RegistryFileCodec.homogeneousList(IRegistry.PLACED_FEATURE_REGISTRY, DIRECT_CODEC);
    private final Supplier<WorldGenFeatureConfigured<?, ?>> feature;
    private final List<PlacementModifier> placement;

    public PlacedFeature(Supplier<WorldGenFeatureConfigured<?, ?>> var0, List<PlacementModifier> var1) {
        this.feature = var0;
        this.placement = var1;
    }

    public boolean place(GeneratorAccessSeed var0, ChunkGenerator var1, Random var2, BlockPosition var3) {
        return this.placeWithContext(new PlacementContext(var0, var1, Optional.empty()), var2, var3);
    }

    public boolean placeWithBiomeCheck(GeneratorAccessSeed var0, ChunkGenerator var1, Random var2, BlockPosition var3) {
        return this.placeWithContext(new PlacementContext(var0, var1, Optional.of(this)), var2, var3);
    }

    private boolean placeWithContext(PlacementContext var0, Random var1, BlockPosition var2) {
        PlacementModifier var52;
        Stream<BlockPosition> var32 = Stream.of(var2);
        for (PlacementModifier var52 : this.placement) {
            var32 = var32.flatMap(var3 -> var52.getPositions(var0, var1, (BlockPosition)var3));
        }
        WorldGenFeatureConfigured<?, ?> var4 = this.feature.get();
        var52 = new MutableBoolean();
        var32.forEach(arg_0 -> PlacedFeature.a(var4, var0, var1, (MutableBoolean)var52, arg_0));
        return var52.isTrue();
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> getFeatures() {
        return this.feature.get().getFeatures();
    }

    @VisibleForDebug
    public List<PlacementModifier> getPlacement() {
        return this.placement;
    }

    public String toString() {
        return "Placed " + IRegistry.FEATURE.getKey((WorldGenerator<?>)this.feature.get().feature());
    }

    private static /* synthetic */ void a(WorldGenFeatureConfigured var0, PlacementContext var1, Random var2, MutableBoolean var3, BlockPosition var4) {
        if (var0.place(var1.getLevel(), var1.generator(), var2, var4)) {
            var3.setTrue();
        }
    }
}

