/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class NoiseBasedCountPlacement
extends RepeatingPlacement {
    public static final Codec<NoiseBasedCountPlacement> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("noise_to_count_ratio").forGetter(var0 -> var0.noiseToCountRatio), (App)Codec.DOUBLE.fieldOf("noise_factor").forGetter(var0 -> var0.noiseFactor), (App)Codec.DOUBLE.fieldOf("noise_offset").orElse((Object)0.0).forGetter(var0 -> var0.noiseOffset)).apply((Applicative)var02, NoiseBasedCountPlacement::new));
    private final int noiseToCountRatio;
    private final double noiseFactor;
    private final double noiseOffset;

    private NoiseBasedCountPlacement(int var0, double var1, double var3) {
        this.noiseToCountRatio = var0;
        this.noiseFactor = var1;
        this.noiseOffset = var3;
    }

    public static NoiseBasedCountPlacement of(int var0, double var1, double var3) {
        return new NoiseBasedCountPlacement(var0, var1, var3);
    }

    @Override
    protected int count(Random var0, BlockPosition var1) {
        double var2 = BiomeBase.BIOME_INFO_NOISE.getValue((double)var1.getX() / this.noiseFactor, (double)var1.getZ() / this.noiseFactor, false);
        return (int)Math.ceil((var2 + this.noiseOffset) * (double)this.noiseToCountRatio);
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.NOISE_BASED_COUNT;
    }
}

