/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger LOGGER = LogManager.getLogger();

    public static Optional<PieceGenerator<WorldGenFeatureVillageConfiguration>> addPieces(PieceGeneratorSupplier.a<WorldGenFeatureVillageConfiguration> var0, a var1, BlockPosition var2, boolean var3, boolean var4) {
        SeededRandom var5 = new SeededRandom(new LegacyRandomSource(0L));
        var5.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        IRegistryCustom var6 = var0.registryAccess();
        WorldGenFeatureVillageConfiguration var7 = (WorldGenFeatureVillageConfiguration)var0.config();
        ChunkGenerator var8 = var0.chunkGenerator();
        DefinedStructureManager var9 = var0.structureManager();
        LevelHeightAccessor var10 = var0.heightAccessor();
        Predicate<BiomeBase> var11 = var0.validBiome();
        StructureGenerator.bootstrap();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var12 = var6.registryOrThrow(IRegistry.TEMPLATE_POOL_REGISTRY);
        EnumBlockRotation var132 = EnumBlockRotation.getRandom(var5);
        WorldGenFeatureDefinedStructurePoolTemplate var142 = var7.startPool().get();
        WorldGenFeatureDefinedStructurePoolStructure var15 = var142.getRandomTemplate(var5);
        if (var15 == WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
            return Optional.empty();
        }
        WorldGenFeaturePillagerOutpostPoolPiece var16 = var1.create(var9, var15, var2, var15.getGroundLevelDelta(), var132, var15.getBoundingBox(var9, var2, var132));
        StructureBoundingBox var17 = var16.getBoundingBox();
        int var18 = (var17.maxX() + var17.minX()) / 2;
        int var19 = (var17.maxZ() + var17.minZ()) / 2;
        int var20 = var4 ? var2.getY() + var8.getFirstFreeHeight(var18, var19, HeightMap.Type.WORLD_SURFACE_WG, var10) : var2.getY();
        if (!var11.test(var8.getNoiseBiome(QuartPos.fromBlock(var18), QuartPos.fromBlock(var20), QuartPos.fromBlock(var19)))) {
            return Optional.empty();
        }
        int var21 = var17.minY() + var16.getGroundLevelDelta();
        var16.move(0, var20 - var21, 0);
        return Optional.of((var13, var14) -> {
            ArrayList var15 = Lists.newArrayList();
            var15.add(var16);
            if (var7.maxDepth() <= 0) {
                return;
            }
            int var16 = 80;
            AxisAlignedBB var17 = new AxisAlignedBB(var18 - 80, var20 - 80, var19 - 80, var18 + 80 + 1, var20 + 80 + 1, var19 + 80 + 1);
            c var18 = new c(var12, var7.maxDepth(), var1, var8, var9, var15, var5);
            var18.placing.addLast(new b(var16, (MutableObject<VoxelShape>)new MutableObject((Object)VoxelShapes.join(VoxelShapes.create(var17), VoxelShapes.create(AxisAlignedBB.of(var17)), OperatorBoolean.ONLY_FIRST)), 0));
            while (!var18.placing.isEmpty()) {
                b var19 = var18.placing.removeFirst();
                var18.tryPlacingChildren(var19.piece, var19.free, var19.depth, var3, var10);
            }
            var15.forEach(var13::addPiece);
        });
    }

    public static void addPieces(IRegistryCustom var0, WorldGenFeaturePillagerOutpostPoolPiece var1, int var2, a var3, ChunkGenerator var4, DefinedStructureManager var5, List<? super WorldGenFeaturePillagerOutpostPoolPiece> var6, Random var7, LevelHeightAccessor var8) {
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var9 = var0.registryOrThrow(IRegistry.TEMPLATE_POOL_REGISTRY);
        c var10 = new c(var9, var2, var3, var4, var5, var6, var7);
        var10.placing.addLast(new b(var1, (MutableObject<VoxelShape>)new MutableObject((Object)VoxelShapes.INFINITY), 0));
        while (!var10.placing.isEmpty()) {
            b var11 = var10.placing.removeFirst();
            var10.tryPlacingChildren(var11.piece, var11.free, var11.depth, false, var8);
        }
    }

    public static interface a {
        public WorldGenFeaturePillagerOutpostPoolPiece create(DefinedStructureManager var1, WorldGenFeatureDefinedStructurePoolStructure var2, BlockPosition var3, int var4, EnumBlockRotation var5, StructureBoundingBox var6);
    }

    static final class c {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools;
        private final int maxDepth;
        private final a factory;
        private final ChunkGenerator chunkGenerator;
        private final DefinedStructureManager structureManager;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> pieces;
        private final Random random;
        final Deque<b> placing = Queues.newArrayDeque();

        c(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var0, int var1, a var2, ChunkGenerator var3, DefinedStructureManager var4, List<? super WorldGenFeaturePillagerOutpostPoolPiece> var5, Random var6) {
            this.pools = var0;
            this.maxDepth = var1;
            this.factory = var2;
            this.chunkGenerator = var3;
            this.structureManager = var4;
            this.pieces = var5;
            this.random = var6;
        }

        void tryPlacingChildren(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var12, int var2, boolean var3, LevelHeightAccessor var4) {
            WorldGenFeatureDefinedStructurePoolStructure var5 = var0.getElement();
            BlockPosition var6 = var0.getPosition();
            EnumBlockRotation var7 = var0.getRotation();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching var8 = var5.getProjection();
            boolean var9 = var8 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
            MutableObject<VoxelShape> var10 = new MutableObject<VoxelShape>();
            StructureBoundingBox var11 = var0.getBoundingBox();
            int var122 = var11.minY();
            block0: for (DefinedStructure.BlockInfo var14 : var5.getShuffledJigsawBlocks(this.structureManager, var6, var7, this.random)) {
                WorldGenFeatureDefinedStructurePoolStructure var28;
                MutableObject<VoxelShape> var24;
                EnumDirection var15 = BlockJigsaw.getFrontFacing(var14.state);
                BlockPosition var16 = var14.pos;
                BlockPosition var17 = var16.relative(var15);
                int var18 = var16.getY() - var122;
                int var19 = -1;
                MinecraftKey var20 = new MinecraftKey(var14.nbt.getString("pool"));
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> var21 = this.pools.getOptional(var20);
                if (!var21.isPresent() || var21.get().size() == 0 && !Objects.equals(var20, WorldGenFeaturePieces.EMPTY.location())) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var20);
                    continue;
                }
                MinecraftKey var22 = var21.get().getFallback();
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> var23 = this.pools.getOptional(var22);
                if (!var23.isPresent() || var23.get().size() == 0 && !Objects.equals(var22, WorldGenFeaturePieces.EMPTY.location())) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)var22);
                    continue;
                }
                boolean var25 = var11.isInside(var17);
                if (var25) {
                    var24 = var10;
                    if (var10.getValue() == null) {
                        var10.setValue((Object)VoxelShapes.create(AxisAlignedBB.of(var11)));
                    }
                } else {
                    var24 = var12;
                }
                ArrayList var26 = Lists.newArrayList();
                if (var2 != this.maxDepth) {
                    var26.addAll(var21.get().getShuffledTemplates(this.random));
                }
                var26.addAll(var23.get().getShuffledTemplates(this.random));
                Iterator iterator = var26.iterator();
                while (iterator.hasNext() && (var28 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
                    for (EnumBlockRotation var30 : EnumBlockRotation.getShuffled(this.random)) {
                        List<DefinedStructure.BlockInfo> var31 = var28.getShuffledJigsawBlocks(this.structureManager, BlockPosition.ZERO, var30, this.random);
                        StructureBoundingBox var32 = var28.getBoundingBox(this.structureManager, BlockPosition.ZERO, var30);
                        int var33 = !var3 || var32.getYSpan() > 16 ? 0 : var31.stream().mapToInt(var1 -> {
                            if (!var32.isInside(var1.pos.relative(BlockJigsaw.getFrontFacing(var1.state)))) {
                                return 0;
                            }
                            MinecraftKey var2 = new MinecraftKey(var1.nbt.getString("pool"));
                            Optional<WorldGenFeatureDefinedStructurePoolTemplate> var3 = this.pools.getOptional(var2);
                            Optional<Integer> var4 = var3.flatMap(var0 -> this.pools.getOptional(var0.getFallback()));
                            int var5 = var3.map(var0 -> var0.getMaxSize(this.structureManager)).orElse(0);
                            int var6 = var4.map(var0 -> var0.getMaxSize(this.structureManager)).orElse(0);
                            return Math.max(var5, var6);
                        }).max().orElse(0);
                        for (DefinedStructure.BlockInfo var35 : var31) {
                            int var51;
                            int var48;
                            int var44;
                            if (!BlockJigsaw.canAttach(var14, var35)) continue;
                            BlockPosition var36 = var35.pos;
                            BlockPosition var37 = var17.subtract(var36);
                            StructureBoundingBox var38 = var28.getBoundingBox(this.structureManager, var37, var30);
                            int var39 = var38.minY();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching var40 = var28.getProjection();
                            boolean var41 = var40 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
                            int var42 = var36.getY();
                            int var43 = var18 - var42 + BlockJigsaw.getFrontFacing(var14.state).getStepY();
                            if (var9 && var41) {
                                var44 = var122 + var43;
                            } else {
                                if (var19 == -1) {
                                    var19 = this.chunkGenerator.getFirstFreeHeight(var16.getX(), var16.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4);
                                }
                                var44 = var19 - var42;
                            }
                            int var45 = var44 - var39;
                            StructureBoundingBox var46 = var38.moved(0, var45, 0);
                            BlockPosition var47 = var37.offset(0, var45, 0);
                            if (var33 > 0) {
                                var48 = Math.max(var33 + 1, var46.maxY() - var46.minY());
                                var46.encapsulate(new BlockPosition(var46.minX(), var46.minY() + var48, var46.minZ()));
                            }
                            if (VoxelShapes.joinIsNotEmpty((VoxelShape)var24.getValue(), VoxelShapes.create(AxisAlignedBB.of(var46).deflate(0.25)), OperatorBoolean.ONLY_SECOND)) continue;
                            var24.setValue((Object)VoxelShapes.joinUnoptimized((VoxelShape)var24.getValue(), VoxelShapes.create(AxisAlignedBB.of(var46)), OperatorBoolean.ONLY_FIRST));
                            var48 = var0.getGroundLevelDelta();
                            int var49 = var41 ? var48 - var43 : var28.getGroundLevelDelta();
                            WorldGenFeaturePillagerOutpostPoolPiece var50 = this.factory.create(this.structureManager, var28, var47, var49, var30, var46);
                            if (var9) {
                                var51 = var122 + var18;
                            } else if (var41) {
                                var51 = var44 + var42;
                            } else {
                                if (var19 == -1) {
                                    var19 = this.chunkGenerator.getFirstFreeHeight(var16.getX(), var16.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4);
                                }
                                var51 = var19 + var43 / 2;
                            }
                            var0.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var17.getX(), var51 - var18 + var48, var17.getZ(), var43, var40));
                            var50.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var16.getX(), var51 - var42 + var49, var16.getZ(), -var43, var8));
                            this.pieces.add(var50);
                            if (var2 + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new b(var50, var24, var2 + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class b {
        final WorldGenFeaturePillagerOutpostPoolPiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        b(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var1, int var2) {
            this.piece = var0;
            this.free = var1;
            this.depth = var2;
        }
    }
}

