/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.QuartPos;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenNetherPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenNether
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    public static final WeightedRandomList<BiomeSettingsMobs.c> FORTRESS_ENEMIES = WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.BLAZE, 10, 2, 3), new BiomeSettingsMobs.c(EntityTypes.ZOMBIFIED_PIGLIN, 5, 4, 4), new BiomeSettingsMobs.c(EntityTypes.WITHER_SKELETON, 8, 5, 5), new BiomeSettingsMobs.c(EntityTypes.SKELETON, 2, 5, 5), new BiomeSettingsMobs.c(EntityTypes.MAGMA_CUBE, 3, 4, 4)});

    public WorldGenNether(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0, PieceGeneratorSupplier.simple(WorldGenNether::checkLocation, WorldGenNether::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> var0) {
        SeededRandom var1 = new SeededRandom(new LegacyRandomSource(0L));
        var1.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        if (var1.nextInt(5) >= 2) {
            return false;
        }
        return var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var0.chunkPos().getMiddleBlockX()), QuartPos.fromBlock(64), QuartPos.fromBlock(var0.chunkPos().getMiddleBlockZ())));
    }

    private static void generatePieces(StructurePiecesBuilder var0, PieceGenerator.a<WorldGenFeatureEmptyConfiguration> var1) {
        WorldGenNetherPieces.WorldGenNetherPiece15 var2 = new WorldGenNetherPieces.WorldGenNetherPiece15(var1.random(), var1.chunkPos().getBlockX(2), var1.chunkPos().getBlockZ(2));
        var0.addPiece(var2);
        var2.addChildren(var2, var0, var1.random());
        List<StructurePiece> var3 = var2.pendingChildren;
        while (!var3.isEmpty()) {
            int var4 = var1.random().nextInt(var3.size());
            StructurePiece var5 = var3.remove(var4);
            var5.addChildren(var2, var0, var1.random());
        }
        var0.moveInsideHeights(var1.random(), 48, 70);
    }
}

