/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.structure.WorldGenMineshaftPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenMineshaft
extends StructureGenerator<WorldGenMineshaftConfiguration> {
    public WorldGenMineshaft(Codec<WorldGenMineshaftConfiguration> var0) {
        super(var0, PieceGeneratorSupplier.simple(WorldGenMineshaft::checkLocation, WorldGenMineshaft::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.a<WorldGenMineshaftConfiguration> var0) {
        SeededRandom var1 = new SeededRandom(new LegacyRandomSource(0L));
        var1.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        double var2 = ((WorldGenMineshaftConfiguration)var0.config()).probability;
        if (var1.nextDouble() >= var2) {
            return false;
        }
        return var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var0.chunkPos().getMiddleBlockX()), QuartPos.fromBlock(50), QuartPos.fromBlock(var0.chunkPos().getMiddleBlockZ())));
    }

    private static void generatePieces(StructurePiecesBuilder var0, PieceGenerator.a<WorldGenMineshaftConfiguration> var1) {
        WorldGenMineshaftPieces.WorldGenMineshaftRoom var2 = new WorldGenMineshaftPieces.WorldGenMineshaftRoom(0, var1.random(), var1.chunkPos().getBlockX(2), var1.chunkPos().getBlockZ(2), ((WorldGenMineshaftConfiguration)var1.config()).type);
        var0.addPiece(var2);
        var2.addChildren(var2, var0, var1.random());
        int var3 = var1.chunkGenerator().getSeaLevel();
        if (((WorldGenMineshaftConfiguration)var1.config()).type == Type.MESA) {
            BlockPosition var4 = var0.getBoundingBox().getCenter();
            int var5 = var1.chunkGenerator().getBaseHeight(var4.getX(), var4.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var1.heightAccessor());
            int var6 = var5 <= var3 ? var3 : MathHelper.randomBetweenInclusive(var1.random(), var3, var5);
            int var7 = var6 - var4.getY();
            var0.offsetPiecesVertically(var7);
        } else {
            var0.moveBelowSeaLevel(var3, var1.chunkGenerator().getMinY(), var1.random(), 10);
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type NORMAL = new Type("normal", Blocks.OAK_LOG, Blocks.OAK_PLANKS, Blocks.OAK_FENCE);
        public static final /* enum */ Type MESA = new Type("mesa", Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_PLANKS, Blocks.DARK_OAK_FENCE);
        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;
        private final IBlockData woodState;
        private final IBlockData planksState;
        private final IBlockData fenceState;
        private static final /* synthetic */ Type[] i;

        public static Type[] values() {
            return (Type[])i.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, Block var3, Block var4, Block var5) {
            this.name = var2;
            this.woodState = var3.defaultBlockState();
            this.planksState = var4.defaultBlockState();
            this.fenceState = var5.defaultBlockState();
        }

        public String getName() {
            return this.name;
        }

        private static Type byName(String var0) {
            return BY_NAME.get(var0);
        }

        public static Type byId(int var0) {
            if (var0 < 0 || var0 >= Type.values().length) {
                return NORMAL;
            }
            return Type.values()[var0];
        }

        public IBlockData getWoodState() {
            return this.woodState;
        }

        public IBlockData getPlanksState() {
            return this.planksState;
        }

        public IBlockData getFenceState() {
            return this.fenceState;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{NORMAL, MESA};
        }

        static {
            i = Type.f();
            CODEC = INamable.fromEnum(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, var0 -> var0));
        }
    }
}

