/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureJigsaw;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class WorldGenFeaturePillagerOutpost
extends WorldGenFeatureJigsaw {
    public static final WeightedRandomList<BiomeSettingsMobs.c> OUTPOST_ENEMIES = WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.PILLAGER, 1, 1, 1)});

    public WorldGenFeaturePillagerOutpost(Codec<WorldGenFeatureVillageConfiguration> var0) {
        super(var0, 0, true, true, WorldGenFeaturePillagerOutpost::checkLocation);
    }

    private static boolean checkLocation(PieceGeneratorSupplier.a<WorldGenFeatureVillageConfiguration> var0) {
        int var1 = var0.chunkPos().x >> 4;
        int var2 = var0.chunkPos().z >> 4;
        SeededRandom var3 = new SeededRandom(new LegacyRandomSource(0L));
        var3.setSeed((long)(var1 ^ var2 << 4) ^ var0.seed());
        var3.nextInt();
        if (var3.nextInt(5) != 0) {
            return false;
        }
        return !WorldGenFeaturePillagerOutpost.isNearVillage(var0.chunkGenerator(), var0.seed(), var0.chunkPos());
    }

    private static boolean isNearVillage(ChunkGenerator var0, long var1, ChunkCoordIntPair var3) {
        StructureSettingsFeature var4 = var0.getSettings().getConfig(StructureGenerator.VILLAGE);
        if (var4 == null) {
            return false;
        }
        int var5 = var3.x;
        int var6 = var3.z;
        for (int var7 = var5 - 10; var7 <= var5 + 10; ++var7) {
            for (int var8 = var6 - 10; var8 <= var6 + 10; ++var8) {
                ChunkCoordIntPair var9 = StructureGenerator.VILLAGE.getPotentialFeatureChunk(var4, var1, var7, var8);
                if (var7 != var9.x || var8 != var9.z) continue;
                return true;
            }
        }
        return false;
    }
}

