/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenFeatureConfigured<FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> {
    public static final Codec<WorldGenFeatureConfigured<?, ?>> DIRECT_CODEC = IRegistry.FEATURE.byNameCodec().dispatch(var0 -> var0.feature, WorldGenerator::configuredCodec);
    public static final Codec<Supplier<WorldGenFeatureConfigured<?, ?>>> CODEC = RegistryFileCodec.create(IRegistry.CONFIGURED_FEATURE_REGISTRY, DIRECT_CODEC);
    public static final Codec<List<Supplier<WorldGenFeatureConfigured<?, ?>>>> LIST_CODEC = RegistryFileCodec.homogeneousList(IRegistry.CONFIGURED_FEATURE_REGISTRY, DIRECT_CODEC);
    public static final Logger LOGGER = LogManager.getLogger();
    public final F feature;
    public final FC config;

    public WorldGenFeatureConfigured(F var0, FC var1) {
        this.feature = var0;
        this.config = var1;
    }

    public F feature() {
        return this.feature;
    }

    public FC config() {
        return this.config;
    }

    public PlacedFeature placed(List<PlacementModifier> var0) {
        return new PlacedFeature(() -> this, var0);
    }

    public PlacedFeature placed(PlacementModifier ... var0) {
        return this.placed(List.of(var0));
    }

    public PlacedFeature filteredByBlockSurvival(Block var0) {
        return this.filtered(BlockPredicate.wouldSurvive(var0.defaultBlockState(), BlockPosition.ZERO));
    }

    public PlacedFeature onlyWhenEmpty() {
        return this.filtered(BlockPredicate.matchesBlock(Blocks.AIR, BlockPosition.ZERO));
    }

    public PlacedFeature filtered(BlockPredicate var0) {
        return this.placed(BlockPredicateFilter.forPredicate(var0));
    }

    public boolean place(GeneratorAccessSeed var0, ChunkGenerator var1, Random var2, BlockPosition var3) {
        if (var0.ensureCanWrite(var3)) {
            return ((WorldGenerator)this.feature).place(new FeaturePlaceContext<FC>(Optional.empty(), var0, var1, var2, var3, this.config));
        }
        return false;
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> getFeatures() {
        return Stream.concat(Stream.of(this), this.config.getFeatures());
    }

    public String toString() {
        return RegistryGeneration.CONFIGURED_FEATURE.getResourceKey(this).map(Objects::toString).orElseGet(() -> DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).toString());
    }
}

