/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.WorldGenEndCityPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class WorldGenEndCity
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final int RANDOM_SALT = 10387313;

    public WorldGenEndCity(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0, WorldGenEndCity::pieceGeneratorSupplier);
    }

    @Override
    protected boolean linearSeparation() {
        return false;
    }

    private static int getYPositionForFeature(ChunkCoordIntPair var0, ChunkGenerator var1, LevelHeightAccessor var2) {
        Random var3 = new Random(var0.x + var0.z * 10387313);
        EnumBlockRotation var4 = EnumBlockRotation.getRandom(var3);
        int var5 = 5;
        int var6 = 5;
        if (var4 == EnumBlockRotation.CLOCKWISE_90) {
            var5 = -5;
        } else if (var4 == EnumBlockRotation.CLOCKWISE_180) {
            var5 = -5;
            var6 = -5;
        } else if (var4 == EnumBlockRotation.COUNTERCLOCKWISE_90) {
            var6 = -5;
        }
        int var7 = var0.getBlockX(7);
        int var8 = var0.getBlockZ(7);
        int var9 = var1.getFirstOccupiedHeight(var7, var8, HeightMap.Type.WORLD_SURFACE_WG, var2);
        int var10 = var1.getFirstOccupiedHeight(var7, var8 + var6, HeightMap.Type.WORLD_SURFACE_WG, var2);
        int var11 = var1.getFirstOccupiedHeight(var7 + var5, var8, HeightMap.Type.WORLD_SURFACE_WG, var2);
        int var12 = var1.getFirstOccupiedHeight(var7 + var5, var8 + var6, HeightMap.Type.WORLD_SURFACE_WG, var2);
        return Math.min(Math.min(var9, var10), Math.min(var11, var12));
    }

    private static Optional<PieceGenerator<WorldGenFeatureEmptyConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> var0) {
        int var12 = WorldGenEndCity.getYPositionForFeature(var0.chunkPos(), var0.chunkGenerator(), var0.heightAccessor());
        if (var12 < 60) {
            return Optional.empty();
        }
        BlockPosition var22 = var0.chunkPos().getMiddleBlockPosition(var12);
        if (!var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var22.getX()), QuartPos.fromBlock(var22.getY()), QuartPos.fromBlock(var22.getZ())))) {
            return Optional.empty();
        }
        return Optional.of((var1, var2) -> {
            EnumBlockRotation var3 = EnumBlockRotation.getRandom(var2.random());
            ArrayList var4 = Lists.newArrayList();
            WorldGenEndCityPieces.startHouseTower(var2.structureManager(), var22, var3, var4, var2.random());
            var4.forEach(var1::addPiece);
        });
    }
}

