/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.structure.WorldGenBuriedTreasurePieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenBuriedTreasure
extends StructureGenerator<WorldGenFeatureConfigurationChance> {
    private static final int RANDOM_SALT = 10387320;

    public WorldGenBuriedTreasure(Codec<WorldGenFeatureConfigurationChance> var0) {
        super(var0, PieceGeneratorSupplier.simple(WorldGenBuriedTreasure::checkLocation, WorldGenBuriedTreasure::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.a<WorldGenFeatureConfigurationChance> var0) {
        SeededRandom var1 = new SeededRandom(new LegacyRandomSource(0L));
        var1.setLargeFeatureWithSalt(var0.seed(), var0.chunkPos().x, var0.chunkPos().z, 10387320);
        return var1.nextFloat() < ((WorldGenFeatureConfigurationChance)var0.config()).probability && var0.validBiomeOnTop(HeightMap.Type.OCEAN_FLOOR_WG);
    }

    private static void generatePieces(StructurePiecesBuilder var0, PieceGenerator.a<WorldGenFeatureConfigurationChance> var1) {
        BlockPosition var2 = new BlockPosition(var1.chunkPos().getBlockX(9), 90, var1.chunkPos().getBlockZ(9));
        var0.addPiece(new WorldGenBuriedTreasurePieces.a(var2));
    }

    @Override
    public BlockPosition getLocatePos(ChunkCoordIntPair var0) {
        return new BlockPosition(var0.getBlockX(9), 0, var0.getBlockZ(9));
    }
}

