/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;

public class RootSystemFeature
extends WorldGenerator<RootSystemConfiguration> {
    public RootSystemFeature(Codec<RootSystemConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<RootSystemConfiguration> var0) {
        BlockPosition var2;
        GeneratorAccessSeed var1 = var0.level();
        if (!var1.getBlockState(var2 = var0.origin()).isAir()) {
            return false;
        }
        Random var3 = var0.random();
        BlockPosition var4 = var0.origin();
        RootSystemConfiguration var5 = var0.config();
        BlockPosition.MutableBlockPosition var6 = var4.mutable();
        if (RootSystemFeature.placeDirtAndTree(var1, var0.chunkGenerator(), var5, var3, var6, var4)) {
            RootSystemFeature.placeRoots(var1, var5, var3, var4, var6);
        }
        return true;
    }

    private static boolean spaceForTree(GeneratorAccessSeed var0, RootSystemConfiguration var1, BlockPosition var2) {
        BlockPosition.MutableBlockPosition var3 = var2.mutable();
        for (int var4 = 1; var4 <= var1.requiredVerticalSpaceForTree; ++var4) {
            var3.move(EnumDirection.UP);
            IBlockData var5 = var0.getBlockState(var3);
            if (RootSystemFeature.isAllowedTreeSpace(var5, var4, var1.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedTreeSpace(IBlockData var0, int var1, int var2) {
        return var0.isAir() || var1 <= var2 && var0.getFluidState().is(TagsFluid.WATER);
    }

    private static boolean placeDirtAndTree(GeneratorAccessSeed var0, ChunkGenerator var1, RootSystemConfiguration var2, Random var3, BlockPosition.MutableBlockPosition var4, BlockPosition var5) {
        for (int var6 = 0; var6 < var2.rootColumnMaxHeight; ++var6) {
            var4.move(EnumDirection.UP);
            if (!var2.allowedTreePosition.test(var0, var4) || !RootSystemFeature.spaceForTree(var0, var2, var4)) continue;
            BaseBlockPosition var7 = var4.below();
            if (var0.getFluidState((BlockPosition)var7).is(TagsFluid.LAVA) || !var0.getBlockState((BlockPosition)var7).getMaterial().isSolid()) {
                return false;
            }
            if (!var2.treeFeature.get().place(var0, var1, var3, var4)) continue;
            RootSystemFeature.placeDirt(var5, var5.getY() + var6, var0, var2, var3);
            return true;
        }
        return false;
    }

    private static void placeDirt(BlockPosition var0, int var1, GeneratorAccessSeed var2, RootSystemConfiguration var3, Random var4) {
        int var5 = var0.getX();
        int var6 = var0.getZ();
        BlockPosition.MutableBlockPosition var7 = var0.mutable();
        for (int var8 = var0.getY(); var8 < var1; ++var8) {
            RootSystemFeature.placeRootedDirt(var2, var3, var4, var5, var6, var7.set(var5, var8, var6));
        }
    }

    private static void placeRootedDirt(GeneratorAccessSeed var02, RootSystemConfiguration var12, Random var2, int var3, int var4, BlockPosition.MutableBlockPosition var5) {
        int var6 = var12.rootRadius;
        Tag<Block> var7 = TagsBlock.getAllTags().getTag(var12.rootReplaceable);
        Predicate<IBlockData> var8 = var7 == null ? var0 -> true : var1 -> var1.is(var7);
        for (int var9 = 0; var9 < var12.rootPlacementAttempts; ++var9) {
            var5.setWithOffset(var5, var2.nextInt(var6) - var2.nextInt(var6), 0, var2.nextInt(var6) - var2.nextInt(var6));
            if (var8.test(var02.getBlockState(var5))) {
                var02.setBlock(var5, var12.rootStateProvider.getState(var2, var5), 2);
            }
            var5.setX(var3);
            var5.setZ(var4);
        }
    }

    private static void placeRoots(GeneratorAccessSeed var0, RootSystemConfiguration var1, Random var2, BlockPosition var3, BlockPosition.MutableBlockPosition var4) {
        int var5 = var1.hangingRootRadius;
        int var6 = var1.hangingRootsVerticalSpan;
        for (int var7 = 0; var7 < var1.hangingRootPlacementAttempts; ++var7) {
            IBlockData var8;
            var4.setWithOffset(var3, var2.nextInt(var5) - var2.nextInt(var5), var2.nextInt(var6) - var2.nextInt(var6), var2.nextInt(var5) - var2.nextInt(var5));
            if (!var0.isEmptyBlock(var4) || !(var8 = var1.hangingRootStateProvider.getState(var2, var4)).canSurvive(var0, var4) || !var0.getBlockState((BlockPosition)var4.above()).isFaceSturdy(var0, var4, EnumDirection.DOWN)) continue;
            var0.setBlock(var4, var8, 2);
        }
    }
}

