/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCanyon;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.carver.WorldGenCaves;
import net.minecraft.world.level.levelgen.carver.WorldGenCavesHell;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldGenCarverAbstract<C extends WorldGenCarverConfiguration> {
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> CAVE = WorldGenCarverAbstract.register("cave", new WorldGenCaves(CaveCarverConfiguration.CODEC));
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> NETHER_CAVE = WorldGenCarverAbstract.register("nether_cave", new WorldGenCavesHell(CaveCarverConfiguration.CODEC));
    public static final WorldGenCarverAbstract<CanyonCarverConfiguration> CANYON = WorldGenCarverAbstract.register("canyon", new WorldGenCanyon(CanyonCarverConfiguration.CODEC));
    protected static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    protected static final IBlockData CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected static final Fluid WATER = FluidTypes.WATER.defaultFluidState();
    protected static final Fluid LAVA = FluidTypes.LAVA.defaultFluidState();
    protected Set<Block> replaceableBlocks = ImmutableSet.of((Object)Blocks.WATER, (Object)Blocks.STONE, (Object)Blocks.GRANITE, (Object)Blocks.DIORITE, (Object)Blocks.ANDESITE, (Object)Blocks.DIRT, (Object[])new Block[]{Blocks.COARSE_DIRT, Blocks.PODZOL, Blocks.GRASS_BLOCK, Blocks.TERRACOTTA, Blocks.WHITE_TERRACOTTA, Blocks.ORANGE_TERRACOTTA, Blocks.MAGENTA_TERRACOTTA, Blocks.LIGHT_BLUE_TERRACOTTA, Blocks.YELLOW_TERRACOTTA, Blocks.LIME_TERRACOTTA, Blocks.PINK_TERRACOTTA, Blocks.GRAY_TERRACOTTA, Blocks.LIGHT_GRAY_TERRACOTTA, Blocks.CYAN_TERRACOTTA, Blocks.PURPLE_TERRACOTTA, Blocks.BLUE_TERRACOTTA, Blocks.BROWN_TERRACOTTA, Blocks.GREEN_TERRACOTTA, Blocks.RED_TERRACOTTA, Blocks.BLACK_TERRACOTTA, Blocks.SANDSTONE, Blocks.RED_SANDSTONE, Blocks.MYCELIUM, Blocks.SNOW, Blocks.PACKED_ICE, Blocks.DEEPSLATE, Blocks.CALCITE, Blocks.SAND, Blocks.RED_SAND, Blocks.GRAVEL, Blocks.TUFF, Blocks.GRANITE, Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.RAW_IRON_BLOCK, Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.RAW_COPPER_BLOCK});
    protected Set<FluidType> liquids = ImmutableSet.of((Object)FluidTypes.WATER);
    private final Codec<WorldGenCarverWrapper<C>> configuredCodec;

    private static <C extends WorldGenCarverConfiguration, F extends WorldGenCarverAbstract<C>> F register(String var0, F var1) {
        return (F)IRegistry.register(IRegistry.CARVER, var0, var1);
    }

    public WorldGenCarverAbstract(Codec<C> var0) {
        this.configuredCodec = var0.fieldOf("config").xmap(this::configured, WorldGenCarverWrapper::config).codec();
    }

    public WorldGenCarverWrapper<C> configured(C var0) {
        return new WorldGenCarverWrapper<C>(this, var0);
    }

    public Codec<WorldGenCarverWrapper<C>> configuredCodec() {
        return this.configuredCodec;
    }

    public int getRange() {
        return 4;
    }

    protected boolean carveEllipsoid(CarvingContext var0, C var1, IChunkAccess var2, Function<BlockPosition, BiomeBase> var3, Aquifer var4, double var5, double var7, double var9, double var11, double var13, CarvingMask var15, a var16) {
        ChunkCoordIntPair var17 = var2.getPos();
        double var18 = var17.getMiddleBlockX();
        double var20 = var17.getMiddleBlockZ();
        double var22 = 16.0 + var11 * 2.0;
        if (Math.abs(var5 - var18) > var22 || Math.abs(var9 - var20) > var22) {
            return false;
        }
        int var24 = var17.getMinBlockX();
        int var25 = var17.getMinBlockZ();
        int var26 = Math.max(MathHelper.floor(var5 - var11) - var24 - 1, 0);
        int var27 = Math.min(MathHelper.floor(var5 + var11) - var24, 15);
        int var28 = Math.max(MathHelper.floor(var7 - var13) - 1, var0.getMinGenY() + 1);
        int var29 = Math.min(MathHelper.floor(var7 + var13) + 1, var0.getMinGenY() + var0.getGenDepth() - 2);
        int var30 = Math.max(MathHelper.floor(var9 - var11) - var25 - 1, 0);
        int var31 = Math.min(MathHelper.floor(var9 + var11) - var25, 15);
        boolean var32 = false;
        BlockPosition.MutableBlockPosition var33 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var34 = new BlockPosition.MutableBlockPosition();
        for (int var35 = var26; var35 <= var27; ++var35) {
            int var36 = var17.getBlockX(var35);
            double var37 = ((double)var36 + 0.5 - var5) / var11;
            for (int var39 = var30; var39 <= var31; ++var39) {
                int var40 = var17.getBlockZ(var39);
                double var41 = ((double)var40 + 0.5 - var9) / var11;
                if (var37 * var37 + var41 * var41 >= 1.0) continue;
                MutableBoolean var43 = new MutableBoolean(false);
                for (int var44 = var29; var44 > var28; --var44) {
                    double var45 = ((double)var44 - 0.5 - var7) / var13;
                    if (var16.shouldSkip(var0, var37, var45, var41, var44) || var15.get(var35, var44, var39) && !WorldGenCarverAbstract.isDebugEnabled(var1)) continue;
                    var15.set(var35, var44, var39);
                    var33.set(var36, var44, var40);
                    var32 |= this.carveBlock(var0, var1, var2, var3, var15, var33, var34, var4, var43);
                }
            }
        }
        return var32;
    }

    protected boolean carveBlock(CarvingContext var0, C var1, IChunkAccess var22, Function<BlockPosition, BiomeBase> var3, CarvingMask var4, BlockPosition.MutableBlockPosition var5, BlockPosition.MutableBlockPosition var6, Aquifer var7, MutableBoolean var8) {
        IBlockData var9 = var22.getBlockState(var5);
        if (var9.is(Blocks.GRASS_BLOCK) || var9.is(Blocks.MYCELIUM)) {
            var8.setTrue();
        }
        if (!this.canReplaceBlock(var9) && !WorldGenCarverAbstract.isDebugEnabled(var1)) {
            return false;
        }
        IBlockData var10 = this.getCarveState(var0, var1, var5, var7);
        if (var10 == null) {
            return false;
        }
        var22.setBlockState(var5, var10, false);
        if (var7.shouldScheduleFluidUpdate() && !var10.getFluidState().isEmpty()) {
            var22.markPosForPostprocessing(var5);
        }
        if (var8.isTrue()) {
            var6.setWithOffset((BaseBlockPosition)var5, EnumDirection.DOWN);
            if (var22.getBlockState(var6).is(Blocks.DIRT)) {
                var0.topMaterial(var3, var22, var6, !var10.getFluidState().isEmpty()).ifPresent(var2 -> {
                    var22.setBlockState(var6, (IBlockData)var2, false);
                    if (!var2.getFluidState().isEmpty()) {
                        var22.markPosForPostprocessing(var6);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private IBlockData getCarveState(CarvingContext var0, C var1, BlockPosition var2, Aquifer var3) {
        if (var2.getY() <= ((WorldGenCarverConfiguration)var1).lavaLevel.resolveY(var0)) {
            return LAVA.createLegacyBlock();
        }
        IBlockData var4 = var3.computeSubstance(var2.getX(), var2.getY(), var2.getZ(), 0.0, 0.0);
        if (var4 == null) {
            return WorldGenCarverAbstract.isDebugEnabled(var1) ? ((WorldGenCarverConfiguration)var1).debugSettings.getBarrierState() : null;
        }
        return WorldGenCarverAbstract.isDebugEnabled(var1) ? WorldGenCarverAbstract.getDebugState(var1, var4) : var4;
    }

    private static IBlockData getDebugState(WorldGenCarverConfiguration var0, IBlockData var1) {
        if (var1.is(Blocks.AIR)) {
            return var0.debugSettings.getAirState();
        }
        if (var1.is(Blocks.WATER)) {
            IBlockData var2 = var0.debugSettings.getWaterState();
            if (var2.hasProperty(BlockProperties.WATERLOGGED)) {
                return (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, true);
            }
            return var2;
        }
        if (var1.is(Blocks.LAVA)) {
            return var0.debugSettings.getLavaState();
        }
        return var1;
    }

    public abstract boolean carve(CarvingContext var1, C var2, IChunkAccess var3, Function<BlockPosition, BiomeBase> var4, Random var5, Aquifer var6, ChunkCoordIntPair var7, CarvingMask var8);

    public abstract boolean isStartChunk(C var1, Random var2);

    protected boolean canReplaceBlock(IBlockData var0) {
        return this.replaceableBlocks.contains(var0.getBlock());
    }

    protected static boolean canReach(ChunkCoordIntPair var0, double var1, double var3, int var5, int var6, float var7) {
        double var18;
        double var16;
        double var10;
        double var14;
        double var8 = var0.getMiddleBlockX();
        double var12 = var1 - var8;
        return var12 * var12 + (var14 = var3 - (var10 = (double)var0.getMiddleBlockZ())) * var14 - (var16 = (double)(var6 - var5)) * var16 <= (var18 = (double)(var7 + 2.0f + 16.0f)) * var18;
    }

    private static boolean isDebugEnabled(WorldGenCarverConfiguration var0) {
        return var0.debugSettings.isDebugMode();
    }

    public static interface a {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

