/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCanyon
extends WorldGenCarverAbstract<CanyonCarverConfiguration> {
    public WorldGenCanyon(Codec<CanyonCarverConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean isStartChunk(CanyonCarverConfiguration var0, Random var1) {
        return var1.nextFloat() <= var0.probability;
    }

    @Override
    public boolean carve(CarvingContext var0, CanyonCarverConfiguration var1, IChunkAccess var2, Function<BlockPosition, BiomeBase> var3, Random var4, Aquifer var5, ChunkCoordIntPair var6, CarvingMask var7) {
        int var8 = (this.getRange() * 2 - 1) * 16;
        double var9 = var6.getBlockX(var4.nextInt(16));
        int var11 = var1.y.sample(var4, var0);
        double var12 = var6.getBlockZ(var4.nextInt(16));
        float var14 = var4.nextFloat() * ((float)Math.PI * 2);
        float var15 = var1.verticalRotation.sample(var4);
        double var16 = var1.yScale.sample(var4);
        float var18 = var1.shape.thickness.sample(var4);
        int var19 = (int)((float)var8 * var1.shape.distanceFactor.sample(var4));
        boolean var20 = false;
        this.doCarve(var0, var1, var2, var3, var4.nextLong(), var5, var9, var11, var12, var18, var14, var15, 0, var19, var16, var7);
        return true;
    }

    private void doCarve(CarvingContext var0, CanyonCarverConfiguration var12, IChunkAccess var22, Function<BlockPosition, BiomeBase> var3, long var42, Aquifer var62, double var7, double var9, double var11, float var13, float var14, float var15, int var16, int var17, double var18, CarvingMask var20) {
        Random var21 = new Random(var42);
        float[] var222 = this.initWidthFactors(var0, var12, var21);
        float var23 = 0.0f;
        float var24 = 0.0f;
        for (int var25 = var16; var25 < var17; ++var25) {
            double var26 = 1.5 + (double)(MathHelper.sin((float)var25 * (float)Math.PI / (float)var17) * var13);
            double var28 = var26 * var18;
            var26 *= (double)var12.shape.horizontalRadiusFactor.sample(var21);
            var28 = this.updateVerticalRadius(var12, var21, var28, var17, var25);
            float var30 = MathHelper.cos(var15);
            float var31 = MathHelper.sin(var15);
            var7 += (double)(MathHelper.cos(var14) * var30);
            var9 += (double)var31;
            var11 += (double)(MathHelper.sin(var14) * var30);
            var15 *= 0.7f;
            var15 += var24 * 0.05f;
            var14 += var23 * 0.05f;
            var24 *= 0.8f;
            var23 *= 0.5f;
            var24 += (var21.nextFloat() - var21.nextFloat()) * var21.nextFloat() * 2.0f;
            var23 += (var21.nextFloat() - var21.nextFloat()) * var21.nextFloat() * 4.0f;
            if (var21.nextInt(4) == 0) continue;
            if (!WorldGenCanyon.canReach(var22.getPos(), var7, var11, var25, var17, var13)) {
                return;
            }
            this.carveEllipsoid(var0, var12, var22, var3, var62, var7, var9, var11, var26, var28, var20, (var1, var2, var4, var6, var8) -> this.shouldSkip(var1, var222, var2, var4, var6, var8));
        }
    }

    private float[] initWidthFactors(CarvingContext var0, CanyonCarverConfiguration var1, Random var2) {
        int var3 = var0.getGenDepth();
        float[] var4 = new float[var3];
        float var5 = 1.0f;
        for (int var6 = 0; var6 < var3; ++var6) {
            if (var6 == 0 || var2.nextInt(var1.shape.widthSmoothness) == 0) {
                var5 = 1.0f + var2.nextFloat() * var2.nextFloat();
            }
            var4[var6] = var5 * var5;
        }
        return var4;
    }

    private double updateVerticalRadius(CanyonCarverConfiguration var0, Random var1, double var2, float var4, float var5) {
        float var6 = 1.0f - MathHelper.abs(0.5f - var5 / var4) * 2.0f;
        float var7 = var0.shape.verticalRadiusDefaultFactor + var0.shape.verticalRadiusCenterFactor * var6;
        return (double)var7 * var2 * (double)MathHelper.randomBetween(var1, 0.75f, 1.0f);
    }

    private boolean shouldSkip(CarvingContext var0, float[] var1, double var2, double var4, double var6, int var8) {
        int var9 = var8 - var0.getMinGenY();
        return (var2 * var2 + var6 * var6) * (double)var1[var9 - 1] + var4 * var4 / 6.0 >= 1.0;
    }
}

