/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.NotPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate;
import net.minecraft.world.level.material.FluidType;

public interface BlockPredicate
extends BiPredicate<GeneratorAccessSeed, BlockPosition> {
    public static final Codec<BlockPredicate> CODEC = IRegistry.BLOCK_PREDICATE_TYPES.byNameCodec().dispatch(BlockPredicate::type, BlockPredicateType::codec);
    public static final BlockPredicate ONLY_IN_AIR_PREDICATE = BlockPredicate.matchesBlock(Blocks.AIR, BlockPosition.ZERO);
    public static final BlockPredicate ONLY_IN_AIR_OR_WATER_PREDICATE = BlockPredicate.matchesBlocks(List.of(Blocks.AIR, Blocks.WATER), BlockPosition.ZERO);

    public BlockPredicateType<?> type();

    public static BlockPredicate allOf(List<BlockPredicate> var0) {
        return new AllOfPredicate(var0);
    }

    public static BlockPredicate allOf(BlockPredicate ... var0) {
        return BlockPredicate.allOf(List.of(var0));
    }

    public static BlockPredicate allOf(BlockPredicate var0, BlockPredicate var1) {
        return BlockPredicate.allOf(List.of(var0, var1));
    }

    public static BlockPredicate anyOf(List<BlockPredicate> var0) {
        return new AnyOfPredicate(var0);
    }

    public static BlockPredicate anyOf(BlockPredicate ... var0) {
        return BlockPredicate.anyOf(List.of(var0));
    }

    public static BlockPredicate anyOf(BlockPredicate var0, BlockPredicate var1) {
        return BlockPredicate.anyOf(List.of(var0, var1));
    }

    public static BlockPredicate matchesBlocks(List<Block> var0, BaseBlockPosition var1) {
        return new MatchingBlocksPredicate(var1, var0);
    }

    public static BlockPredicate matchesBlocks(List<Block> var0) {
        return BlockPredicate.matchesBlocks(var0, BaseBlockPosition.ZERO);
    }

    public static BlockPredicate matchesBlock(Block var0, BaseBlockPosition var1) {
        return BlockPredicate.matchesBlocks(List.of(var0), var1);
    }

    public static BlockPredicate matchesTag(Tag<Block> var0, BaseBlockPosition var1) {
        return new MatchingBlockTagPredicate(var1, var0);
    }

    public static BlockPredicate matchesTag(Tag<Block> var0) {
        return BlockPredicate.matchesTag(var0, BaseBlockPosition.ZERO);
    }

    public static BlockPredicate matchesFluids(List<FluidType> var0, BaseBlockPosition var1) {
        return new MatchingFluidsPredicate(var1, var0);
    }

    public static BlockPredicate matchesFluid(FluidType var0, BaseBlockPosition var1) {
        return BlockPredicate.matchesFluids(List.of(var0), var1);
    }

    public static BlockPredicate not(BlockPredicate var0) {
        return new NotPredicate(var0);
    }

    public static BlockPredicate replaceable(BaseBlockPosition var0) {
        return new ReplaceablePredicate(var0);
    }

    public static BlockPredicate replaceable() {
        return BlockPredicate.replaceable(BaseBlockPosition.ZERO);
    }

    public static BlockPredicate wouldSurvive(IBlockData var0, BaseBlockPosition var1) {
        return new WouldSurvivePredicate(var1, var0);
    }

    public static BlockPredicate hasSturdyFace(BaseBlockPosition var0, EnumDirection var1) {
        return new HasSturdyFacePredicate(var0, var1);
    }

    public static BlockPredicate solid(BaseBlockPosition var0) {
        return new SolidPredicate(var0);
    }

    public static BlockPredicate solid() {
        return BlockPredicate.solid(BaseBlockPosition.ZERO);
    }

    public static BlockPredicate insideWorld(BaseBlockPosition var0) {
        return new InsideWorldBoundsPredicate(var0);
    }

    public static BlockPredicate alwaysTrue() {
        return TrueBlockPredicate.INSTANCE;
    }
}

