/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.QuartPos;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender EMPTY = new Blender(null, List.of(), List.of()){

        @Override
        public TerrainInfo blendOffsetAndFactor(int var0, int var1, TerrainInfo var2) {
            return var2;
        }

        @Override
        public double blendDensity(int var0, int var1, int var2, double var3) {
            return var3;
        }

        @Override
        public BiomeResolver getBiomeResolver(BiomeResolver var0) {
            return var0;
        }
    };
    private static final NoiseGeneratorNormal SHIFT_NOISE = NoiseGeneratorNormal.create(new XoroshiroRandomSource(42L), RegistryGeneration.NOISE.getOrThrow(Noises.SHIFT));
    private static final int HEIGHT_BLENDING_RANGE_CELLS = QuartPos.fromSection(7) - 1;
    private static final int HEIGHT_BLENDING_RANGE_CHUNKS = QuartPos.toSection(HEIGHT_BLENDING_RANGE_CELLS + 3);
    private static final int DENSITY_BLENDING_RANGE_CELLS = 2;
    private static final int DENSITY_BLENDING_RANGE_CHUNKS = QuartPos.toSection(5);
    private static final double BLENDING_FACTOR = 10.0;
    private static final double BLENDING_JAGGEDNESS = 0.0;
    private static final double OLD_CHUNK_Y_RADIUS = (double)BlendingData.AREA_WITH_OLD_GENERATION.getHeight() / 2.0;
    private static final double OLD_CHUNK_CENTER_Y = (double)BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight() + OLD_CHUNK_Y_RADIUS;
    private static final double OLD_CHUNK_XZ_RADIUS = 8.0;
    private final RegionLimitedWorldAccess region;
    private final List<c> heightData;
    private final List<c> densityData;

    public static Blender empty() {
        return EMPTY;
    }

    public static Blender of(@Nullable RegionLimitedWorldAccess var0) {
        if (var0 == null) {
            return EMPTY;
        }
        ArrayList var1 = Lists.newArrayList();
        ArrayList var2 = Lists.newArrayList();
        ChunkCoordIntPair var3 = var0.getCenter();
        for (int var4 = -HEIGHT_BLENDING_RANGE_CHUNKS; var4 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var4) {
            for (int var5 = -HEIGHT_BLENDING_RANGE_CHUNKS; var5 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var5) {
                int var6 = var3.x + var4;
                int var7 = var3.z + var5;
                BlendingData var8 = BlendingData.getOrUpdateBlendingData(var0, var6, var7);
                if (var8 == null) continue;
                c var9 = new c(var6, var7, var8);
                var1.add(var9);
                if (var4 < -DENSITY_BLENDING_RANGE_CHUNKS || var4 > DENSITY_BLENDING_RANGE_CHUNKS || var5 < -DENSITY_BLENDING_RANGE_CHUNKS || var5 > DENSITY_BLENDING_RANGE_CHUNKS) continue;
                var2.add(var9);
            }
        }
        if (var1.isEmpty() && var2.isEmpty()) {
            return EMPTY;
        }
        return new Blender(var0, var1, var2);
    }

    Blender(RegionLimitedWorldAccess var0, List<c> var1, List<c> var2) {
        this.region = var0;
        this.heightData = var1;
        this.densityData = var2;
    }

    public TerrainInfo blendOffsetAndFactor(int var0, int var1, TerrainInfo var2) {
        int var4;
        int var3 = QuartPos.fromBlock(var0);
        double var52 = this.getBlendingDataValue(var3, 0, var4 = QuartPos.fromBlock(var1), BlendingData::getHeight);
        if (var52 != Double.MAX_VALUE) {
            return new TerrainInfo(Blender.heightToOffset(var52), 10.0, 0.0);
        }
        MutableDouble var72 = new MutableDouble(0.0);
        MutableDouble var8 = new MutableDouble(0.0);
        MutableDouble var9 = new MutableDouble(Double.POSITIVE_INFINITY);
        for (c var11 : this.heightData) {
            var11.blendingData.iterateHeights(QuartPos.fromSection(var11.chunkX), QuartPos.fromSection(var11.chunkZ), (var5, var6, var7) -> {
                double var9 = MathHelper.length(var3 - var5, var4 - var6);
                if (var9 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                    return;
                }
                if (var9 < var9.doubleValue()) {
                    var9.setValue(var9);
                }
                double var11 = 1.0 / (var9 * var9 * var9 * var9);
                var8.add(var7 * var11);
                var72.add(var11);
            });
        }
        if (var9.doubleValue() == Double.POSITIVE_INFINITY) {
            return var2;
        }
        double var10 = var8.doubleValue() / var72.doubleValue();
        double var12 = MathHelper.clamp(var9.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        var12 = 3.0 * var12 * var12 - 2.0 * var12 * var12 * var12;
        double var14 = MathHelper.lerp(var12, Blender.heightToOffset(var10), var2.offset());
        double var16 = MathHelper.lerp(var12, 10.0, var2.factor());
        double var18 = MathHelper.lerp(var12, 0.0, var2.jaggedness());
        return new TerrainInfo(var14, var16, var18);
    }

    private static double heightToOffset(double var0) {
        double var2 = 1.0;
        double var4 = var0 + 0.5;
        double var6 = MathHelper.positiveModulo(var4, 8.0);
        return 1.0 * (32.0 * (var4 - 128.0) - 3.0 * (var4 - 120.0) * var6 + 3.0 * var6 * var6) / (128.0 * (32.0 - 3.0 * var6));
    }

    public double blendDensity(int var0, int var1, int var2, double var3) {
        int var72;
        int var62;
        int var5 = QuartPos.fromBlock(var0);
        double var82 = this.getBlendingDataValue(var5, var62 = var1 / 8, var72 = QuartPos.fromBlock(var2), BlendingData::getDensity);
        if (var82 != Double.MAX_VALUE) {
            return var82;
        }
        MutableDouble var10 = new MutableDouble(0.0);
        MutableDouble var11 = new MutableDouble(0.0);
        MutableDouble var12 = new MutableDouble(Double.POSITIVE_INFINITY);
        for (c var14 : this.densityData) {
            var14.blendingData.iterateDensities(QuartPos.fromSection(var14.chunkX), QuartPos.fromSection(var14.chunkZ), var62 - 1, var62 + 1, (var6, var7, var8, var9) -> {
                double var11 = MathHelper.length(var5 - var6, (var62 - var7) * 2, var72 - var8);
                if (var11 > 2.0) {
                    return;
                }
                if (var11 < var12.doubleValue()) {
                    var12.setValue(var11);
                }
                double var13 = 1.0 / (var11 * var11 * var11 * var11);
                var11.add(var9 * var13);
                var10.add(var13);
            });
        }
        if (var12.doubleValue() == Double.POSITIVE_INFINITY) {
            return var3;
        }
        double var13 = var11.doubleValue() / var10.doubleValue();
        double var15 = MathHelper.clamp(var12.doubleValue() / 3.0, 0.0, 1.0);
        return MathHelper.lerp(var15, var13, var3);
    }

    private double getBlendingDataValue(int var0, int var1, int var2, a var3) {
        int var4 = QuartPos.toSection(var0);
        int var5 = QuartPos.toSection(var2);
        boolean var6 = (var0 & 3) == 0;
        boolean var7 = (var2 & 3) == 0;
        double var8 = this.getBlendingDataValue(var3, var4, var5, var0, var1, var2);
        if (var8 == Double.MAX_VALUE) {
            if (var6 && var7) {
                var8 = this.getBlendingDataValue(var3, var4 - 1, var5 - 1, var0, var1, var2);
            }
            if (var8 == Double.MAX_VALUE) {
                if (var6) {
                    var8 = this.getBlendingDataValue(var3, var4 - 1, var5, var0, var1, var2);
                }
                if (var8 == Double.MAX_VALUE && var7) {
                    var8 = this.getBlendingDataValue(var3, var4, var5 - 1, var0, var1, var2);
                }
            }
        }
        return var8;
    }

    private double getBlendingDataValue(a var0, int var1, int var2, int var3, int var4, int var5) {
        BlendingData var6 = BlendingData.getOrUpdateBlendingData(this.region, var1, var2);
        if (var6 != null) {
            return var0.get(var6, var3 - QuartPos.fromSection(var1), var4, var5 - QuartPos.fromSection(var2));
        }
        return Double.MAX_VALUE;
    }

    public BiomeResolver getBiomeResolver(BiomeResolver var0) {
        return (var1, var2, var3, var4) -> {
            BiomeBase var5 = this.blendBiome(var1, var2, var3);
            if (var5 == null) {
                return var0.getNoiseBiome(var1, var2, var3, var4);
            }
            return var5;
        };
    }

    @Nullable
    private BiomeBase blendBiome(int var0, int var1, int var2) {
        double var3 = (double)var0 + SHIFT_NOISE.getValue(var0, 0.0, var2) * 12.0;
        double var5 = (double)var2 + SHIFT_NOISE.getValue(var2, var0, 0.0) * 12.0;
        MutableDouble var7 = new MutableDouble(Double.POSITIVE_INFINITY);
        BlockPosition.MutableBlockPosition var82 = new BlockPosition.MutableBlockPosition();
        MutableObject var92 = new MutableObject();
        for (c var11 : this.heightData) {
            var11.blendingData.iterateHeights(QuartPos.fromSection(var11.chunkX), QuartPos.fromSection(var11.chunkZ), (var8, var9, var10) -> {
                double var12 = MathHelper.length(var3 - (double)var8, var5 - (double)var9);
                if (var12 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                    return;
                }
                if (var12 < var7.doubleValue()) {
                    var92.setValue((Object)new ChunkCoordIntPair(var6.chunkX, var6.chunkZ));
                    var82.set(var8, QuartPos.fromBlock(MathHelper.floor(var10)), var9);
                    var7.setValue(var12);
                }
            });
        }
        if (var7.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double var102 = MathHelper.clamp(var7.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        if (var102 > 0.5) {
            return null;
        }
        IChunkAccess var12 = this.region.getChunk(((ChunkCoordIntPair)var92.getValue()).x, ((ChunkCoordIntPair)var92.getValue()).z);
        return var12.getNoiseBiome(Math.min(var82.getX() & 3, 3), var82.getY(), Math.min(var82.getZ() & 3, 3));
    }

    public static void generateBorderTicks(RegionLimitedWorldAccess var0, IChunkAccess var1) {
        ChunkCoordIntPair var2 = var1.getPos();
        boolean var3 = var1.isOldNoiseGeneration();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        BlockPosition var5 = new BlockPosition(var2.getMinBlockX(), 0, var2.getMinBlockZ());
        int var6 = BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight();
        int var7 = BlendingData.AREA_WITH_OLD_GENERATION.getMaxBuildHeight() - 1;
        if (var3) {
            for (int var8 = 0; var8 < 16; ++var8) {
                for (int var9 = 0; var9 < 16; ++var9) {
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var6 - 1, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var6, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var7, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var7 + 1, var9));
                }
            }
        }
        for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (var0.getChunk(var2.x + var9.getStepX(), var2.z + var9.getStepZ()).isOldNoiseGeneration() == var3) continue;
            int var10 = var9 == EnumDirection.EAST ? 15 : 0;
            int var11 = var9 == EnumDirection.WEST ? 0 : 15;
            int var12 = var9 == EnumDirection.SOUTH ? 15 : 0;
            int var13 = var9 == EnumDirection.NORTH ? 0 : 15;
            for (int var14 = var10; var14 <= var11; ++var14) {
                for (int var15 = var12; var15 <= var13; ++var15) {
                    int var16 = Math.min(var7, var1.getHeight(HeightMap.Type.MOTION_BLOCKING, var14, var15)) + 1;
                    for (int var17 = var6; var17 < var16; ++var17) {
                        Blender.generateBorderTick(var1, var4.setWithOffset(var5, var14, var17, var15));
                    }
                }
            }
        }
    }

    private static void generateBorderTick(IChunkAccess var0, BlockPosition var1) {
        Fluid var3;
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(TagsBlock.LEAVES)) {
            var0.markPosForPostprocessing(var1);
        }
        if (!(var3 = var0.getFluidState(var1)).isEmpty()) {
            var0.markPosForPostprocessing(var1);
        }
    }

    public static void addAroundOldChunksCarvingMaskFilter(GeneratorAccessSeed var0, ProtoChunk var12) {
        ChunkCoordIntPair var22 = var12.getPos();
        b var32 = Blender.makeOldChunkDistanceGetter(var12.isOldNoiseGeneration(), BlendingData.sideByGenerationAge(var0, var22.x, var22.z, true));
        if (var32 == null) {
            return;
        }
        CarvingMask.a var4 = (var1, var2, var3) -> {
            double var8;
            double var6;
            double var4 = (double)var1 + 0.5 + SHIFT_NOISE.getValue(var1, var2, var3) * 4.0;
            return var32.getDistance(var4, var6 = (double)var2 + 0.5 + SHIFT_NOISE.getValue(var2, var3, var1) * 4.0, var8 = (double)var3 + 0.5 + SHIFT_NOISE.getValue(var3, var1, var2) * 4.0) < 4.0;
        };
        Stream.of(WorldGenStage.Features.values()).map(var12::getOrCreateCarvingMask).forEach(var1 -> var1.setAdditionalMask(var4));
    }

    @Nullable
    public static b makeOldChunkDistanceGetter(boolean var0, Set<EnumDirection8> var12) {
        if (!var0 && var12.isEmpty()) {
            return null;
        }
        ArrayList var2 = Lists.newArrayList();
        if (var0) {
            var2.add(Blender.makeOffsetOldChunkDistanceGetter(null));
        }
        var12.forEach(var1 -> var2.add(Blender.makeOffsetOldChunkDistanceGetter(var1)));
        return (var1, var3, var5) -> {
            double var7 = Double.POSITIVE_INFINITY;
            for (b var10 : var2) {
                double var11 = var10.getDistance(var1, var3, var5);
                if (!(var11 < var7)) continue;
                var7 = var11;
            }
            return var7;
        };
    }

    private static b makeOffsetOldChunkDistanceGetter(@Nullable EnumDirection8 var0) {
        double var1 = 0.0;
        double var3 = 0.0;
        if (var0 != null) {
            for (EnumDirection var62 : var0.getDirections()) {
                var1 += (double)(var62.getStepX() * 16);
                var3 += (double)(var62.getStepZ() * 16);
            }
        }
        double var5 = var1;
        double var7 = var3;
        return (var4, var6, var8) -> Blender.distanceToCube(var4 - 8.0 - var5, var6 - OLD_CHUNK_CENTER_Y, var8 - 8.0 - var7, 8.0, OLD_CHUNK_Y_RADIUS, 8.0);
    }

    private static double distanceToCube(double var0, double var2, double var4, double var6, double var8, double var10) {
        double var12 = Math.abs(var0) - var6;
        double var14 = Math.abs(var2) - var8;
        double var16 = Math.abs(var4) - var10;
        return MathHelper.length(Math.max(0.0, var12), Math.max(0.0, var14), Math.max(0.0, var16));
    }

    static final class c
    extends Record {
        final int chunkX;
        final int chunkZ;
        final BlendingData blendingData;

        c(int var0, int var1, BlendingData var2) {
            this.chunkX = var0;
            this.chunkZ = var1;
            this.blendingData = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "chunkX", "chunkZ", "blendingData"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "chunkX", "chunkZ", "blendingData"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "chunkX", "chunkZ", "blendingData"}, this, var0);
        }

        public int chunkX() {
            return this.chunkX;
        }

        public int chunkZ() {
            return this.chunkZ;
        }

        public BlendingData blendingData() {
            return this.blendingData;
        }
    }

    static interface a {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public static interface b {
        public double getDistance(double var1, double var3, double var5);
    }
}

