/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;

public record NoiseSettings(int minY, int height, NoiseSamplingSettings noiseSamplingSettings, NoiseSlider topSlideSettings, NoiseSlider bottomSlideSettings, int noiseSizeHorizontal, int noiseSizeVertical, boolean islandNoiseOverride, boolean isAmplified, boolean largeBiomes, TerrainShaper terrainShaper) {
    public static final Codec<NoiseSettings> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("min_y").forGetter(NoiseSettings::minY), (App)Codec.intRange((int)0, (int)DimensionManager.Y_SIZE).fieldOf("height").forGetter(NoiseSettings::height), (App)NoiseSamplingSettings.CODEC.fieldOf("sampling").forGetter(NoiseSettings::noiseSamplingSettings), (App)NoiseSlider.CODEC.fieldOf("top_slide").forGetter(NoiseSettings::topSlideSettings), (App)NoiseSlider.CODEC.fieldOf("bottom_slide").forGetter(NoiseSettings::bottomSlideSettings), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::noiseSizeHorizontal), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::noiseSizeVertical), (App)Codec.BOOL.optionalFieldOf("island_noise_override", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::islandNoiseOverride), (App)Codec.BOOL.optionalFieldOf("amplified", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::isAmplified), (App)Codec.BOOL.optionalFieldOf("large_biomes", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::largeBiomes), (App)TerrainShaper.CODEC.fieldOf("terrain_shaper").forGetter(NoiseSettings::terrainShaper)).apply((Applicative)var0, NoiseSettings::new)).comapFlatMap(NoiseSettings::guardY, Function.identity());

    private static DataResult<NoiseSettings> guardY(NoiseSettings var0) {
        if (var0.minY() + var0.height() > DimensionManager.MAX_Y + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (DimensionManager.MAX_Y + 1)));
        }
        if (var0.height() % 16 != 0) {
            return DataResult.error((String)"height has to be a multiple of 16");
        }
        if (var0.minY() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)var0);
    }

    public static NoiseSettings create(int var02, int var1, NoiseSamplingSettings var2, NoiseSlider var3, NoiseSlider var4, int var5, int var6, boolean var7, boolean var8, boolean var9, TerrainShaper var10) {
        NoiseSettings var11 = new NoiseSettings(var02, var1, var2, var3, var4, var5, var6, var7, var8, var9, var10);
        NoiseSettings.guardY(var11).error().ifPresent(var0 -> {
            throw new IllegalStateException(var0.message());
        });
        return var11;
    }

    public int getCellHeight() {
        return QuartPos.toBlock(this.noiseSizeVertical());
    }

    public int getCellWidth() {
        return QuartPos.toBlock(this.noiseSizeHorizontal());
    }

    public int getCellCountY() {
        return this.height() / this.getCellHeight();
    }

    public int getMinCellY() {
        return MathHelper.intFloorDiv(this.minY(), this.getCellHeight());
    }
}

