/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final Codec<ChunkProviderFlat> CODEC = GeneratorSettingsFlat.CODEC.fieldOf("settings").xmap(ChunkProviderFlat::new, ChunkProviderFlat::settings).codec();
    private final GeneratorSettingsFlat settings;

    public ChunkProviderFlat(GeneratorSettingsFlat var0) {
        super(new WorldChunkManagerHell(var0.getBiomeFromSettings()), new WorldChunkManagerHell(var0.getBiome()), var0.structureSettings(), 0L);
        this.settings = var0;
    }

    @Override
    protected Codec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public ChunkGenerator withSeed(long var0) {
        return this;
    }

    public GeneratorSettingsFlat settings() {
        return this.settings;
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, IChunkAccess var2) {
    }

    @Override
    public int getSpawnHeight(LevelHeightAccessor var0) {
        return var0.getMinBuildHeight() + Math.min(var0.getHeight(), this.settings.getLayers().size());
    }

    @Override
    protected boolean validBiome(IRegistry<BiomeBase> var0, Predicate<ResourceKey<BiomeBase>> var1, BiomeBase var2) {
        return var0.getResourceKey(this.settings.getBiome()).filter(var1).isPresent();
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Executor var0, Blender var1, StructureManager var2, IChunkAccess var3) {
        List<IBlockData> var4 = this.settings.getLayers();
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        HeightMap var6 = var3.getOrCreateHeightmapUnprimed(HeightMap.Type.OCEAN_FLOOR_WG);
        HeightMap var7 = var3.getOrCreateHeightmapUnprimed(HeightMap.Type.WORLD_SURFACE_WG);
        for (int var8 = 0; var8 < Math.min(var3.getHeight(), var4.size()); ++var8) {
            IBlockData var9 = var4.get(var8);
            if (var9 == null) continue;
            int var10 = var3.getMinBuildHeight() + var8;
            for (int var11 = 0; var11 < 16; ++var11) {
                for (int var12 = 0; var12 < 16; ++var12) {
                    var3.setBlockState(var5.set(var11, var10, var12), var9, false);
                    var6.update(var11, var10, var12, var9);
                    var7.update(var11, var10, var12, var9);
                }
            }
        }
        return CompletableFuture.completedFuture(var3);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        List<IBlockData> var4 = this.settings.getLayers();
        for (int var5 = Math.min(var4.size(), var3.getMaxBuildHeight()) - 1; var5 >= 0; --var5) {
            IBlockData var6 = var4.get(var5);
            if (var6 == null || !var2.isOpaque().test(var6)) continue;
            return var3.getMinBuildHeight() + var5 + 1;
        }
        return var3.getMinBuildHeight();
    }

    @Override
    public BlockColumn getBaseColumn(int var02, int var1, LevelHeightAccessor var2) {
        return new BlockColumn(var2.getMinBuildHeight(), (IBlockData[])this.settings.getLayers().stream().limit(var2.getHeight()).map(var0 -> var0 == null ? Blocks.AIR.defaultBlockState() : var0).toArray(IBlockData[]::new));
    }

    @Override
    public Climate.Sampler climateSampler() {
        return (var0, var1, var2) -> Climate.target(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var0, long var1, BiomeManager var3, StructureManager var4, IChunkAccess var5, WorldGenStage.Features var6) {
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return -63;
    }
}

