/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.world.level.levelgen.RandomSource;

public interface BitRandomSource
extends RandomSource {
    public static final float FLOAT_MULTIPLIER = 5.9604645E-8f;
    public static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;

    public int next(int var1);

    @Override
    default public int nextInt() {
        return this.next(32);
    }

    @Override
    default public int nextInt(int var0) {
        int var2;
        int var1;
        if (var0 <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        if ((var0 & var0 - 1) == 0) {
            return (int)((long)var0 * (long)this.next(31) >> 31);
        }
        while ((var1 = this.next(31)) - (var2 = var1 % var0) + (var0 - 1) < 0) {
        }
        return var2;
    }

    @Override
    default public long nextLong() {
        int var0 = this.next(32);
        int var1 = this.next(32);
        long var2 = (long)var0 << 32;
        return var2 + (long)var1;
    }

    @Override
    default public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    default public float nextFloat() {
        return (float)this.next(24) * 5.9604645E-8f;
    }

    @Override
    default public double nextDouble() {
        int var0 = this.next(26);
        int var1 = this.next(27);
        long var2 = ((long)var0 << 27) + (long)var1;
        return (double)var2 * (double)1.110223E-16f;
    }
}

