/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;

public final class WorldDimension {
    public static final Codec<WorldDimension> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)DimensionManager.CODEC.fieldOf("type").flatXmap(ExtraCodecs.nonNullSupplierCheck(), ExtraCodecs.nonNullSupplierCheck()).forGetter(WorldDimension::typeSupplier), (App)ChunkGenerator.CODEC.fieldOf("generator").forGetter(WorldDimension::generator)).apply((Applicative)var0, var0.stable(WorldDimension::new)));
    public static final ResourceKey<WorldDimension> OVERWORLD = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("overworld"));
    public static final ResourceKey<WorldDimension> NETHER = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_nether"));
    public static final ResourceKey<WorldDimension> END = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_end"));
    private static final Set<ResourceKey<WorldDimension>> BUILTIN_ORDER = Sets.newLinkedHashSet((Iterable)ImmutableList.of(OVERWORLD, NETHER, END));
    private final Supplier<DimensionManager> type;
    private final ChunkGenerator generator;

    public WorldDimension(Supplier<DimensionManager> var0, ChunkGenerator var1) {
        this.type = var0;
        this.generator = var1;
    }

    public Supplier<DimensionManager> typeSupplier() {
        return this.type;
    }

    public DimensionManager type() {
        return this.type.get();
    }

    public ChunkGenerator generator() {
        return this.generator;
    }

    public static RegistryMaterials<WorldDimension> sortMap(RegistryMaterials<WorldDimension> var0) {
        Object var4;
        RegistryMaterials<WorldDimension> var1 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental());
        for (ResourceKey<WorldDimension> resourceKey : BUILTIN_ORDER) {
            var4 = var0.get(resourceKey);
            if (var4 == null) continue;
            var1.register(resourceKey, var4, var0.lifecycle((WorldDimension)var4));
        }
        for (Map.Entry entry : var0.entrySet()) {
            var4 = (ResourceKey)entry.getKey();
            if (BUILTIN_ORDER.contains(var4)) continue;
            var1.register((ResourceKey<WorldDimension>)var4, (WorldDimension)entry.getValue(), var0.lifecycle((WorldDimension)entry.getValue()));
        }
        return var1;
    }

    public static boolean stable(long var0, RegistryMaterials<WorldDimension> var2) {
        ArrayList var3 = Lists.newArrayList(var2.entrySet());
        if (var3.size() != BUILTIN_ORDER.size()) {
            return false;
        }
        Map.Entry var4 = (Map.Entry)var3.get(0);
        Map.Entry var5 = (Map.Entry)var3.get(1);
        Map.Entry var6 = (Map.Entry)var3.get(2);
        if (var4.getKey() != OVERWORLD || var5.getKey() != NETHER || var6.getKey() != END) {
            return false;
        }
        if (!((WorldDimension)var4.getValue()).type().equalTo(DimensionManager.DEFAULT_OVERWORLD) && ((WorldDimension)var4.getValue()).type() != DimensionManager.DEFAULT_OVERWORLD_CAVES) {
            return false;
        }
        if (!((WorldDimension)var5.getValue()).type().equalTo(DimensionManager.DEFAULT_NETHER)) {
            return false;
        }
        if (!((WorldDimension)var6.getValue()).type().equalTo(DimensionManager.DEFAULT_END)) {
            return false;
        }
        if (!(((WorldDimension)var5.getValue()).generator() instanceof ChunkGeneratorAbstract) || !(((WorldDimension)var6.getValue()).generator() instanceof ChunkGeneratorAbstract)) {
            return false;
        }
        ChunkGeneratorAbstract var7 = (ChunkGeneratorAbstract)((WorldDimension)var5.getValue()).generator();
        ChunkGeneratorAbstract var8 = (ChunkGeneratorAbstract)((WorldDimension)var6.getValue()).generator();
        if (!var7.stable(var0, GeneratorSettingBase.NETHER)) {
            return false;
        }
        if (!var8.stable(var0, GeneratorSettingBase.END)) {
            return false;
        }
        if (!(var7.getBiomeSource() instanceof WorldChunkManagerMultiNoise)) {
            return false;
        }
        WorldChunkManagerMultiNoise var9 = (WorldChunkManagerMultiNoise)var7.getBiomeSource();
        if (!var9.stable(WorldChunkManagerMultiNoise.a.NETHER)) {
            return false;
        }
        WorldChunkManager var10 = ((WorldDimension)var4.getValue()).generator().getBiomeSource();
        if (var10 instanceof WorldChunkManagerMultiNoise && !((WorldChunkManagerMultiNoise)var10).stable(WorldChunkManagerMultiNoise.a.OVERWORLD)) {
            return false;
        }
        if (!(var8.getBiomeSource() instanceof WorldChunkManagerTheEnd)) {
            return false;
        }
        WorldChunkManagerTheEnd var11 = (WorldChunkManagerTheEnd)var8.getBiomeSource();
        return var11.stable(var0);
    }
}

