/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityBeehive
extends TileEntity {
    public static final String TAG_FLOWER_POS = "FlowerPos";
    public static final String MIN_OCCUPATION_TICKS = "MinOccupationTicks";
    public static final String ENTITY_DATA = "EntityData";
    public static final String TICKS_IN_HIVE = "TicksInHive";
    public static final String HAS_NECTAR = "HasNectar";
    public static final String BEES = "Bees";
    private static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "HivePos", "Passengers", "Leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private final List<HiveBee> stored = Lists.newArrayList();
    @Nullable
    public BlockPosition savedFlowerPos;

    public TileEntityBeehive(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BEEHIVE, var0, var1);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), ReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        if (this.level == null) {
            return false;
        }
        for (BlockPosition var1 : BlockPosition.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1))) {
            if (!(this.level.getBlockState(var1).getBlock() instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 3;
    }

    public void emptyAllLivingFromHive(@Nullable EntityHuman var0, IBlockData var1, ReleaseStatus var2) {
        List<Entity> var3 = this.releaseAllOccupants(var1, var2);
        if (var0 != null) {
            for (Entity var5 : var3) {
                if (!(var5 instanceof EntityBee)) continue;
                EntityBee var6 = (EntityBee)var5;
                if (!(var0.position().distanceToSqr(var5.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    var6.setTarget(var0);
                    continue;
                }
                var6.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(IBlockData var0, ReleaseStatus var1) {
        ArrayList var2 = Lists.newArrayList();
        this.stored.removeIf(var3 -> TileEntityBeehive.releaseOccupant(this.level, this.worldPosition, var0, var3, var2, var1, this.savedFlowerPos));
        return var2;
    }

    public void addOccupant(Entity var0, boolean var1) {
        this.addOccupantWithPresetTicks(var0, var1, 0);
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(IBlockData var0) {
        return var0.getValue(BlockBeehive.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return BlockCampfire.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupantWithPresetTicks(Entity var0, boolean var1, int var2) {
        if (this.stored.size() >= 3) {
            return;
        }
        var0.stopRiding();
        var0.ejectPassengers();
        NBTTagCompound var3 = new NBTTagCompound();
        var0.save(var3);
        this.storeBee(var3, var2, var1);
        if (this.level != null) {
            Object var4;
            if (var0 instanceof EntityBee && ((EntityBee)(var4 = (EntityBee)var0)).hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                this.savedFlowerPos = ((EntityBee)var4).getSavedFlowerPos();
            }
            var4 = this.getBlockPos();
            this.level.playSound(null, ((BaseBlockPosition)var4).getX(), ((BaseBlockPosition)var4).getY(), ((BaseBlockPosition)var4).getZ(), SoundEffects.BEEHIVE_ENTER, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        var0.discard();
    }

    public void storeBee(NBTTagCompound var0, int var1, boolean var2) {
        this.stored.add(new HiveBee(var0, var1, var2 ? 2400 : 600));
    }

    private static boolean releaseOccupant(World var02, BlockPosition var1, IBlockData var2, HiveBee var3, @Nullable List<Entity> var4, ReleaseStatus var5, @Nullable BlockPosition var6) {
        boolean var10;
        if ((var02.isNight() || var02.isRaining()) && var5 != ReleaseStatus.EMERGENCY) {
            return false;
        }
        NBTTagCompound var7 = var3.entityData;
        TileEntityBeehive.removeIgnoredBeeTags(var7);
        var7.put("HivePos", GameProfileSerializer.writeBlockPos(var1));
        var7.putBoolean("NoGravity", true);
        EnumDirection var8 = var2.getValue(BlockBeehive.FACING);
        BlockPosition var9 = var1.relative(var8);
        boolean bl = var10 = !var02.getBlockState(var9).getCollisionShape(var02, var9).isEmpty();
        if (var10 && var5 != ReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity var11 = EntityTypes.loadEntityRecursive(var7, var02, var0 -> var0);
        if (var11 != null) {
            if (!var11.getType().is(TagsEntity.BEEHIVE_INHABITORS)) {
                return false;
            }
            if (var11 instanceof EntityBee) {
                EntityBee var12 = (EntityBee)var11;
                if (var6 != null && !var12.hasSavedFlowerPos() && var02.random.nextFloat() < 0.9f) {
                    var12.setSavedFlowerPos(var6);
                }
                if (var5 == ReleaseStatus.HONEY_DELIVERED) {
                    int var13;
                    var12.dropOffNectar();
                    if (var2.is(TagsBlock.BEEHIVES) && (var13 = TileEntityBeehive.getHoneyLevel(var2)) < 5) {
                        int var14;
                        int n2 = var14 = var02.random.nextInt(100) == 0 ? 2 : 1;
                        if (var13 + var14 > 5) {
                            --var14;
                        }
                        var02.setBlockAndUpdate(var1, (IBlockData)var2.setValue(BlockBeehive.HONEY_LEVEL, var13 + var14));
                    }
                }
                TileEntityBeehive.setBeeReleaseData(var3.ticksInHive, var12);
                if (var4 != null) {
                    var4.add(var12);
                }
                float var13 = var11.getBbWidth();
                double var14 = var10 ? 0.0 : 0.55 + (double)(var13 / 2.0f);
                double var16 = (double)var1.getX() + 0.5 + var14 * (double)var8.getStepX();
                double var18 = (double)var1.getY() + 0.5 - (double)(var11.getBbHeight() / 2.0f);
                double var20 = (double)var1.getZ() + 0.5 + var14 * (double)var8.getStepZ();
                var11.moveTo(var16, var18, var20, var11.getYRot(), var11.getXRot());
            }
            var02.playSound(null, var1, SoundEffects.BEEHIVE_EXIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return var02.addFreshEntity(var11);
        }
        return false;
    }

    static void removeIgnoredBeeTags(NBTTagCompound var0) {
        for (String var2 : IGNORED_BEE_TAGS) {
            var0.remove(var2);
        }
    }

    private static void setBeeReleaseData(int var0, EntityBee var1) {
        int var2 = var1.getAge();
        if (var2 < 0) {
            var1.setAge(Math.min(0, var2 + var0));
        } else if (var2 > 0) {
            var1.setAge(Math.max(0, var2 - var0));
        }
        var1.setInLoveTime(Math.max(0, var1.getInLoveTime() - var0));
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(World var0, BlockPosition var1, IBlockData var2, List<HiveBee> var3, @Nullable BlockPosition var4) {
        Iterator<HiveBee> var5 = var3.iterator();
        while (var5.hasNext()) {
            HiveBee var6 = var5.next();
            if (var6.ticksInHive > var6.minOccupationTicks) {
                ReleaseStatus var7;
                ReleaseStatus releaseStatus = var7 = var6.entityData.getBoolean(HAS_NECTAR) ? ReleaseStatus.HONEY_DELIVERED : ReleaseStatus.BEE_RELEASED;
                if (TileEntityBeehive.releaseOccupant(var0, var1, var2, var6, null, var7, var4)) {
                    var5.remove();
                }
            }
            ++var6.ticksInHive;
        }
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityBeehive var3) {
        TileEntityBeehive.tickOccupants(var0, var1, var2, var3.stored, var3.savedFlowerPos);
        if (!var3.stored.isEmpty() && var0.getRandom().nextDouble() < 0.005) {
            double var4 = (double)var1.getX() + 0.5;
            double var6 = var1.getY();
            double var8 = (double)var1.getZ() + 0.5;
            var0.playSound(null, var4, var6, var8, SoundEffects.BEEHIVE_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        PacketDebug.sendHiveInfo(var0, var1, var2, var3);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.stored.clear();
        NBTTagList var1 = var0.getList(BEES, 10);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            NBTTagCompound var3 = var1.getCompound(var2);
            HiveBee var4 = new HiveBee(var3.getCompound(ENTITY_DATA), var3.getInt(TICKS_IN_HIVE), var3.getInt(MIN_OCCUPATION_TICKS));
            this.stored.add(var4);
        }
        this.savedFlowerPos = null;
        if (var0.contains(TAG_FLOWER_POS)) {
            this.savedFlowerPos = GameProfileSerializer.readBlockPos(var0.getCompound(TAG_FLOWER_POS));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.put(BEES, this.writeBees());
        if (this.hasSavedFlowerPos()) {
            var0.put(TAG_FLOWER_POS, GameProfileSerializer.writeBlockPos(this.savedFlowerPos));
        }
    }

    public NBTTagList writeBees() {
        NBTTagList var0 = new NBTTagList();
        for (HiveBee var2 : this.stored) {
            var2.entityData.remove("UUID");
            NBTTagCompound var3 = new NBTTagCompound();
            var3.put(ENTITY_DATA, var2.entityData);
            var3.putInt(TICKS_IN_HIVE, var2.ticksInHive);
            var3.putInt(MIN_OCCUPATION_TICKS, var2.minOccupationTicks);
            var0.add(var3);
        }
        return var0;
    }

    public static final class ReleaseStatus
    extends Enum<ReleaseStatus> {
        public static final /* enum */ ReleaseStatus HONEY_DELIVERED = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus BEE_RELEASED = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus EMERGENCY = new ReleaseStatus();
        private static final /* synthetic */ ReleaseStatus[] d;

        public static ReleaseStatus[] values() {
            return (ReleaseStatus[])d.clone();
        }

        public static ReleaseStatus valueOf(String var0) {
            return Enum.valueOf(ReleaseStatus.class, var0);
        }

        private static /* synthetic */ ReleaseStatus[] a() {
            return new ReleaseStatus[]{HONEY_DELIVERED, BEE_RELEASED, EMERGENCY};
        }

        static {
            d = ReleaseStatus.a();
        }
    }

    static class HiveBee {
        final NBTTagCompound entityData;
        int ticksInHive;
        final int minOccupationTicks;

        HiveBee(NBTTagCompound var0, int var1, int var2) {
            TileEntityBeehive.removeIgnoredBeeTags(var0);
            this.entityData = var0;
            this.ticksInHive = var1;
            this.minOccupationTicks = var2;
        }
    }
}

