/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityBanner
extends TileEntity
implements INamableTileEntity {
    public static final int MAX_PATTERNS = 6;
    public static final String TAG_PATTERNS = "Patterns";
    public static final String TAG_PATTERN = "Pattern";
    public static final String TAG_COLOR = "Color";
    @Nullable
    private IChatBaseComponent name;
    public EnumColor baseColor;
    @Nullable
    public NBTTagList itemPatterns;
    @Nullable
    private List<Pair<EnumBannerPatternType, EnumColor>> patterns;

    public TileEntityBanner(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BANNER, var0, var1);
        this.baseColor = ((BlockBannerAbstract)var1.getBlock()).getColor();
    }

    public TileEntityBanner(BlockPosition var0, IBlockData var1, EnumColor var2) {
        this(var0, var1);
        this.baseColor = var2;
    }

    @Nullable
    public static NBTTagList getItemPatterns(ItemStack var0) {
        NBTTagList var1 = null;
        NBTTagCompound var2 = ItemBlock.getBlockEntityData(var0);
        if (var2 != null && var2.contains(TAG_PATTERNS, 9)) {
            var1 = var2.getList(TAG_PATTERNS, 10).copy();
        }
        return var1;
    }

    public void fromItem(ItemStack var0, EnumColor var1) {
        this.baseColor = var1;
        this.fromItem(var0);
    }

    public void fromItem(ItemStack var0) {
        this.itemPatterns = TileEntityBanner.getItemPatterns(var0);
        this.patterns = null;
        this.name = var0.hasCustomHoverName() ? var0.getHoverName() : null;
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return new ChatMessage("block.minecraft.banner");
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    public void setCustomName(IChatBaseComponent var0) {
        this.name = var0;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (this.itemPatterns != null) {
            var0.put(TAG_PATTERNS, this.itemPatterns);
        }
        if (this.name != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name));
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        if (var0.contains("CustomName", 8)) {
            this.name = IChatBaseComponent.ChatSerializer.fromJson(var0.getString("CustomName"));
        }
        this.itemPatterns = var0.getList(TAG_PATTERNS, 10);
        this.patterns = null;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public static int getPatternCount(ItemStack var0) {
        NBTTagCompound var1 = ItemBlock.getBlockEntityData(var0);
        if (var1 != null && var1.contains(TAG_PATTERNS)) {
            return var1.getList(TAG_PATTERNS, 10).size();
        }
        return 0;
    }

    public List<Pair<EnumBannerPatternType, EnumColor>> getPatterns() {
        if (this.patterns == null) {
            this.patterns = TileEntityBanner.createPatterns(this.baseColor, this.itemPatterns);
        }
        return this.patterns;
    }

    public static List<Pair<EnumBannerPatternType, EnumColor>> createPatterns(EnumColor var0, @Nullable NBTTagList var1) {
        ArrayList var2 = Lists.newArrayList();
        var2.add(Pair.of((Object)((Object)EnumBannerPatternType.BASE), (Object)var0));
        if (var1 != null) {
            for (int var3 = 0; var3 < var1.size(); ++var3) {
                NBTTagCompound var4 = var1.getCompound(var3);
                EnumBannerPatternType var5 = EnumBannerPatternType.byHash(var4.getString(TAG_PATTERN));
                if (var5 == null) continue;
                int var6 = var4.getInt(TAG_COLOR);
                var2.add(Pair.of((Object)((Object)var5), (Object)EnumColor.byId(var6)));
            }
        }
        return var2;
    }

    public static void removeLastPattern(ItemStack var0) {
        NBTTagCompound var1 = ItemBlock.getBlockEntityData(var0);
        if (var1 == null || !var1.contains(TAG_PATTERNS, 9)) {
            return;
        }
        NBTTagList var2 = var1.getList(TAG_PATTERNS, 10);
        if (var2.isEmpty()) {
            return;
        }
        var2.remove(var2.size() - 1);
        if (var2.isEmpty()) {
            var1.remove(TAG_PATTERNS);
        }
        ItemBlock.setBlockEntityData(var0, TileEntityTypes.BANNER, var1);
    }

    public ItemStack getItem() {
        ItemStack var0 = new ItemStack(BlockBanner.byColor(this.baseColor));
        if (this.itemPatterns != null && !this.itemPatterns.isEmpty()) {
            NBTTagCompound var1 = new NBTTagCompound();
            var1.put(TAG_PATTERNS, this.itemPatterns.copy());
            ItemBlock.setBlockEntityData(var0, this.getType(), var1);
        }
        if (this.name != null) {
            var0.setHoverName(this.name);
        }
        return var0;
    }

    public EnumColor getBaseColor() {
        return this.baseColor;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

