/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;

public class SculkSensorBlockEntity
extends TileEntity
implements VibrationListener.a {
    private final VibrationListener listener;
    public int lastVibrationFrequency;

    public SculkSensorBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_SENSOR, var0, var1);
        this.listener = new VibrationListener(new BlockPositionSource(this.worldPosition), ((SculkSensorBlock)var1.getBlock()).getListenerRange(), this);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.lastVibrationFrequency = var0.getInt("last_vibration_frequency");
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putInt("last_vibration_frequency", this.lastVibrationFrequency);
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    @Override
    public boolean shouldListen(World var0, GameEventListener var1, BlockPosition var2, GameEvent var3, @Nullable Entity var4) {
        boolean var5 = var3 == GameEvent.BLOCK_DESTROY && var2.equals(this.getBlockPos());
        boolean var6 = var3 == GameEvent.BLOCK_PLACE && var2.equals(this.getBlockPos());
        return !var5 && !var6 && SculkSensorBlock.canActivate(this.getBlockState());
    }

    @Override
    public void onSignalReceive(World var0, GameEventListener var1, GameEvent var2, int var3) {
        IBlockData var4 = this.getBlockState();
        if (!var0.isClientSide() && SculkSensorBlock.canActivate(var4)) {
            this.lastVibrationFrequency = SculkSensorBlock.VIBRATION_STRENGTH_FOR_EVENT.getInt((Object)var2);
            SculkSensorBlock.activate(var0, this.worldPosition, var4, SculkSensorBlockEntity.getRedstoneStrengthForDistance(var3, var1.getListenerRadius()));
        }
    }

    public static int getRedstoneStrengthForDistance(int var0, int var1) {
        double var2 = (double)var0 / (double)var1;
        return Math.max(1, 15 - MathHelper.floor(var2 * 15.0));
    }
}

