/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class SporeBlossomBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box(2.0, 13.0, 2.0, 14.0, 16.0, 14.0);
    private static final int ADD_PARTICLE_ATTEMPTS = 14;
    private static final int PARTICLE_XZ_RADIUS = 10;
    private static final int PARTICLE_Y_MAX = 10;

    public SporeBlossomBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return Block.canSupportCenter(var1, var2.above(), EnumDirection.DOWN) && !var1.isWaterAt(var2);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && !this.canSurvive(var0, var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        int var4 = var2.getX();
        int var5 = var2.getY();
        int var6 = var2.getZ();
        double var7 = (double)var4 + var3.nextDouble();
        double var9 = (double)var5 + 0.7;
        double var11 = (double)var6 + var3.nextDouble();
        var1.addParticle(Particles.FALLING_SPORE_BLOSSOM, var7, var9, var11, 0.0, 0.0, 0.0);
        BlockPosition.MutableBlockPosition var13 = new BlockPosition.MutableBlockPosition();
        for (int var14 = 0; var14 < 14; ++var14) {
            var13.set(var4 + MathHelper.nextInt(var3, -10, 10), var5 - var3.nextInt(10), var6 + MathHelper.nextInt(var3, -10, 10));
            IBlockData var15 = var1.getBlockState(var13);
            if (var15.isCollisionShapeFullBlock(var1, var13)) continue;
            var1.addParticle(Particles.SPORE_BLOSSOM_AIR, (double)var13.getX() + var3.nextDouble(), (double)var13.getY() + var3.nextDouble(), (double)var13.getZ() + var3.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }
}

