/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MultifaceBlock
extends Block {
    private static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION;
    private static final Map<EnumDirection, VoxelShape> SHAPE_BY_DIRECTION = SystemUtils.make(Maps.newEnumMap(EnumDirection.class), var0 -> {
        var0.put(EnumDirection.NORTH, NORTH_AABB);
        var0.put(EnumDirection.EAST, EAST_AABB);
        var0.put(EnumDirection.SOUTH, SOUTH_AABB);
        var0.put(EnumDirection.WEST, WEST_AABB);
        var0.put(EnumDirection.UP, UP_AABB);
        var0.put(EnumDirection.DOWN, DOWN_AABB);
    });
    protected static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private final ImmutableMap<IBlockData, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapesCache = this.getShapeForEachState(MultifaceBlock::calculateMultifaceShape);
        this.canRotate = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(EnumDirection.EnumAxis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(EnumDirection.EnumAxis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    protected boolean isFaceSupported(EnumDirection var0) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        for (EnumDirection var4 : DIRECTIONS) {
            if (!this.isFaceSupported(var4)) continue;
            var0.add(MultifaceBlock.getFaceProperty(var4));
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!MultifaceBlock.hasAnyFace(var0)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!MultifaceBlock.hasFace(var0, var1) || MultifaceBlock.canAttachTo(var3, var1, var5, var2)) {
            return var0;
        }
        return MultifaceBlock.removeFace(var0, MultifaceBlock.getFaceProperty(var1));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return (VoxelShape)this.shapesCache.get((Object)var0);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        boolean var3 = false;
        for (EnumDirection var7 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var7)) continue;
            BlockPosition var8 = var2.relative(var7);
            if (!MultifaceBlock.canAttachTo(var1, var7, var8, var1.getBlockState(var8))) {
                return false;
            }
            var3 = true;
        }
        return var3;
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return MultifaceBlock.hasAnyVacantFace(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var32 = var1.getBlockState(var2);
        return Arrays.stream(var0.getNearestLookingDirections()).map(var3 -> this.getStateForPlacement(var32, var1, var2, (EnumDirection)var3)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public IBlockData getStateForPlacement(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        IBlockData var4;
        if (!this.isFaceSupported(var3)) {
            return null;
        }
        if (var0.is(this)) {
            if (MultifaceBlock.hasFace(var0, var3)) {
                return null;
            }
            var4 = var0;
        } else {
            var4 = this.isWaterloggable() && var0.getFluidState().isSourceOfType(FluidTypes.WATER) ? (IBlockData)this.defaultBlockState().setValue(BlockProperties.WATERLOGGED, true) : this.defaultBlockState();
        }
        BlockPosition var5 = var2.relative(var3);
        if (MultifaceBlock.canAttachTo(var1, var3, var5, var1.getBlockState(var5))) {
            return (IBlockData)var4.setValue(MultifaceBlock.getFaceProperty(var3), true);
        }
        return null;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        if (!this.canRotate) {
            return var0;
        }
        return this.mapDirections(var0, var1::rotate);
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        if (var1 == EnumBlockMirror.FRONT_BACK && !this.canMirrorX) {
            return var0;
        }
        if (var1 == EnumBlockMirror.LEFT_RIGHT && !this.canMirrorZ) {
            return var0;
        }
        return this.mapDirections(var0, var1::mirror);
    }

    private IBlockData mapDirections(IBlockData var0, Function<EnumDirection, EnumDirection> var1) {
        IBlockData var2 = var0;
        for (EnumDirection var6 : DIRECTIONS) {
            if (!this.isFaceSupported(var6)) continue;
            var2 = (IBlockData)var2.setValue(MultifaceBlock.getFaceProperty(var1.apply(var6)), var0.getValue(MultifaceBlock.getFaceProperty(var6)));
        }
        return var2;
    }

    public boolean spreadFromRandomFaceTowardRandomDirection(IBlockData var0, WorldServer var12, BlockPosition var2, Random var3) {
        ArrayList var42 = Lists.newArrayList((Object[])DIRECTIONS);
        Collections.shuffle(var42);
        return var42.stream().filter(var1 -> MultifaceBlock.hasFace(var0, var1)).anyMatch(var4 -> this.spreadFromFaceTowardRandomDirection(var0, var12, var2, (EnumDirection)var4, var3, false));
    }

    public boolean spreadFromFaceTowardRandomDirection(IBlockData var0, GeneratorAccess var1, BlockPosition var2, EnumDirection var3, Random var4, boolean var52) {
        List<EnumDirection> var6 = Arrays.asList(DIRECTIONS);
        Collections.shuffle(var6, var4);
        return var6.stream().anyMatch(var5 -> this.spreadFromFaceTowardDirection(var0, var1, var2, var3, (EnumDirection)var5, var52));
    }

    public boolean spreadFromFaceTowardDirection(IBlockData var0, GeneratorAccess var1, BlockPosition var2, EnumDirection var3, EnumDirection var4, boolean var5) {
        Optional<Pair<BlockPosition, EnumDirection>> var6 = this.getSpreadFromFaceTowardDirection(var0, var1, var2, var3, var4);
        if (var6.isPresent()) {
            Pair<BlockPosition, EnumDirection> var7 = var6.get();
            return this.spreadToFace(var1, (BlockPosition)var7.getFirst(), (EnumDirection)var7.getSecond(), var5);
        }
        return false;
    }

    protected boolean canSpread(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return Stream.of(DIRECTIONS).anyMatch(var4 -> this.getSpreadFromFaceTowardDirection(var0, var1, var2, var3, (EnumDirection)var4).isPresent());
    }

    private Optional<Pair<BlockPosition, EnumDirection>> getSpreadFromFaceTowardDirection(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3, EnumDirection var4) {
        EnumDirection var7;
        if (var4.getAxis() == var3.getAxis() || !MultifaceBlock.hasFace(var0, var3) || MultifaceBlock.hasFace(var0, var4)) {
            return Optional.empty();
        }
        if (this.canSpreadToFace(var1, var2, var4)) {
            return Optional.of(Pair.of((Object)var2, (Object)var4));
        }
        BlockPosition var5 = var2.relative(var4);
        if (this.canSpreadToFace(var1, var5, var3)) {
            return Optional.of(Pair.of((Object)var5, (Object)var3));
        }
        BlockPosition var6 = var5.relative(var3);
        if (this.canSpreadToFace(var1, var6, var7 = var4.getOpposite())) {
            return Optional.of(Pair.of((Object)var6, (Object)var7));
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        if (!this.canSpreadInto(var3)) {
            return false;
        }
        IBlockData var4 = this.getStateForPlacement(var3, var0, var1, var2);
        return var4 != null;
    }

    private boolean spreadToFace(GeneratorAccess var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        IBlockData var4 = var0.getBlockState(var1);
        IBlockData var5 = this.getStateForPlacement(var4, var0, var1, var2);
        if (var5 != null) {
            if (var3) {
                var0.getChunk(var1).markPosForPostprocessing(var1);
            }
            return var0.setBlock(var1, var5, 2);
        }
        return false;
    }

    private boolean canSpreadInto(IBlockData var0) {
        return var0.isAir() || var0.is(this) || var0.is(Blocks.WATER) && var0.getFluidState().isSource();
    }

    private static boolean hasFace(IBlockData var0, EnumDirection var1) {
        BlockStateBoolean var2 = MultifaceBlock.getFaceProperty(var1);
        return var0.hasProperty(var2) && var0.getValue(var2) != false;
    }

    private static boolean canAttachTo(IBlockAccess var0, EnumDirection var1, BlockPosition var2, IBlockData var3) {
        return Block.isFaceFull(var3.getCollisionShape(var0, var2), var1.getOpposite());
    }

    private boolean isWaterloggable() {
        return this.stateDefinition.getProperties().contains(BlockProperties.WATERLOGGED);
    }

    private static IBlockData removeFace(IBlockData var0, BlockStateBoolean var1) {
        IBlockData var2 = (IBlockData)var0.setValue(var1, false);
        if (MultifaceBlock.hasAnyFace(var2)) {
            return var2;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static BlockStateBoolean getFaceProperty(EnumDirection var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }

    private static IBlockData getDefaultMultifaceState(BlockStateList<Block, IBlockData> var0) {
        IBlockData var1 = var0.any();
        for (BlockStateBoolean var3 : PROPERTY_BY_DIRECTION.values()) {
            if (!var1.hasProperty(var3)) continue;
            var1 = (IBlockData)var1.setValue(var3, false);
        }
        return var1;
    }

    private static VoxelShape calculateMultifaceShape(IBlockData var0) {
        VoxelShape var1 = VoxelShapes.empty();
        for (EnumDirection var5 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var5)) continue;
            var1 = VoxelShapes.or(var1, SHAPE_BY_DIRECTION.get(var5));
        }
        return var1.isEmpty() ? VoxelShapes.block() : var1;
    }

    protected static boolean hasAnyFace(IBlockData var0) {
        return Arrays.stream(DIRECTIONS).anyMatch(var1 -> MultifaceBlock.hasFace(var0, var1));
    }

    private static boolean hasAnyVacantFace(IBlockData var0) {
        return Arrays.stream(DIRECTIONS).anyMatch(var1 -> !MultifaceBlock.hasFace(var0, var1));
    }
}

