/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateEnum<BlockPropertyHalf> HALF = BlockProperties.HALF;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final int AABB_THICKNESS = 3;
    protected static final VoxelShape EAST_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape TOP_AABB = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);

    protected BlockTrapdoor(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(OPEN, false)).setValue(HALF, BlockPropertyHalf.BOTTOM)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (!var0.getValue(OPEN).booleanValue()) {
            return var0.getValue(HALF) == BlockPropertyHalf.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        switch (var0.getValue(FACING)) {
            default: {
                return NORTH_OPEN_AABB;
            }
            case SOUTH: {
                return SOUTH_OPEN_AABB;
            }
            case WEST: {
                return WEST_OPEN_AABB;
            }
            case EAST: 
        }
        return EAST_OPEN_AABB;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        switch (var3) {
            case LAND: {
                return var0.getValue(OPEN);
            }
            case WATER: {
                return var0.getValue(WATERLOGGED);
            }
            case AIR: {
                return var0.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (this.material == Material.METAL) {
            return EnumInteractionResult.PASS;
        }
        var0 = (IBlockData)var0.cycle(OPEN);
        var1.setBlock(var2, var0, 2);
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var1.scheduleTick(var2, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        this.playSound(var3, var1, var2, var0.getValue(OPEN));
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    protected void playSound(@Nullable EntityHuman var0, World var1, BlockPosition var2, boolean var3) {
        if (var3) {
            int var4 = this.material == Material.METAL ? 1037 : 1007;
            var1.levelEvent(var0, var4, var2, 0);
        } else {
            int var4 = this.material == Material.METAL ? 1036 : 1013;
            var1.levelEvent(var0, var4, var2, 0);
        }
        var1.gameEvent((Entity)var0, var3 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.isClientSide) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var0.getValue(OPEN) != var6) {
                var0 = (IBlockData)var0.setValue(OPEN, var6);
                this.playSound(null, var1, var2, var6);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 2);
            if (var0.getValue(WATERLOGGED).booleanValue()) {
                var1.scheduleTick(var2, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
            }
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = this.defaultBlockState();
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        EnumDirection var3 = var0.getClickedFace();
        var1 = var0.replacingClickedOnBlock() || !var3.getAxis().isHorizontal() ? (IBlockData)((IBlockData)var1.setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(HALF, var3 == EnumDirection.UP ? BlockPropertyHalf.BOTTOM : BlockPropertyHalf.TOP) : (IBlockData)((IBlockData)var1.setValue(FACING, var3)).setValue(HALF, var0.getClickLocation().y - (double)var0.getClickedPos().getY() > 0.5 ? BlockPropertyHalf.TOP : BlockPropertyHalf.BOTTOM);
        if (var0.getLevel().hasNeighborSignal(var0.getClickedPos())) {
            var1 = (IBlockData)((IBlockData)var1.setValue(OPEN, true)).setValue(POWERED, true);
        }
        return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, OPEN, HALF, POWERED, WATERLOGGED);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }
}

