/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockSign
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final float AABB_OFFSET = 4.0f;
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private final BlockPropertyWood type;

    protected BlockSign(BlockBase.Info var0, BlockPropertyWood var1) {
        super(var0);
        this.type = var1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis() {
        return true;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySign(var0, var1);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        boolean var11;
        ItemStack var6 = var3.getItemInHand(var4);
        Item var7 = var6.getItem();
        boolean var8 = var7 instanceof ItemDye;
        boolean var9 = var6.is(Items.GLOW_INK_SAC);
        boolean var10 = var6.is(Items.INK_SAC);
        boolean bl = var11 = (var9 || var8 || var10) && var3.getAbilities().mayBuild;
        if (var1.isClientSide) {
            return var11 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.CONSUME;
        }
        TileEntity var12 = var1.getBlockEntity(var2);
        if (var12 instanceof TileEntitySign) {
            TileEntitySign var13 = (TileEntitySign)var12;
            boolean var14 = var13.hasGlowingText();
            if (var9 && var14 || var10 && !var14) {
                return EnumInteractionResult.PASS;
            }
            if (var11) {
                boolean var15;
                if (var9) {
                    var1.playSound(null, var2, SoundEffects.GLOW_INK_SAC_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var15 = var13.setHasGlowingText(true);
                    if (var3 instanceof EntityPlayer) {
                        CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var3, var2, var6);
                    }
                } else if (var10) {
                    var1.playSound(null, var2, SoundEffects.INK_SAC_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var15 = var13.setHasGlowingText(false);
                } else {
                    var1.playSound(null, var2, SoundEffects.DYE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var15 = var13.setColor(((ItemDye)var7).getDyeColor());
                }
                if (var15) {
                    if (!var3.isCreative()) {
                        var6.shrink(1);
                    }
                    var3.awardStat(StatisticList.ITEM_USED.get(var7));
                }
            }
            return var13.executeClickCommands((EntityPlayer)var3) ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    public BlockPropertyWood type() {
        return this.type;
    }
}

