/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemAttached;
import net.minecraft.world.level.block.BlockStemmed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockPumpkin
extends BlockStemmed {
    protected BlockPumpkin(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var12, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        ItemStack var6 = var3.getItemInHand(var4);
        if (var6.is(Items.SHEARS)) {
            if (!var12.isClientSide) {
                EnumDirection var7 = var5.getDirection();
                EnumDirection var8 = var7.getAxis() == EnumDirection.EnumAxis.Y ? var3.getDirection().getOpposite() : var7;
                var12.playSound(null, var2, SoundEffects.PUMPKIN_CARVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var12.setBlock(var2, (IBlockData)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(BlockPumpkinCarved.FACING, var8), 11);
                EntityItem var9 = new EntityItem(var12, (double)var2.getX() + 0.5 + (double)var8.getStepX() * 0.65, (double)var2.getY() + 0.1, (double)var2.getZ() + 0.5 + (double)var8.getStepZ() * 0.65, new ItemStack(Items.PUMPKIN_SEEDS, 4));
                var9.setDeltaMovement(0.05 * (double)var8.getStepX() + var12.random.nextDouble() * 0.02, 0.05, 0.05 * (double)var8.getStepZ() + var12.random.nextDouble() * 0.02);
                var12.addFreshEntity(var9);
                var6.hurtAndBreak(1, var3, var1 -> var1.broadcastBreakEvent(var4));
                var12.gameEvent((Entity)var3, GameEvent.SHEAR, var2);
                var3.awardStat(StatisticList.ITEM_USED.get(Items.SHEARS));
            }
            return EnumInteractionResult.sidedSuccess(var12.isClientSide);
        }
        return super.use(var0, var12, var2, var3, var4, var5);
    }

    @Override
    public BlockStem getStem() {
        return (BlockStem)Blocks.PUMPKIN_STEM;
    }

    @Override
    public BlockStemAttached getAttachedStem() {
        return (BlockStemAttached)Blocks.ATTACHED_PUMPKIN_STEM;
    }
}

