/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockLever
extends BlockAttachable {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    protected static final int DEPTH = 6;
    protected static final int WIDTH = 6;
    protected static final int HEIGHT = 8;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final VoxelShape UP_AABB_Z = Block.box(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final VoxelShape UP_AABB_X = Block.box(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final VoxelShape DOWN_AABB_Z = Block.box(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final VoxelShape DOWN_AABB_X = Block.box(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    protected BlockLever(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(FACE, BlockPropertyAttachPosition.WALL));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch ((BlockPropertyAttachPosition)var0.getValue(FACE)) {
            case FLOOR: {
                switch (var0.getValue(FACING).getAxis()) {
                    case X: {
                        return UP_AABB_X;
                    }
                }
                return UP_AABB_Z;
            }
            case WALL: {
                switch (var0.getValue(FACING)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        switch (var0.getValue(FACING).getAxis()) {
            case X: {
                return DOWN_AABB_X;
            }
        }
        return DOWN_AABB_Z;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            IBlockData var6 = (IBlockData)var0.cycle(POWERED);
            if (var6.getValue(POWERED).booleanValue()) {
                BlockLever.makeParticle(var6, var1, var2, 1.0f);
            }
            return EnumInteractionResult.SUCCESS;
        }
        IBlockData var6 = this.pull(var0, var1, var2);
        float var7 = var6.getValue(POWERED) != false ? 0.6f : 0.5f;
        var1.playSound(null, var2, SoundEffects.LEVER_CLICK, SoundCategory.BLOCKS, 0.3f, var7);
        var1.gameEvent((Entity)var3, var6.getValue(POWERED) != false ? GameEvent.BLOCK_SWITCH : GameEvent.BLOCK_UNSWITCH, var2);
        return EnumInteractionResult.CONSUME;
    }

    public IBlockData pull(IBlockData var0, World var1, BlockPosition var2) {
        var0 = (IBlockData)var0.cycle(POWERED);
        var1.setBlock(var2, var0, 3);
        this.updateNeighbours(var0, var1, var2);
        return var0;
    }

    private static void makeParticle(IBlockData var0, GeneratorAccess var1, BlockPosition var2, float var3) {
        EnumDirection var4 = var0.getValue(FACING).getOpposite();
        EnumDirection var5 = BlockLever.getConnectedDirection(var0).getOpposite();
        double var6 = (double)var2.getX() + 0.5 + 0.1 * (double)var4.getStepX() + 0.2 * (double)var5.getStepX();
        double var8 = (double)var2.getY() + 0.5 + 0.1 * (double)var4.getStepY() + 0.2 * (double)var5.getStepY();
        double var10 = (double)var2.getZ() + 0.5 + 0.1 * (double)var4.getStepZ() + 0.2 * (double)var5.getStepZ();
        var1.addParticle(new ParticleParamRedstone(ParticleParamRedstone.REDSTONE_PARTICLE_COLOR, var3), var6, var8, var10, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        if (var0.getValue(POWERED).booleanValue() && var3.nextFloat() < 0.25f) {
            BlockLever.makeParticle(var0, var1, var2, 0.5f);
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4 || var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(var0, var1, var2);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && BlockLever.getConnectedDirection(var0) == var3) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    private void updateNeighbours(IBlockData var0, World var1, BlockPosition var2) {
        var1.updateNeighborsAt(var2, this);
        var1.updateNeighborsAt(var2.relative(BlockLever.getConnectedDirection(var0).getOpposite()), this);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACE, FACING, POWERED);
    }
}

