/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockLeaves
extends Block {
    public static final int DECAY_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE = BlockProperties.DISTANCE;
    public static final BlockStateBoolean PERSISTENT = BlockProperties.PERSISTENT;
    private static final int TICK_DELAY = 1;

    public BlockLeaves(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(PERSISTENT, false));
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(DISTANCE) == 7 && var0.getValue(PERSISTENT) == false;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (!var0.getValue(PERSISTENT).booleanValue() && var0.getValue(DISTANCE) == 7) {
            BlockLeaves.dropResources(var0, var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        var1.setBlock(var2, BlockLeaves.updateDistance(var0, var1, var2), 3);
    }

    @Override
    public int getLightBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return 1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        int var6 = BlockLeaves.getDistanceAt(var2) + 1;
        if (var6 != 1 || var0.getValue(DISTANCE) != var6) {
            var3.scheduleTick(var4, this, 1);
        }
        return var0;
    }

    private static IBlockData updateDistance(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
        int var3 = 7;
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var8 : EnumDirection.values()) {
            var4.setWithOffset((BaseBlockPosition)var2, var8);
            var3 = Math.min(var3, BlockLeaves.getDistanceAt(var1.getBlockState(var4)) + 1);
            if (var3 == 1) break;
        }
        return (IBlockData)var0.setValue(DISTANCE, var3);
    }

    private static int getDistanceAt(IBlockData var0) {
        if (var0.is(TagsBlock.LOGS)) {
            return 0;
        }
        if (var0.getBlock() instanceof BlockLeaves) {
            return var0.getValue(DISTANCE);
        }
        return 7;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        if (!var1.isRainingAt(var2.above())) {
            return;
        }
        if (var3.nextInt(15) != 1) {
            return;
        }
        BlockPosition var4 = var2.below();
        IBlockData var5 = var1.getBlockState(var4);
        if (var5.canOcclude() && var5.isFaceSturdy(var1, var4, EnumDirection.UP)) {
            return;
        }
        double var6 = (double)var2.getX() + var3.nextDouble();
        double var8 = (double)var2.getY() - 0.05;
        double var10 = (double)var2.getZ() + var3.nextDouble();
        var1.addParticle(Particles.DRIPPING_WATER, var6, var8, var10, 0.0, 0.0, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DISTANCE, PERSISTENT);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return BlockLeaves.updateDistance((IBlockData)this.defaultBlockState().setValue(PERSISTENT, true), var0.getLevel(), var0.getClickedPos());
    }
}

