/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockFluids
extends Block
implements IFluidSource {
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL;
    protected final FluidTypeFlowing fluid;
    private final List<Fluid> stateCache;
    public static final VoxelShape STABLE_SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final ImmutableList<EnumDirection> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)EnumDirection.DOWN, (Object)EnumDirection.SOUTH, (Object)EnumDirection.NORTH, (Object)EnumDirection.EAST, (Object)EnumDirection.WEST);

    protected BlockFluids(FluidTypeFlowing var0, BlockBase.Info var1) {
        super(var1);
        this.fluid = var0;
        this.stateCache = Lists.newArrayList();
        this.stateCache.add(var0.getSource(false));
        for (int var2 = 1; var2 < 8; ++var2) {
            this.stateCache.add(var0.getFlowing(8 - var2, false));
        }
        this.stateCache.add(var0.getFlowing(8, true));
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LEVEL, 0));
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var3.isAbove(STABLE_SHAPE, var2, true) && var0.getValue(LEVEL) == 0 && var3.canStandOnFluid(var1.getFluidState(var2.above()), this.fluid)) {
            return STABLE_SHAPE;
        }
        return VoxelShapes.empty();
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getFluidState().isRandomlyTicking();
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        var0.getFluidState().randomTick(var1, var2, var3);
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return !this.fluid.is(TagsFluid.LAVA);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        int var1 = var0.getValue(LEVEL);
        return this.stateCache.get(Math.min(var1, 8));
    }

    @Override
    public boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        return var1.getFluidState().getType().isSame(this.fluid);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }

    @Override
    public List<ItemStack> getDrops(IBlockData var0, LootTableInfo.Builder var1) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (this.shouldSpreadLiquid(var1, var2, var0)) {
            var1.scheduleTick(var2, var0.getFluidState().getType(), this.fluid.getTickDelay(var1));
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getFluidState().isSource() || var2.getFluidState().isSource()) {
            var3.scheduleTick(var4, var0.getFluidState().getType(), this.fluid.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (this.shouldSpreadLiquid(var1, var2, var0)) {
            var1.scheduleTick(var2, var0.getFluidState().getType(), this.fluid.getTickDelay(var1));
        }
    }

    private boolean shouldSpreadLiquid(World var0, BlockPosition var1, IBlockData var2) {
        if (this.fluid.is(TagsFluid.LAVA)) {
            boolean var3 = var0.getBlockState(var1.below()).is(Blocks.SOUL_SOIL);
            for (EnumDirection var5 : POSSIBLE_FLOW_DIRECTIONS) {
                BlockPosition var6 = var1.relative(var5.getOpposite());
                if (var0.getFluidState(var6).is(TagsFluid.WATER)) {
                    Block var7 = var0.getFluidState(var1).isSource() ? Blocks.OBSIDIAN : Blocks.COBBLESTONE;
                    var0.setBlockAndUpdate(var1, var7.defaultBlockState());
                    this.fizz(var0, var1);
                    return false;
                }
                if (!var3 || !var0.getBlockState(var6).is(Blocks.BLUE_ICE)) continue;
                var0.setBlockAndUpdate(var1, Blocks.BASALT.defaultBlockState());
                this.fizz(var0, var1);
                return false;
            }
        }
        return true;
    }

    private void fizz(GeneratorAccess var0, BlockPosition var1) {
        var0.levelEvent(1501, var1, 0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LEVEL);
    }

    @Override
    public ItemStack pickupBlock(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        if (var2.getValue(LEVEL) == 0) {
            var0.setBlock(var1, Blocks.AIR.defaultBlockState(), 11);
            return new ItemStack(this.fluid.getBucket());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return this.fluid.getPickupSound();
    }
}

