/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    public static final MapCodec<WorldChunkManagerMultiNoise> DIRECT_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecordCodecBuilder.create(var0 -> var0.group((App)Climate.d.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)BiomeBase.CODEC.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)var0, Pair::of)).listOf().xmap(Climate.c::new, Climate.c::values).fieldOf("biomes").forGetter(var0 -> var0.parameters)).apply((Applicative)var02, WorldChunkManagerMultiNoise::new));
    public static final Codec<WorldChunkManagerMultiNoise> CODEC = Codec.mapEither(b.CODEC, DIRECT_CODEC).xmap(var0 -> (WorldChunkManagerMultiNoise)var0.map(b::biomeSource, Function.identity()), var0 -> var0.preset().map(Either::left).orElseGet(() -> Either.right((Object)var0))).codec();
    private final Climate.c<Supplier<BiomeBase>> parameters;
    private final Optional<b> preset;

    private WorldChunkManagerMultiNoise(Climate.c<Supplier<BiomeBase>> var0) {
        this(var0, Optional.empty());
    }

    WorldChunkManagerMultiNoise(Climate.c<Supplier<BiomeBase>> var0, Optional<b> var1) {
        super(var0.values().stream().map(Pair::getSecond));
        this.preset = var1;
        this.parameters = var0;
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public WorldChunkManager withSeed(long var0) {
        return this;
    }

    private Optional<b> preset() {
        return this.preset;
    }

    public boolean stable(a var0) {
        return this.preset.isPresent() && Objects.equals(this.preset.get().preset(), var0);
    }

    @Override
    public BiomeBase getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.getNoiseBiome(var3.sample(var0, var1, var2));
    }

    @VisibleForDebug
    public BiomeBase getNoiseBiome(Climate.h var0) {
        return this.parameters.findValue(var0, () -> BiomeRegistry.THE_VOID).get();
    }

    @Override
    public void addMultinoiseDebugInfo(List<String> var0, BlockPosition var1, Climate.Sampler var2) {
        int var3 = QuartPos.fromBlock(var1.getX());
        int var4 = QuartPos.fromBlock(var1.getY());
        int var5 = QuartPos.fromBlock(var1.getZ());
        Climate.h var6 = var2.sample(var3, var4, var5);
        float var7 = Climate.unquantizeCoord(var6.continentalness());
        float var8 = Climate.unquantizeCoord(var6.erosion());
        float var9 = Climate.unquantizeCoord(var6.temperature());
        float var10 = Climate.unquantizeCoord(var6.humidity());
        float var11 = Climate.unquantizeCoord(var6.weirdness());
        double var12 = TerrainShaper.peaksAndValleys(var11);
        DecimalFormat var14 = new DecimalFormat("0.000");
        var0.add("Multinoise C: " + var14.format(var7) + " E: " + var14.format(var8) + " T: " + var14.format(var9) + " H: " + var14.format(var10) + " W: " + var14.format(var11));
        OverworldBiomeBuilder var15 = new OverworldBiomeBuilder();
        var0.add("Biome builder PV: " + OverworldBiomeBuilder.getDebugStringForPeaksAndValleys(var12) + " C: " + var15.getDebugStringForContinentalness(var7) + " E: " + var15.getDebugStringForErosion(var8) + " T: " + var15.getDebugStringForTemperature(var9) + " H: " + var15.getDebugStringForHumidity(var10));
        if (!(var2 instanceof NoiseSampler)) {
            return;
        }
        NoiseSampler var16 = (NoiseSampler)var2;
        TerrainInfo var17 = var16.terrainInfo(var1.getX(), var1.getZ(), var7, var11, var8, Blender.empty());
        var0.add("Terrain PV: " + var14.format(var12) + " O: " + var14.format(var17.offset()) + " F: " + var14.format(var17.factor()) + " JA: " + var14.format(var17.jaggedness()));
    }

    record b(a preset, IRegistry<BiomeBase> biomes) {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)MinecraftKey.CODEC.flatXmap(var0 -> Optional.ofNullable(a.BY_NAME.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + var0))), var0 -> DataResult.success((Object)var0.name)).fieldOf("preset").stable().forGetter(b::preset), (App)RegistryLookupCodec.create(IRegistry.BIOME_REGISTRY).forGetter(b::biomes)).apply((Applicative)var02, var02.stable(b::new)));

        public WorldChunkManagerMultiNoise biomeSource() {
            return this.preset.biomeSource(this, true);
        }
    }

    public static class a {
        static final Map<MinecraftKey, a> BY_NAME = Maps.newHashMap();
        public static final a NETHER = new a(new MinecraftKey("nether"), var0 -> new Climate.c(ImmutableList.of((Object)Pair.of((Object)Climate.parameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> var0.getOrThrow(Biomes.NETHER_WASTES)), (Object)Pair.of((Object)Climate.parameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> var0.getOrThrow(Biomes.SOUL_SAND_VALLEY)), (Object)Pair.of((Object)Climate.parameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> var0.getOrThrow(Biomes.CRIMSON_FOREST)), (Object)Pair.of((Object)Climate.parameters(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), () -> var0.getOrThrow(Biomes.WARPED_FOREST)), (Object)Pair.of((Object)Climate.parameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), () -> var0.getOrThrow(Biomes.BASALT_DELTAS)))));
        public static final a OVERWORLD = new a(new MinecraftKey("overworld"), var0 -> {
            ImmutableList.Builder var1 = ImmutableList.builder();
            new OverworldBiomeBuilder().addBiomes(var2 -> var1.add((Object)var2.mapSecond(var1 -> () -> (BiomeBase)var0.getOrThrow(var1))));
            return new Climate.c(var1.build());
        });
        final MinecraftKey name;
        private final Function<IRegistry<BiomeBase>, Climate.c<Supplier<BiomeBase>>> parameterSource;

        public a(MinecraftKey var0, Function<IRegistry<BiomeBase>, Climate.c<Supplier<BiomeBase>>> var1) {
            this.name = var0;
            this.parameterSource = var1;
            BY_NAME.put(var0, this);
        }

        WorldChunkManagerMultiNoise biomeSource(b var0, boolean var1) {
            Climate.c<Supplier<BiomeBase>> var2 = this.parameterSource.apply(var0.biomes());
            return new WorldChunkManagerMultiNoise(var2, var1 ? Optional.of(var0) : Optional.empty());
        }

        public WorldChunkManagerMultiNoise biomeSource(IRegistry<BiomeBase> var0, boolean var1) {
            return this.biomeSource(new b(this, var0), var1);
        }

        public WorldChunkManagerMultiNoise biomeSource(IRegistry<BiomeBase> var0) {
            return this.biomeSource(var0, true);
        }
    }
}

