/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeBase {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<BiomeBase> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)c.CODEC.forGetter(var0 -> var0.climateSettings), (App)Geography.CODEC.fieldOf("category").forGetter(var0 -> var0.biomeCategory), (App)BiomeFog.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects), (App)BiomeSettingsGeneration.CODEC.forGetter(var0 -> var0.generationSettings), (App)BiomeSettingsMobs.CODEC.forGetter(var0 -> var0.mobSettings)).apply((Applicative)var02, BiomeBase::new));
    public static final Codec<BiomeBase> NETWORK_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)c.CODEC.forGetter(var0 -> var0.climateSettings), (App)Geography.CODEC.fieldOf("category").forGetter(var0 -> var0.biomeCategory), (App)BiomeFog.CODEC.fieldOf("effects").forGetter(var0 -> var0.specialEffects)).apply((Applicative)var02, (var0, var1, var2) -> new BiomeBase((c)var0, (Geography)var1, (BiomeFog)var2, BiomeSettingsGeneration.EMPTY, BiomeSettingsMobs.EMPTY)));
    public static final Codec<Supplier<BiomeBase>> CODEC = RegistryFileCodec.create(IRegistry.BIOME_REGISTRY, DIRECT_CODEC);
    public static final Codec<List<Supplier<BiomeBase>>> LIST_CODEC = RegistryFileCodec.homogeneousList(IRegistry.BIOME_REGISTRY, DIRECT_CODEC);
    private static final NoiseGenerator3 TEMPERATURE_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 FROZEN_TEMPERATURE_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 BIOME_INFO_NOISE = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int TEMPERATURE_CACHE_SIZE = 1024;
    private final c climateSettings;
    private final BiomeSettingsGeneration generationSettings;
    private final BiomeSettingsMobs mobSettings;
    private final Geography biomeCategory;
    private final BiomeFog specialEffects;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> SystemUtils.make(() -> {
        Long2FloatLinkedOpenHashMap var0 = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue(Float.NaN);
        return var0;
    }));

    BiomeBase(c var0, Geography var1, BiomeFog var2, BiomeSettingsGeneration var3, BiomeSettingsMobs var4) {
        this.climateSettings = var0;
        this.generationSettings = var3;
        this.mobSettings = var4;
        this.biomeCategory = var1;
        this.specialEffects = var2;
    }

    public int getSkyColor() {
        return this.specialEffects.getSkyColor();
    }

    public BiomeSettingsMobs getMobSettings() {
        return this.mobSettings;
    }

    public Precipitation getPrecipitation() {
        return this.climateSettings.precipitation;
    }

    public boolean isHumid() {
        return this.getDownfall() > 0.85f;
    }

    private float getHeightAdjustedTemperature(BlockPosition var0) {
        float var1 = this.climateSettings.temperatureModifier.modifyTemperature(var0, this.getBaseTemperature());
        if (var0.getY() > 80) {
            float var2 = (float)(TEMPERATURE_NOISE.getValue((float)var0.getX() / 8.0f, (float)var0.getZ() / 8.0f, false) * 8.0);
            return var1 - (var2 + (float)var0.getY() - 80.0f) * 0.05f / 40.0f;
        }
        return var1;
    }

    public final float getTemperature(BlockPosition var0) {
        long var1 = var0.asLong();
        Long2FloatLinkedOpenHashMap var3 = this.temperatureCache.get();
        float var4 = var3.get(var1);
        if (!Float.isNaN(var4)) {
            return var4;
        }
        float var5 = this.getHeightAdjustedTemperature(var0);
        if (var3.size() == 1024) {
            var3.removeFirstFloat();
        }
        var3.put(var1, var5);
        return var5;
    }

    public boolean shouldFreeze(IWorldReader var0, BlockPosition var1) {
        return this.shouldFreeze(var0, var1, true);
    }

    public boolean shouldFreeze(IWorldReader var0, BlockPosition var1, boolean var2) {
        if (this.getTemperature(var1) >= 0.15f) {
            return false;
        }
        if (var1.getY() >= var0.getMinBuildHeight() && var1.getY() < var0.getMaxBuildHeight() && var0.getBrightness(EnumSkyBlock.BLOCK, var1) < 10) {
            IBlockData var3 = var0.getBlockState(var1);
            Fluid var4 = var0.getFluidState(var1);
            if (var4.getType() == FluidTypes.WATER && var3.getBlock() instanceof BlockFluids) {
                boolean var5;
                if (!var2) {
                    return true;
                }
                boolean bl = var5 = var0.isWaterAt(var1.west()) && var0.isWaterAt(var1.east()) && var0.isWaterAt(var1.north()) && var0.isWaterAt(var1.south());
                if (!var5) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isColdEnoughToSnow(BlockPosition var0) {
        return this.getTemperature(var0) < 0.15f;
    }

    public boolean shouldSnow(IWorldReader var0, BlockPosition var1) {
        IBlockData var2;
        if (!this.isColdEnoughToSnow(var1)) {
            return false;
        }
        return var1.getY() >= var0.getMinBuildHeight() && var1.getY() < var0.getMaxBuildHeight() && var0.getBrightness(EnumSkyBlock.BLOCK, var1) < 10 && (var2 = var0.getBlockState(var1)).isAir() && Blocks.SNOW.defaultBlockState().canSurvive(var0, var1);
    }

    public BiomeSettingsGeneration getGenerationSettings() {
        return this.generationSettings;
    }

    public int getFogColor() {
        return this.specialEffects.getFogColor();
    }

    public int getGrassColor(double var0, double var2) {
        int var4 = this.specialEffects.getGrassColorOverride().orElseGet(this::getGrassColorFromTexture);
        return this.specialEffects.getGrassColorModifier().modifyColor(var0, var2, var4);
    }

    private int getGrassColorFromTexture() {
        double var0 = MathHelper.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = MathHelper.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return GrassColor.get(var0, var2);
    }

    public int getFoliageColor() {
        return this.specialEffects.getFoliageColorOverride().orElseGet(this::getFoliageColorFromTexture);
    }

    private int getFoliageColorFromTexture() {
        double var0 = MathHelper.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double var2 = MathHelper.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return FoliageColor.get(var0, var2);
    }

    public final float getDownfall() {
        return this.climateSettings.downfall;
    }

    public final float getBaseTemperature() {
        return this.climateSettings.temperature;
    }

    public BiomeFog getSpecialEffects() {
        return this.specialEffects;
    }

    public final int getWaterColor() {
        return this.specialEffects.getWaterColor();
    }

    public final int getWaterFogColor() {
        return this.specialEffects.getWaterFogColor();
    }

    public Optional<BiomeParticles> getAmbientParticle() {
        return this.specialEffects.getAmbientParticleSettings();
    }

    public Optional<SoundEffect> getAmbientLoop() {
        return this.specialEffects.getAmbientLoopSoundEvent();
    }

    public Optional<CaveSoundSettings> getAmbientMood() {
        return this.specialEffects.getAmbientMoodSettings();
    }

    public Optional<CaveSound> getAmbientAdditions() {
        return this.specialEffects.getAmbientAdditionsSettings();
    }

    public Optional<Music> getBackgroundMusic() {
        return this.specialEffects.getBackgroundMusic();
    }

    public final Geography getBiomeCategory() {
        return this.biomeCategory;
    }

    public String toString() {
        MinecraftKey var0 = RegistryGeneration.BIOME.getKey(this);
        return var0 == null ? super.toString() : var0.toString();
    }

    static class c {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Precipitation.CODEC.fieldOf("precipitation").forGetter(var0 -> var0.precipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(var0 -> Float.valueOf(var0.temperature)), (App)TemperatureModifier.CODEC.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(var0 -> var0.temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(var0 -> Float.valueOf(var0.downfall))).apply((Applicative)var02, c::new));
        final Precipitation precipitation;
        final float temperature;
        final TemperatureModifier temperatureModifier;
        final float downfall;

        c(Precipitation var0, float var1, TemperatureModifier var2, float var3) {
            this.precipitation = var0;
            this.temperature = var1;
            this.temperatureModifier = var2;
            this.downfall = var3;
        }
    }

    public static final class Geography
    extends Enum<Geography>
    implements INamable {
        public static final /* enum */ Geography NONE = new Geography("none");
        public static final /* enum */ Geography TAIGA = new Geography("taiga");
        public static final /* enum */ Geography EXTREME_HILLS = new Geography("extreme_hills");
        public static final /* enum */ Geography JUNGLE = new Geography("jungle");
        public static final /* enum */ Geography MESA = new Geography("mesa");
        public static final /* enum */ Geography PLAINS = new Geography("plains");
        public static final /* enum */ Geography SAVANNA = new Geography("savanna");
        public static final /* enum */ Geography ICY = new Geography("icy");
        public static final /* enum */ Geography THEEND = new Geography("the_end");
        public static final /* enum */ Geography BEACH = new Geography("beach");
        public static final /* enum */ Geography FOREST = new Geography("forest");
        public static final /* enum */ Geography OCEAN = new Geography("ocean");
        public static final /* enum */ Geography DESERT = new Geography("desert");
        public static final /* enum */ Geography RIVER = new Geography("river");
        public static final /* enum */ Geography SWAMP = new Geography("swamp");
        public static final /* enum */ Geography MUSHROOM = new Geography("mushroom");
        public static final /* enum */ Geography NETHER = new Geography("nether");
        public static final /* enum */ Geography UNDERGROUND = new Geography("underground");
        public static final /* enum */ Geography MOUNTAIN = new Geography("mountain");
        public static final Codec<Geography> CODEC;
        private static final Map<String, Geography> BY_NAME;
        private final String name;
        private static final /* synthetic */ Geography[] w;

        public static Geography[] values() {
            return (Geography[])w.clone();
        }

        public static Geography valueOf(String var0) {
            return Enum.valueOf(Geography.class, var0);
        }

        private Geography(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        public static Geography byName(String var0) {
            return BY_NAME.get(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Geography[] b() {
            return new Geography[]{NONE, TAIGA, EXTREME_HILLS, JUNGLE, MESA, PLAINS, SAVANNA, ICY, THEEND, BEACH, FOREST, OCEAN, DESERT, RIVER, SWAMP, MUSHROOM, NETHER, UNDERGROUND, MOUNTAIN};
        }

        static {
            w = Geography.b();
            CODEC = INamable.fromEnum(Geography::values, Geography::byName);
            BY_NAME = Arrays.stream(Geography.values()).collect(Collectors.toMap(Geography::getName, var0 -> var0));
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements INamable {
        public static final /* enum */ Precipitation NONE = new Precipitation("none");
        public static final /* enum */ Precipitation RAIN = new Precipitation("rain");
        public static final /* enum */ Precipitation SNOW = new Precipitation("snow");
        public static final Codec<Precipitation> CODEC;
        private static final Map<String, Precipitation> BY_NAME;
        private final String name;
        private static final /* synthetic */ Precipitation[] g;

        public static Precipitation[] values() {
            return (Precipitation[])g.clone();
        }

        public static Precipitation valueOf(String var0) {
            return Enum.valueOf(Precipitation.class, var0);
        }

        private Precipitation(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        public static Precipitation byName(String var0) {
            return BY_NAME.get(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Precipitation[] b() {
            return new Precipitation[]{NONE, RAIN, SNOW};
        }

        static {
            g = Precipitation.b();
            CODEC = INamable.fromEnum(Precipitation::values, Precipitation::byName);
            BY_NAME = Arrays.stream(Precipitation.values()).collect(Collectors.toMap(Precipitation::getName, var0 -> var0));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier NONE = new TemperatureModifier("none"){

            @Override
            public float modifyTemperature(BlockPosition var0, float var1) {
                return var1;
            }
        };
        public static final /* enum */ TemperatureModifier FROZEN = new TemperatureModifier("frozen"){

            @Override
            public float modifyTemperature(BlockPosition var0, float var1) {
                double var8;
                double var4;
                double var2 = FROZEN_TEMPERATURE_NOISE.getValue((double)var0.getX() * 0.05, (double)var0.getZ() * 0.05, false) * 7.0;
                double var6 = var2 + (var4 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.2, (double)var0.getZ() * 0.2, false));
                if (var6 < 0.3 && (var8 = BIOME_INFO_NOISE.getValue((double)var0.getX() * 0.09, (double)var0.getZ() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return var1;
            }
        };
        private final String name;
        public static final Codec<TemperatureModifier> CODEC;
        private static final Map<String, TemperatureModifier> BY_NAME;
        private static final /* synthetic */ TemperatureModifier[] f;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])f.clone();
        }

        public static TemperatureModifier valueOf(String var0) {
            return Enum.valueOf(TemperatureModifier.class, var0);
        }

        public abstract float modifyTemperature(BlockPosition var1, float var2);

        TemperatureModifier(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static TemperatureModifier byName(String var0) {
            return BY_NAME.get(var0);
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{NONE, FROZEN};
        }

        static {
            f = TemperatureModifier.b();
            CODEC = INamable.fromEnum(TemperatureModifier::values, TemperatureModifier::byName);
            BY_NAME = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::getName, var0 -> var0));
        }
    }

    public static class a {
        @Nullable
        private Precipitation precipitation;
        @Nullable
        private Geography biomeCategory;
        @Nullable
        private Float temperature;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;
        @Nullable
        private Float downfall;
        @Nullable
        private BiomeFog specialEffects;
        @Nullable
        private BiomeSettingsMobs mobSpawnSettings;
        @Nullable
        private BiomeSettingsGeneration generationSettings;

        public a precipitation(Precipitation var0) {
            this.precipitation = var0;
            return this;
        }

        public a biomeCategory(Geography var0) {
            this.biomeCategory = var0;
            return this;
        }

        public a temperature(float var0) {
            this.temperature = Float.valueOf(var0);
            return this;
        }

        public a downfall(float var0) {
            this.downfall = Float.valueOf(var0);
            return this;
        }

        public a specialEffects(BiomeFog var0) {
            this.specialEffects = var0;
            return this;
        }

        public a mobSpawnSettings(BiomeSettingsMobs var0) {
            this.mobSpawnSettings = var0;
            return this;
        }

        public a generationSettings(BiomeSettingsGeneration var0) {
            this.generationSettings = var0;
            return this;
        }

        public a temperatureAdjustment(TemperatureModifier var0) {
            this.temperatureModifier = var0;
            return this;
        }

        public BiomeBase build() {
            if (this.precipitation == null || this.biomeCategory == null || this.temperature == null || this.downfall == null || this.specialEffects == null || this.mobSpawnSettings == null || this.generationSettings == null) {
                throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
            }
            return new BiomeBase(new c(this.precipitation, this.temperature.floatValue(), this.temperatureModifier, this.downfall.floatValue()), this.biomeCategory, this.specialEffects, this.generationSettings, this.mobSpawnSettings);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + this.precipitation + ",\nbiomeCategory=" + this.biomeCategory + ",\ntemperature=" + this.temperature + ",\ntemperatureModifier=" + this.temperatureModifier + ",\ndownfall=" + this.downfall + ",\nspecialEffects=" + this.specialEffects + ",\nmobSpawnSettings=" + this.mobSpawnSettings + ",\ngenerationSettings=" + this.generationSettings + ",\n}";
        }
    }
}

