/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;

public record MobSpawnerData(NBTTagCompound entityToSpawn, Optional<a> customSpawnRules) {
    public static final Codec<MobSpawnerData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)NBTTagCompound.CODEC.fieldOf("entity").forGetter(var0 -> var0.entityToSpawn), (App)a.CODEC.optionalFieldOf("custom_spawn_rules").forGetter(var0 -> var0.customSpawnRules)).apply((Applicative)var02, MobSpawnerData::new));
    public static final Codec<SimpleWeightedRandomList<MobSpawnerData>> LIST_CODEC = SimpleWeightedRandomList.wrappedCodecAllowingEmpty(CODEC);
    public static final String DEFAULT_TYPE = "minecraft:pig";

    public MobSpawnerData() {
        this(SystemUtils.make(new NBTTagCompound(), var0 -> var0.putString("id", DEFAULT_TYPE)), Optional.empty());
    }

    public MobSpawnerData {
        MinecraftKey var2 = MinecraftKey.tryParse(var0.getString("id"));
        var0.putString("id", var2 != null ? var2.toString() : DEFAULT_TYPE);
    }

    public NBTTagCompound getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public Optional<a> getCustomSpawnRules() {
        return this.customSpawnRules;
    }

    public record a(InclusiveRange<Integer> blockLightLimit, InclusiveRange<Integer> skyLightLimit) {
        private static final InclusiveRange<Integer> LIGHT_RANGE = new InclusiveRange(0, 15);
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)InclusiveRange.INT.optionalFieldOf("block_light_limit", LIGHT_RANGE).flatXmap(a::checkLightBoundaries, a::checkLightBoundaries).forGetter(var0 -> var0.blockLightLimit), (App)InclusiveRange.INT.optionalFieldOf("sky_light_limit", LIGHT_RANGE).flatXmap(a::checkLightBoundaries, a::checkLightBoundaries).forGetter(var0 -> var0.skyLightLimit)).apply((Applicative)var02, a::new));

        private static DataResult<InclusiveRange<Integer>> checkLightBoundaries(InclusiveRange<Integer> var0) {
            if (!LIGHT_RANGE.contains(var0)) {
                return DataResult.error((String)("Light values must be withing range " + LIGHT_RANGE));
            }
            return DataResult.success(var0);
        }
    }
}

