/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.IWorldTime;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public interface GeneratorAccess
extends ICombinedAccess,
IWorldTime {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    public LevelTickAccess<Block> getBlockTicks();

    private <T> NextTickListEntry<T> createTick(BlockPosition var0, T var1, int var2, TickListPriority var3) {
        return new NextTickListEntry(var1, var0, this.getLevelData().getGameTime() + (long)var2, var3, this.nextSubTickCount());
    }

    private <T> NextTickListEntry<T> createTick(BlockPosition var0, T var1, int var2) {
        return new NextTickListEntry(var1, var0, this.getLevelData().getGameTime() + (long)var2, this.nextSubTickCount());
    }

    default public void scheduleTick(BlockPosition var0, Block var1, int var2, TickListPriority var3) {
        this.getBlockTicks().schedule(this.createTick(var0, var1, var2, var3));
    }

    default public void scheduleTick(BlockPosition var0, Block var1, int var2) {
        this.getBlockTicks().schedule(this.createTick(var0, var1, var2));
    }

    public LevelTickAccess<FluidType> getFluidTicks();

    default public void scheduleTick(BlockPosition var0, FluidType var1, int var2, TickListPriority var3) {
        this.getFluidTicks().schedule(this.createTick(var0, var1, var2, var3));
    }

    default public void scheduleTick(BlockPosition var0, FluidType var1, int var2) {
        this.getFluidTicks().schedule(this.createTick(var0, var1, var2));
    }

    public WorldData getLevelData();

    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var1);

    @Nullable
    public MinecraftServer getServer();

    default public EnumDifficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public IChunkProvider getChunkSource();

    @Override
    default public boolean hasChunk(int var0, int var1) {
        return this.getChunkSource().hasChunk(var0, var1);
    }

    public Random getRandom();

    default public void blockUpdated(BlockPosition var0, Block var1) {
    }

    public void playSound(@Nullable EntityHuman var1, BlockPosition var2, SoundEffect var3, SoundCategory var4, float var5, float var6);

    public void addParticle(ParticleParam var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable EntityHuman var1, int var2, BlockPosition var3, int var4);

    default public void levelEvent(int var0, BlockPosition var1, int var2) {
        this.levelEvent(null, var0, var1, var2);
    }

    public void gameEvent(@Nullable Entity var1, GameEvent var2, BlockPosition var3);

    default public void gameEvent(GameEvent var0, BlockPosition var1) {
        this.gameEvent(null, var0, var1);
    }

    default public void gameEvent(GameEvent var0, Entity var1) {
        this.gameEvent(null, var0, var1.blockPosition());
    }

    default public void gameEvent(@Nullable Entity var0, GameEvent var1, Entity var2) {
        this.gameEvent(var0, var1, var2.blockPosition());
    }
}

