/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final Effect blockInteraction;
    private final Random random = new Random();
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final List<BlockPosition> toBlow = Lists.newArrayList();
    private final Map<EntityHuman, Vec3D> hitPlayers = Maps.newHashMap();

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8) {
        this(var0, var1, var2, var4, var6, var8, false, Effect.DESTROY);
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, List<BlockPosition> var9) {
        this(var0, var1, var2, var4, var6, var8, false, Effect.DESTROY, var9);
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, boolean var9, Effect var10, List<BlockPosition> var11) {
        this(var0, var1, var2, var4, var6, var8, var9, var10);
        this.toBlow.addAll(var11);
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, boolean var9, Effect var10) {
        this(var0, var1, null, null, var2, var4, var6, var8, var9, var10);
    }

    public Explosion(World var0, @Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, Effect var12) {
        this.level = var0;
        this.source = var1;
        this.radius = var10;
        this.x = var4;
        this.y = var6;
        this.z = var8;
        this.fire = var11;
        this.blockInteraction = var12;
        this.damageSource = var2 == null ? DamageSource.explosion(this) : var2;
        this.damageCalculator = var3 == null ? this.makeDamageCalculator(var1) : var3;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity var0) {
        return var0 == null ? EXPLOSION_DAMAGE_CALCULATOR : new ExplosionDamageCalculatorEntity(var0);
    }

    public static float getSeenPercent(Vec3D var0, Entity var1) {
        AxisAlignedBB var2 = var1.getBoundingBox();
        double var3 = 1.0 / ((var2.maxX - var2.minX) * 2.0 + 1.0);
        double var5 = 1.0 / ((var2.maxY - var2.minY) * 2.0 + 1.0);
        double var7 = 1.0 / ((var2.maxZ - var2.minZ) * 2.0 + 1.0);
        double var9 = (1.0 - Math.floor(1.0 / var3) * var3) / 2.0;
        double var11 = (1.0 - Math.floor(1.0 / var7) * var7) / 2.0;
        if (var3 < 0.0 || var5 < 0.0 || var7 < 0.0) {
            return 0.0f;
        }
        int var13 = 0;
        int var14 = 0;
        float var15 = 0.0f;
        while (var15 <= 1.0f) {
            float var16 = 0.0f;
            while (var16 <= 1.0f) {
                float var17 = 0.0f;
                while (var17 <= 1.0f) {
                    double var22;
                    double var20;
                    double var18 = MathHelper.lerp((double)var15, var2.minX, var2.maxX);
                    Vec3D var24 = new Vec3D(var18 + var9, var20 = MathHelper.lerp((double)var16, var2.minY, var2.maxY), (var22 = MathHelper.lerp((double)var17, var2.minZ, var2.maxZ)) + var11);
                    if (var1.level.clip(new RayTrace(var24, var0, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var1)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
                        ++var13;
                    }
                    ++var14;
                    var17 = (float)((double)var17 + var7);
                }
                var16 = (float)((double)var16 + var5);
            }
            var15 = (float)((double)var15 + var3);
        }
        return (float)var13 / (float)var14;
    }

    public void explode() {
        int var4;
        int var3;
        this.level.gameEvent(this.source, GameEvent.EXPLODE, new BlockPosition(this.x, this.y, this.z));
        HashSet var0 = Sets.newHashSet();
        int var1 = 16;
        for (int var2 = 0; var2 < 16; ++var2) {
            for (var3 = 0; var3 < 16; ++var3) {
                block2: for (var4 = 0; var4 < 16; ++var4) {
                    if (var2 != 0 && var2 != 15 && var3 != 0 && var3 != 15 && var4 != 0 && var4 != 15) continue;
                    double var5 = (float)var2 / 15.0f * 2.0f - 1.0f;
                    double var7 = (float)var3 / 15.0f * 2.0f - 1.0f;
                    double var9 = (float)var4 / 15.0f * 2.0f - 1.0f;
                    double var11 = Math.sqrt(var5 * var5 + var7 * var7 + var9 * var9);
                    var5 /= var11;
                    var7 /= var11;
                    var9 /= var11;
                    double var14 = this.x;
                    double var16 = this.y;
                    double var18 = this.z;
                    float var20 = 0.3f;
                    for (float var13 = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); var13 > 0.0f; var13 -= 0.22500001f) {
                        BlockPosition var21 = new BlockPosition(var14, var16, var18);
                        IBlockData var22 = this.level.getBlockState(var21);
                        Fluid var23 = this.level.getFluidState(var21);
                        if (!this.level.isInWorldBounds(var21)) continue block2;
                        Optional<Float> var24 = this.damageCalculator.getBlockExplosionResistance(this, this.level, var21, var22, var23);
                        if (var24.isPresent()) {
                            var13 -= (var24.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (var13 > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, var21, var22, var13)) {
                            var0.add(var21);
                        }
                        var14 += var5 * (double)0.3f;
                        var16 += var7 * (double)0.3f;
                        var18 += var9 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll(var0);
        float var2 = this.radius * 2.0f;
        var3 = MathHelper.floor(this.x - (double)var2 - 1.0);
        var4 = MathHelper.floor(this.x + (double)var2 + 1.0);
        int var5 = MathHelper.floor(this.y - (double)var2 - 1.0);
        int var6 = MathHelper.floor(this.y + (double)var2 + 1.0);
        int var7 = MathHelper.floor(this.z - (double)var2 - 1.0);
        int var8 = MathHelper.floor(this.z + (double)var2 + 1.0);
        List<Entity> var9 = this.level.getEntities(this.source, new AxisAlignedBB(var3, var5, var7, var4, var6, var8));
        Vec3D var10 = new Vec3D(this.x, this.y, this.z);
        for (int var11 = 0; var11 < var9.size(); ++var11) {
            EntityHuman var29;
            double var19;
            double var17;
            double var15;
            double var21;
            double var13;
            Entity var12 = var9.get(var11);
            if (var12.ignoreExplosion() || !((var13 = Math.sqrt(var12.distanceToSqr(var10)) / (double)var2) <= 1.0) || (var21 = Math.sqrt((var15 = var12.getX() - this.x) * var15 + (var17 = (var12 instanceof EntityTNTPrimed ? var12.getY() : var12.getEyeY()) - this.y) * var17 + (var19 = var12.getZ() - this.z) * var19)) == 0.0) continue;
            var15 /= var21;
            var17 /= var21;
            var19 /= var21;
            double var23 = Explosion.getSeenPercent(var10, var12);
            double var25 = (1.0 - var13) * var23;
            var12.hurt(this.getDamageSource(), (int)((var25 * var25 + var25) / 2.0 * 7.0 * (double)var2 + 1.0));
            double var27 = var25;
            if (var12 instanceof EntityLiving) {
                var27 = EnchantmentProtection.getExplosionKnockbackAfterDampener((EntityLiving)var12, var25);
            }
            var12.setDeltaMovement(var12.getDeltaMovement().add(var15 * var27, var17 * var27, var19 * var27));
            if (!(var12 instanceof EntityHuman) || (var29 = (EntityHuman)var12).isSpectator() || var29.isCreative() && var29.getAbilities().flying) continue;
            this.hitPlayers.put(var29, new Vec3D(var15 * var25, var17 * var25, var19 * var25));
        }
    }

    public void finalizeExplosion(boolean var0) {
        boolean var1;
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, SoundEffects.GENERIC_EXPLODE, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = var1 = this.blockInteraction != Effect.NONE;
        if (var0) {
            if (this.radius < 2.0f || !var1) {
                this.level.addParticle(Particles.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.addParticle(Particles.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (var1) {
            ObjectArrayList var22 = new ObjectArrayList();
            Collections.shuffle(this.toBlow, this.level.random);
            for (BlockPosition var4 : this.toBlow) {
                IBlockData var5 = this.level.getBlockState(var4);
                Block var6 = var5.getBlock();
                if (var5.isAir()) continue;
                BlockPosition var7 = var4.immutable();
                this.level.getProfiler().push("explosion_blocks");
                if (var6.dropFromExplosion(this) && this.level instanceof WorldServer) {
                    TileEntity var8 = var5.hasBlockEntity() ? this.level.getBlockEntity(var4) : null;
                    LootTableInfo.Builder var9 = new LootTableInfo.Builder((WorldServer)this.level).withRandom(this.level.random).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var4)).withParameter(LootContextParameters.TOOL, ItemStack.EMPTY).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, var8).withOptionalParameter(LootContextParameters.THIS_ENTITY, this.source);
                    if (this.blockInteraction == Effect.DESTROY) {
                        var9.withParameter(LootContextParameters.EXPLOSION_RADIUS, Float.valueOf(this.radius));
                    }
                    var5.getDrops(var9).forEach(var2 -> Explosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPosition>>)var22, var2, var7));
                }
                this.level.setBlock(var4, Blocks.AIR.defaultBlockState(), 3);
                var6.wasExploded(this.level, var4, this);
                this.level.getProfiler().pop();
            }
            for (BlockPosition var4 : var22) {
                Block.popResource(this.level, (BlockPosition)var4.getSecond(), (ItemStack)var4.getFirst());
            }
        }
        if (this.fire) {
            for (BlockPosition var3 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(var3).isAir() || !this.level.getBlockState(var3.below()).isSolidRender(this.level, var3.below())) continue;
                this.level.setBlockAndUpdate(var3, BlockFireAbstract.getState(this.level, var3));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPosition>> var0, ItemStack var1, BlockPosition var2) {
        int var3 = var0.size();
        for (int var4 = 0; var4 < var3; ++var4) {
            Pair var5 = (Pair)var0.get(var4);
            ItemStack var6 = (ItemStack)var5.getFirst();
            if (!EntityItem.areMergable(var6, var1)) continue;
            ItemStack var7 = EntityItem.merge(var6, var1, 16);
            var0.set(var4, (Object)Pair.of((Object)var7, (Object)((BlockPosition)var5.getSecond())));
            if (!var1.isEmpty()) continue;
            return;
        }
        var0.add((Object)Pair.of((Object)var1, (Object)var2));
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Map<EntityHuman, Vec3D> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    public EntityLiving getSourceMob() {
        Entity var0;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof EntityTNTPrimed) {
            return ((EntityTNTPrimed)this.source).getOwner();
        }
        if (this.source instanceof EntityLiving) {
            return (EntityLiving)this.source;
        }
        if (this.source instanceof IProjectile && (var0 = ((IProjectile)this.source).getOwner()) instanceof EntityLiving) {
            return (EntityLiving)var0;
        }
        return null;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPosition> getToBlow() {
        return this.toBlow;
    }

    public static final class Effect
    extends Enum<Effect> {
        public static final /* enum */ Effect NONE = new Effect();
        public static final /* enum */ Effect BREAK = new Effect();
        public static final /* enum */ Effect DESTROY = new Effect();
        private static final /* synthetic */ Effect[] d;

        public static Effect[] values() {
            return (Effect[])d.clone();
        }

        public static Effect valueOf(String var0) {
            return Enum.valueOf(Effect.class, var0);
        }

        private static /* synthetic */ Effect[] a() {
            return new Effect[]{NONE, BREAK, DESTROY};
        }

        static {
            d = Effect.a();
        }
    }
}

