/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;

public class ChunkCoordIntPair {
    public static final long INVALID_CHUNK_POS = ChunkCoordIntPair.asLong(1875016, 1875016);
    public static final ChunkCoordIntPair ZERO = new ChunkCoordIntPair(0, 0);
    private static final long COORD_BITS = 32L;
    private static final long COORD_MASK = 0xFFFFFFFFL;
    private static final int REGION_BITS = 5;
    private static final int REGION_MASK = 31;
    public final int x;
    public final int z;
    private static final int HASH_A = 1664525;
    private static final int HASH_C = 1013904223;
    private static final int HASH_Z_XOR = -559038737;

    public ChunkCoordIntPair(int var0, int var1) {
        this.x = var0;
        this.z = var1;
    }

    public ChunkCoordIntPair(BlockPosition var0) {
        this.x = SectionPosition.blockToSectionCoord(var0.getX());
        this.z = SectionPosition.blockToSectionCoord(var0.getZ());
    }

    public ChunkCoordIntPair(long var0) {
        this.x = (int)var0;
        this.z = (int)(var0 >> 32);
    }

    public long toLong() {
        return ChunkCoordIntPair.asLong(this.x, this.z);
    }

    public static long asLong(int var0, int var1) {
        return (long)var0 & 0xFFFFFFFFL | ((long)var1 & 0xFFFFFFFFL) << 32;
    }

    public static long asLong(BlockPosition var0) {
        return ChunkCoordIntPair.asLong(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public static int getX(long var0) {
        return (int)(var0 & 0xFFFFFFFFL);
    }

    public static int getZ(long var0) {
        return (int)(var0 >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        int var0 = 1664525 * this.x + 1013904223;
        int var1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return var0 ^ var1;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChunkCoordIntPair) {
            ChunkCoordIntPair var1 = (ChunkCoordIntPair)var0;
            return this.x == var1.x && this.z == var1.z;
        }
        return false;
    }

    public int getMiddleBlockX() {
        return this.getBlockX(8);
    }

    public int getMiddleBlockZ() {
        return this.getBlockZ(8);
    }

    public int getMinBlockX() {
        return SectionPosition.sectionToBlockCoord(this.x);
    }

    public int getMinBlockZ() {
        return SectionPosition.sectionToBlockCoord(this.z);
    }

    public int getMaxBlockX() {
        return this.getBlockX(15);
    }

    public int getMaxBlockZ() {
        return this.getBlockZ(15);
    }

    public int getRegionX() {
        return this.x >> 5;
    }

    public int getRegionZ() {
        return this.z >> 5;
    }

    public int getRegionLocalX() {
        return this.x & 0x1F;
    }

    public int getRegionLocalZ() {
        return this.z & 0x1F;
    }

    public BlockPosition getBlockAt(int var0, int var1, int var2) {
        return new BlockPosition(this.getBlockX(var0), var1, this.getBlockZ(var2));
    }

    public int getBlockX(int var0) {
        return SectionPosition.sectionToBlockCoord(this.x, var0);
    }

    public int getBlockZ(int var0) {
        return SectionPosition.sectionToBlockCoord(this.z, var0);
    }

    public BlockPosition getMiddleBlockPosition(int var0) {
        return new BlockPosition(this.getMiddleBlockX(), var0, this.getMiddleBlockZ());
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public BlockPosition getWorldPosition() {
        return new BlockPosition(this.getMinBlockX(), 0, this.getMinBlockZ());
    }

    public int getChessboardDistance(ChunkCoordIntPair var0) {
        return Math.max(Math.abs(this.x - var0.x), Math.abs(this.z - var0.z));
    }

    public static Stream<ChunkCoordIntPair> rangeClosed(ChunkCoordIntPair var0, int var1) {
        return ChunkCoordIntPair.rangeClosed(new ChunkCoordIntPair(var0.x - var1, var0.z - var1), new ChunkCoordIntPair(var0.x + var1, var0.z + var1));
    }

    public static Stream<ChunkCoordIntPair> rangeClosed(final ChunkCoordIntPair var0, final ChunkCoordIntPair var1) {
        int var2 = Math.abs(var0.x - var1.x) + 1;
        int var3 = Math.abs(var0.z - var1.z) + 1;
        final int var4 = var0.x < var1.x ? 1 : -1;
        final int var5 = var0.z < var1.z ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkCoordIntPair>((long)(var2 * var3), 64){
            @Nullable
            private ChunkCoordIntPair pos;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkCoordIntPair> var02) {
                if (this.pos == null) {
                    this.pos = var0;
                } else {
                    int var12 = this.pos.x;
                    int var2 = this.pos.z;
                    if (var12 == var1.x) {
                        if (var2 == var1.z) {
                            return false;
                        }
                        this.pos = new ChunkCoordIntPair(var0.x, var2 + var5);
                    } else {
                        this.pos = new ChunkCoordIntPair(var12 + var4, var2);
                    }
                }
                var02.accept(this.pos);
                return true;
            }
        }, false);
    }
}

