/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public Map<Recipes<?>, Map<MinecraftKey, IRecipe<?>>> recipes = ImmutableMap.of();
    private boolean hasErrors;

    public CraftingManager() {
        super(GSON, "recipes");
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var02, IResourceManager var1, GameProfilerFiller var2) {
        this.hasErrors = false;
        HashMap var3 = Maps.newHashMap();
        for (Map.Entry<MinecraftKey, JsonElement> var5 : var02.entrySet()) {
            MinecraftKey var6 = var5.getKey();
            try {
                IRecipe<?> var7 = CraftingManager.fromJson(var6, ChatDeserializer.convertToJsonObject(var5.getValue(), "top element"));
                var3.computeIfAbsent(var7.getType(), var0 -> ImmutableMap.builder()).put((Object)var6, var7);
            }
            catch (JsonParseException | IllegalArgumentException var7) {
                LOGGER.error("Parsing error loading recipe {}", (Object)var6, (Object)var7);
            }
        }
        this.recipes = (Map)var3.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((ImmutableMap.Builder)var0.getValue()).build()));
        LOGGER.info("Loaded {} recipes", (Object)var3.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> getRecipeFor(Recipes<T> var0, C var1, World var2) {
        return this.byType(var0).values().stream().flatMap(var3 -> SystemUtils.toStream(var0.tryMatch(var3, var2, var1))).findFirst();
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> getAllRecipesFor(Recipes<T> var02) {
        return this.byType(var02).values().stream().map(var0 -> var0).collect(Collectors.toList());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> getRecipesFor(Recipes<T> var02, C var1, World var2) {
        return this.byType(var02).values().stream().flatMap(var3 -> SystemUtils.toStream(var02.tryMatch(var3, var2, var1))).sorted(Comparator.comparing(var0 -> var0.getResultItem().getDescriptionId())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<MinecraftKey, IRecipe<C>> byType(Recipes<T> var0) {
        return this.recipes.getOrDefault(var0, Collections.emptyMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> var0, C var1, World var2) {
        Optional<T> var3 = this.getRecipeFor(var0, var1, var2);
        if (var3.isPresent()) {
            return ((IRecipe)var3.get()).getRemainingItems(var1);
        }
        NonNullList<ItemStack> var4 = NonNullList.withSize(var1.getContainerSize(), ItemStack.EMPTY);
        for (int var5 = 0; var5 < var4.size(); ++var5) {
            var4.set(var5, var1.getItem(var5));
        }
        return var4;
    }

    public Optional<? extends IRecipe<?>> byKey(MinecraftKey var0) {
        return this.recipes.values().stream().map(var1 -> (IRecipe)var1.get(var0)).filter(Objects::nonNull).findFirst();
    }

    public Collection<IRecipe<?>> getRecipes() {
        return this.recipes.values().stream().flatMap(var0 -> var0.values().stream()).collect(Collectors.toSet());
    }

    public Stream<MinecraftKey> getRecipeIds() {
        return this.recipes.values().stream().flatMap(var0 -> var0.keySet().stream());
    }

    public static IRecipe<?> fromJson(MinecraftKey var0, JsonObject var1) {
        String var2 = ChatDeserializer.getAsString(var1, "type");
        return IRegistry.RECIPE_SERIALIZER.getOptional(new MinecraftKey(var2)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + var2 + "'")).fromJson(var0, var1);
    }

    public void replaceRecipes(Iterable<IRecipe<?>> var0) {
        this.hasErrors = false;
        HashMap var12 = Maps.newHashMap();
        var0.forEach(var1 -> {
            Map var2 = var12.computeIfAbsent(var1.getType(), var0 -> Maps.newHashMap());
            IRecipe var3 = var2.put(var1.getId(), var1);
            if (var3 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + var1.getId());
            }
        });
        this.recipes = ImmutableMap.copyOf((Map)var12);
    }
}

