/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemPotion
extends Item {
    private static final int DRINK_DURATION = 32;

    public ItemPotion(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack getDefaultInstance() {
        return PotionUtil.setPotion(super.getDefaultInstance(), Potions.WATER);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        EntityHuman var3;
        EntityHuman entityHuman = var3 = var2 instanceof EntityHuman ? (EntityHuman)var2 : null;
        if (var3 instanceof EntityPlayer) {
            CriterionTriggers.CONSUME_ITEM.trigger((EntityPlayer)var3, var0);
        }
        if (!var1.isClientSide) {
            List<MobEffect> var4 = PotionUtil.getMobEffects(var0);
            for (MobEffect var6 : var4) {
                if (var6.getEffect().isInstantenous()) {
                    var6.getEffect().applyInstantenousEffect(var3, var3, var2, var6.getAmplifier(), 1.0);
                    continue;
                }
                var2.addEffect(new MobEffect(var6));
            }
        }
        if (var3 != null) {
            var3.awardStat(StatisticList.ITEM_USED.get(this));
            if (!var3.getAbilities().instabuild) {
                var0.shrink(1);
            }
        }
        if (var3 == null || !var3.getAbilities().instabuild) {
            if (var0.isEmpty()) {
                return new ItemStack(Items.GLASS_BOTTLE);
            }
            if (var3 != null) {
                var3.getInventory().add(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        var1.gameEvent((Entity)var2, GameEvent.DRINKING_FINISH, var2.eyeBlockPosition());
        return var0;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 32;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.DRINK;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public String getDescriptionId(ItemStack var0) {
        return PotionUtil.getPotion(var0).getName(this.getDescriptionId() + ".effect.");
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        PotionUtil.addPotionTooltip(var0, var2, 1.0f);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return super.isFoil(var0) || !PotionUtil.getMobEffects(var0).isEmpty();
    }

    @Override
    public void fillItemCategory(CreativeModeTab var0, NonNullList<ItemStack> var1) {
        if (this.allowdedIn(var0)) {
            for (PotionRegistry var3 : IRegistry.POTION) {
                if (var3 == Potions.EMPTY) continue;
                var1.add(PotionUtil.setPotion(new ItemStack(this), var3));
            }
        }
    }
}

