/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;

public class EntityMinecartRideable
extends EntityMinecartAbstract {
    public EntityMinecartRideable(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    public EntityMinecartRideable(World var0, double var1, double var3, double var5) {
        super(EntityTypes.MINECART, var0, var1, var3, var5);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (var0.isSecondaryUseActive()) {
            return EnumInteractionResult.PASS;
        }
        if (this.isVehicle()) {
            return EnumInteractionResult.PASS;
        }
        if (!this.level.isClientSide) {
            return var0.startRiding(this) ? EnumInteractionResult.CONSUME : EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
        if (var3) {
            if (this.isVehicle()) {
                this.ejectPassengers();
            }
            if (this.getHurtTime() == 0) {
                this.setHurtDir(-this.getHurtDir());
                this.setHurtTime(10);
                this.setDamage(50.0f);
                this.markHurt();
            }
        }
    }

    @Override
    public EntityMinecartAbstract.EnumMinecartType getMinecartType() {
        return EntityMinecartAbstract.EnumMinecartType.RIDEABLE;
    }
}

