/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements IInventory,
ITileInventory {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize(36, ItemStack.EMPTY);
    @Nullable
    public MinecraftKey lootTable;
    public long lootTableSeed;

    protected EntityMinecartContainer(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    protected EntityMinecartContainer(EntityTypes<?> var0, double var1, double var3, double var5, World var7) {
        super(var0, var7, var1, var3, var5);
    }

    @Override
    public void destroy(DamageSource var0) {
        super.destroy(var0);
        if (this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Entity var1;
            InventoryUtils.dropContents(this.level, this, (IInventory)this);
            if (!this.level.isClientSide && (var1 = var0.getDirectEntity()) != null && var1.getType() == EntityTypes.PLAYER) {
                PiglinAI.angerNearbyPiglins((EntityHuman)var1, true);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.itemStacks) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        this.unpackLootTable(null);
        return this.itemStacks.get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        this.unpackLootTable(null);
        return ContainerUtil.removeItem(this.itemStacks, var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        this.unpackLootTable(null);
        ItemStack var1 = this.itemStacks.get(var0);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.itemStacks.set(var0, ItemStack.EMPTY);
        return var1;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.unpackLootTable(null);
        this.itemStacks.set(var0, var1);
        if (!var1.isEmpty() && var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
    }

    @Override
    public SlotAccess getSlot(final int var0) {
        if (var0 >= 0 && var0 < this.getContainerSize()) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return EntityMinecartContainer.this.getItem(var0);
                }

                @Override
                public boolean set(ItemStack var02) {
                    EntityMinecartContainer.this.setItem(var0, var02);
                    return true;
                }
            };
        }
        return super.getSlot(var0);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.isRemoved()) {
            return false;
        }
        return !(var0.distanceToSqr(this) > 64.0);
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        if (!this.level.isClientSide && var0.shouldDestroy()) {
            InventoryUtils.dropContents(this.level, this, (IInventory)this);
        }
        super.remove(var0);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.lootTable != null) {
            var0.putString("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                var0.putLong("LootTableSeed", this.lootTableSeed);
            }
        } else {
            ContainerUtil.saveAllItems(var0, this.itemStacks);
        }
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (var0.contains("LootTable", 8)) {
            this.lootTable = new MinecraftKey(var0.getString("LootTable"));
            this.lootTableSeed = var0.getLong("LootTableSeed");
        } else {
            ContainerUtil.loadAllItems(var0, this.itemStacks);
        }
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        var0.openMenu(this);
        if (!var0.level.isClientSide) {
            this.gameEvent(GameEvent.CONTAINER_OPEN, var0);
            PiglinAI.angerNearbyPiglins(var0, true);
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void applyNaturalSlowdown() {
        float var0 = 0.98f;
        if (this.lootTable == null) {
            int var1 = 15 - Container.getRedstoneSignalFromContainer(this);
            var0 += (float)var1 * 0.001f;
        }
        if (this.isInWater()) {
            var0 *= 0.95f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(var0, 0.0, var0));
    }

    public void unpackLootTable(@Nullable EntityHuman var0) {
        if (this.lootTable != null && this.level.getServer() != null) {
            LootTable var1 = this.level.getServer().getLootTables().get(this.lootTable);
            if (var0 instanceof EntityPlayer) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, this.lootTable);
            }
            this.lootTable = null;
            LootTableInfo.Builder var2 = new LootTableInfo.Builder((WorldServer)this.level).withParameter(LootContextParameters.ORIGIN, this.position()).withOptionalRandomSeed(this.lootTableSeed);
            if (var0 != null) {
                var2.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var1.fill(this, var2.create(LootContextParameterSets.CHEST));
        }
    }

    @Override
    public void clearContent() {
        this.unpackLootTable(null);
        this.itemStacks.clear();
    }

    public void setLootTable(MinecraftKey var0, long var1) {
        this.lootTable = var0;
        this.lootTableSeed = var1;
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.lootTable == null || !var2.isSpectator()) {
            this.unpackLootTable(var1.player);
            return this.createMenu(var0, var1);
        }
        return null;
    }

    protected abstract Container createMenu(int var1, PlayerInventory var2);
}

