/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityFishingHook
extends IProjectile {
    private final Random syncronizedRandom = new Random();
    private boolean biting;
    private int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    public static final DataWatcherObject<Integer> DATA_HOOKED_ENTITY = DataWatcher.defineId(EntityFishingHook.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_BITING = DataWatcher.defineId(EntityFishingHook.class, DataWatcherRegistry.BOOLEAN);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    public Entity hookedIn;
    public HookState currentState = HookState.FLYING;
    private final int luck;
    private final int lureSpeed;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> var0, World var1, int var2, int var3) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
        this.noCulling = true;
        this.luck = Math.max(0, var2);
        this.lureSpeed = Math.max(0, var3);
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> var0, World var1) {
        this(var0, var1, 0, 0);
    }

    public EntityFishingHook(EntityHuman var0, World var1, int var2, int var3) {
        this(EntityTypes.FISHING_BOBBER, var1, var2, var3);
        this.setOwner(var0);
        float var4 = var0.getXRot();
        float var5 = var0.getYRot();
        float var6 = MathHelper.cos(-var5 * ((float)Math.PI / 180) - (float)Math.PI);
        float var7 = MathHelper.sin(-var5 * ((float)Math.PI / 180) - (float)Math.PI);
        float var8 = -MathHelper.cos(-var4 * ((float)Math.PI / 180));
        float var9 = MathHelper.sin(-var4 * ((float)Math.PI / 180));
        double var10 = var0.getX() - (double)var7 * 0.3;
        double var12 = var0.getEyeY();
        double var14 = var0.getZ() - (double)var6 * 0.3;
        this.moveTo(var10, var12, var14, var5, var4);
        Vec3D var16 = new Vec3D(-var7, MathHelper.clamp(-(var9 / var8), -5.0f, 5.0f), -var6);
        double var17 = var16.length();
        var16 = var16.multiply(0.6 / var17 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / var17 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / var17 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(var16);
        this.setYRot((float)(MathHelper.atan2(var16.x, var16.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(var16.y, var16.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_HOOKED_ENTITY, 0);
        this.getEntityData().define(DATA_BITING, false);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_HOOKED_ENTITY.equals(var0)) {
            int var1 = this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = var1 > 0 ? this.level.getEntity(var1 - 1) : null;
        }
        if (DATA_BITING.equals(var0)) {
            this.biting = this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * MathHelper.nextFloat(this.syncronizedRandom, 0.6f, 1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = 64.0;
        return var0 < 4096.0;
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
    }

    @Override
    public void tick() {
        boolean var4;
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level.getGameTime());
        super.tick();
        EntityHuman var0 = this.getPlayerOwner();
        if (var0 == null) {
            this.discard();
            return;
        }
        if (!this.level.isClientSide && this.shouldStopFishing(var0)) {
            return;
        }
        if (this.onGround) {
            ++this.life;
            if (this.life >= 1200) {
                this.discard();
                return;
            }
        } else {
            this.life = 0;
        }
        float var1 = 0.0f;
        BlockPosition var2 = this.blockPosition();
        Fluid var3 = this.level.getFluidState(var2);
        if (var3.is(TagsFluid.WATER)) {
            var1 = var3.getHeight(this.level, var2);
        }
        boolean bl = var4 = var1 > 0.0f;
        if (this.currentState == HookState.FLYING) {
            if (this.hookedIn != null) {
                this.setDeltaMovement(Vec3D.ZERO);
                this.currentState = HookState.HOOKED_IN_ENTITY;
                return;
            }
            if (var4) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                this.currentState = HookState.BOBBING;
                return;
            }
            this.checkCollision();
        } else {
            if (this.currentState == HookState.HOOKED_IN_ENTITY) {
                if (this.hookedIn != null) {
                    if (this.hookedIn.isRemoved() || this.hookedIn.level.dimension() != this.level.dimension()) {
                        this.setHookedEntity(null);
                        this.currentState = HookState.FLYING;
                    } else {
                        this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                    }
                }
                return;
            }
            if (this.currentState == HookState.BOBBING) {
                Vec3D var5 = this.getDeltaMovement();
                double var6 = this.getY() + var5.y - (double)var2.getY() - (double)var1;
                if (Math.abs(var6) < 0.01) {
                    var6 += Math.signum(var6) * 0.1;
                }
                this.setDeltaMovement(var5.x * 0.9, var5.y - var6 * (double)this.random.nextFloat() * 0.2, var5.z * 0.9);
                this.openWater = this.nibble > 0 || this.timeUntilHooked > 0 ? this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(var2) : true;
                if (var4) {
                    this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                    if (this.biting) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                    }
                    if (!this.level.isClientSide) {
                        this.catchingFish(var2);
                    }
                } else {
                    this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                }
            }
        }
        if (!var3.is(TagsFluid.WATER)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.updateRotation();
        if (this.currentState == HookState.FLYING && (this.onGround || this.horizontalCollision)) {
            this.setDeltaMovement(Vec3D.ZERO);
        }
        double var5 = 0.92;
        this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        this.reapplyPosition();
    }

    private boolean shouldStopFishing(EntityHuman var0) {
        ItemStack var1 = var0.getMainHandItem();
        ItemStack var2 = var0.getOffhandItem();
        boolean var3 = var1.is(Items.FISHING_ROD);
        boolean var4 = var2.is(Items.FISHING_ROD);
        if (var0.isRemoved() || !var0.isAlive() || !var3 && !var4 || this.distanceToSqr(var0) > 1024.0) {
            this.discard();
            return true;
        }
        return false;
    }

    private void checkCollision() {
        MovingObjectPosition var0 = ProjectileHelper.getHitResult(this, this::canHitEntity);
        this.onHit(var0);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) || var0.isAlive() && var0 instanceof EntityItem;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        if (!this.level.isClientSide) {
            this.setHookedEntity(var0.getEntity());
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(var0.distanceTo(this)));
    }

    public void setHookedEntity(@Nullable Entity var0) {
        this.hookedIn = var0;
        this.getEntityData().set(DATA_HOOKED_ENTITY, var0 == null ? 0 : var0.getId() + 1);
    }

    private void catchingFish(BlockPosition var0) {
        WorldServer var1 = (WorldServer)this.level;
        int var2 = 1;
        BlockPosition var3 = var0.above();
        if (this.random.nextFloat() < 0.25f && this.level.isRainingAt(var3)) {
            ++var2;
        }
        if (this.random.nextFloat() < 0.5f && !this.level.canSeeSky(var3)) {
            --var2;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= var2;
            if (this.timeUntilHooked > 0) {
                double var11;
                double var9;
                this.fishAngle = (float)((double)this.fishAngle + this.random.nextGaussian() * 4.0);
                float var4 = this.fishAngle * ((float)Math.PI / 180);
                float var5 = MathHelper.sin(var4);
                float var6 = MathHelper.cos(var4);
                double var7 = this.getX() + (double)(var5 * (float)this.timeUntilHooked * 0.1f);
                IBlockData var13 = var1.getBlockState(new BlockPosition(var7, (var9 = (double)((float)MathHelper.floor(this.getY()) + 1.0f)) - 1.0, var11 = this.getZ() + (double)(var6 * (float)this.timeUntilHooked * 0.1f)));
                if (var13.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        var1.sendParticles(Particles.BUBBLE, var7, var9 - (double)0.1f, var11, 1, var5, 0.1, var6, 0.0);
                    }
                    float var14 = var5 * 0.04f;
                    float var15 = var6 * 0.04f;
                    var1.sendParticles(Particles.FISHING, var7, var9, var11, 0, var15, 0.01, -var14, 1.0);
                    var1.sendParticles(Particles.FISHING, var7, var9, var11, 0, -var15, 0.01, var14, 1.0);
                }
            } else {
                this.playSound(SoundEffects.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double var4 = this.getY() + 0.5;
                var1.sendParticles(Particles.BUBBLE, this.getX(), var4, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                var1.sendParticles(Particles.FISHING, this.getX(), var4, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                this.nibble = MathHelper.nextInt(this.random, 20, 40);
                this.getEntityData().set(DATA_BITING, true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= var2;
            float var4 = 0.15f;
            if (this.timeUntilLured < 20) {
                var4 = (float)((double)var4 + (double)(20 - this.timeUntilLured) * 0.05);
            } else if (this.timeUntilLured < 40) {
                var4 = (float)((double)var4 + (double)(40 - this.timeUntilLured) * 0.02);
            } else if (this.timeUntilLured < 60) {
                var4 = (float)((double)var4 + (double)(60 - this.timeUntilLured) * 0.01);
            }
            if (this.random.nextFloat() < var4) {
                double var11;
                double var9;
                float var5 = MathHelper.nextFloat(this.random, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float var6 = MathHelper.nextFloat(this.random, 25.0f, 60.0f);
                double var7 = this.getX() + (double)(MathHelper.sin(var5) * var6 * 0.1f);
                IBlockData var13 = var1.getBlockState(new BlockPosition(var7, (var9 = (double)((float)MathHelper.floor(this.getY()) + 1.0f)) - 1.0, var11 = this.getZ() + (double)(MathHelper.cos(var5) * var6 * 0.1f)));
                if (var13.is(Blocks.WATER)) {
                    var1.sendParticles(Particles.SPLASH, var7, var9, var11, 2 + this.random.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = MathHelper.nextFloat(this.random, 0.0f, 360.0f);
                this.timeUntilHooked = MathHelper.nextInt(this.random, 20, 80);
            }
        } else {
            this.timeUntilLured = MathHelper.nextInt(this.random, 100, 600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    private boolean calculateOpenWater(BlockPosition var0) {
        WaterPosition var1 = WaterPosition.INVALID;
        for (int var2 = -1; var2 <= 2; ++var2) {
            WaterPosition var3 = this.getOpenWaterTypeForArea(var0.offset(-2, var2, -2), var0.offset(2, var2, 2));
            switch (var3) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (var1 != WaterPosition.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (var1 != WaterPosition.ABOVE_WATER) break;
                    return false;
                }
            }
            var1 = var3;
        }
        return true;
    }

    private WaterPosition getOpenWaterTypeForArea(BlockPosition var02, BlockPosition var12) {
        return BlockPosition.betweenClosedStream(var02, var12).map(this::getOpenWaterTypeForBlock).reduce((var0, var1) -> var0 == var1 ? var0 : WaterPosition.INVALID).orElse(WaterPosition.INVALID);
    }

    private WaterPosition getOpenWaterTypeForBlock(BlockPosition var0) {
        IBlockData var1 = this.level.getBlockState(var0);
        if (var1.isAir() || var1.is(Blocks.LILY_PAD)) {
            return WaterPosition.ABOVE_WATER;
        }
        Fluid var2 = var1.getFluidState();
        if (var2.is(TagsFluid.WATER) && var2.isSource() && var1.getCollisionShape(this.level, var0).isEmpty()) {
            return WaterPosition.INSIDE_WATER;
        }
        return WaterPosition.INVALID;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
    }

    public int retrieve(ItemStack var0) {
        EntityHuman var1 = this.getPlayerOwner();
        if (this.level.isClientSide || var1 == null || this.shouldStopFishing(var1)) {
            return 0;
        }
        int var2 = 0;
        if (this.hookedIn != null) {
            this.pullEntity(this.hookedIn);
            CriterionTriggers.FISHING_ROD_HOOKED.trigger((EntityPlayer)var1, var0, this, Collections.emptyList());
            this.level.broadcastEntityEvent(this, (byte)31);
            var2 = this.hookedIn instanceof EntityItem ? 3 : 5;
        } else if (this.nibble > 0) {
            LootTableInfo.Builder var3 = new LootTableInfo.Builder((WorldServer)this.level).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.TOOL, var0).withParameter(LootContextParameters.THIS_ENTITY, this).withRandom(this.random).withLuck((float)this.luck + var1.getLuck());
            LootTable var4 = this.level.getServer().getLootTables().get(LootTables.FISHING);
            List<ItemStack> var5 = var4.getRandomItems(var3.create(LootContextParameterSets.FISHING));
            CriterionTriggers.FISHING_ROD_HOOKED.trigger((EntityPlayer)var1, var0, this, var5);
            for (ItemStack var7 : var5) {
                EntityItem var8 = new EntityItem(this.level, this.getX(), this.getY(), this.getZ(), var7);
                double var9 = var1.getX() - this.getX();
                double var11 = var1.getY() - this.getY();
                double var13 = var1.getZ() - this.getZ();
                double var15 = 0.1;
                var8.setDeltaMovement(var9 * 0.1, var11 * 0.1 + Math.sqrt(Math.sqrt(var9 * var9 + var11 * var11 + var13 * var13)) * 0.08, var13 * 0.1);
                this.level.addFreshEntity(var8);
                var1.level.addFreshEntity(new EntityExperienceOrb(var1.level, var1.getX(), var1.getY() + 0.5, var1.getZ() + 0.5, this.random.nextInt(6) + 1));
                if (!var7.is(TagsItem.FISHES)) continue;
                var1.awardStat(StatisticList.FISH_CAUGHT, 1);
            }
            var2 = 1;
        }
        if (this.onGround) {
            var2 = 2;
        }
        this.discard();
        return var2;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 31 && this.level.isClientSide && this.hookedIn instanceof EntityHuman && ((EntityHuman)this.hookedIn).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(var0);
    }

    public void pullEntity(Entity var0) {
        Entity var1 = this.getOwner();
        if (var1 == null) {
            return;
        }
        Vec3D var2 = new Vec3D(var1.getX() - this.getX(), var1.getY() - this.getY(), var1.getZ() - this.getZ()).scale(0.1);
        var0.setDeltaMovement(var0.getDeltaMovement().add(var2));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        this.updateOwnerInfo(null);
        super.remove(var0);
    }

    @Override
    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void setOwner(@Nullable Entity var0) {
        super.setOwner(var0);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable EntityFishingHook var0) {
        EntityHuman var1 = this.getPlayerOwner();
        if (var1 != null) {
            var1.fishing = var0;
        }
    }

    @Nullable
    public EntityHuman getPlayerOwner() {
        Entity var0 = this.getOwner();
        return var0 instanceof EntityHuman ? (EntityHuman)var0 : null;
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    @Override
    public boolean canChangeDimensions() {
        return false;
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        Entity var0 = this.getOwner();
        return new PacketPlayOutSpawnEntity(this, var0 == null ? this.getId() : var0.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        if (this.getPlayerOwner() == null) {
            int var1 = var0.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level.getEntity(var1), (Object)var1);
            this.kill();
        }
    }

    public static final class HookState
    extends Enum<HookState> {
        public static final /* enum */ HookState FLYING = new HookState();
        public static final /* enum */ HookState HOOKED_IN_ENTITY = new HookState();
        public static final /* enum */ HookState BOBBING = new HookState();
        private static final /* synthetic */ HookState[] d;

        public static HookState[] values() {
            return (HookState[])d.clone();
        }

        public static HookState valueOf(String var0) {
            return Enum.valueOf(HookState.class, var0);
        }

        private static /* synthetic */ HookState[] a() {
            return new HookState[]{FLYING, HOOKED_IN_ENTITY, BOBBING};
        }

        static {
            d = HookState.a();
        }
    }

    static final class WaterPosition
    extends Enum<WaterPosition> {
        public static final /* enum */ WaterPosition ABOVE_WATER = new WaterPosition();
        public static final /* enum */ WaterPosition INSIDE_WATER = new WaterPosition();
        public static final /* enum */ WaterPosition INVALID = new WaterPosition();
        private static final /* synthetic */ WaterPosition[] d;

        public static WaterPosition[] values() {
            return (WaterPosition[])d.clone();
        }

        public static WaterPosition valueOf(String var0) {
            return Enum.valueOf(WaterPosition.class, var0);
        }

        private static /* synthetic */ WaterPosition[] a() {
            return new WaterPosition[]{ABOVE_WATER, INSIDE_WATER, INVALID};
        }

        static {
            d = WaterPosition.a();
        }
    }
}

